# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys

from unittest.mock import MagicMock

sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..', 'src'))

class Mock(MagicMock):
    @classmethod
    def __getattr__(cls, name):
        return MagicMock()

sys.modules.update((module, Mock()) for module in (
    'auth_helpers',
    'google',
    'google.assistant',
    'google.assistant.embedded',
    'google.assistant.embedded.v1alpha2',
    'google.assistant.library',
    'google.auth',
    'google.auth.transport',
    'google.auth.transport.grpc',
    'google.auth.transport.requests',
    'google.cloud',
    'google.protobuf',
    'google_auth_oauthlib',
    'google_auth_oauthlib.flow',
    'google.oauth2',
    'google.oauth2.credentials',
    'gpiozero',
    'gpiozero.exc',
    'gpiozero.threads',
    'grpc',
    'picamera',
    'RPi'))

utils = MagicMock()
utils.load_labels = MagicMock(return_value=())
utils.load_ssd_anchors = MagicMock(return_value=())
utils.__all__ = ('load_labels', 'load_ssd_anchors')
sys.modules.update([('aiy.vision.models.utils', utils)])

# -- Project information -----------------------------------------------------

project = 'AIY Projects'
copyright = '2018, Google LLC'
author = 'Google LLC'

# The short X.Y version
version = ''
# The full version, including alpha/beta/rc tags
release = '2018-11-16'


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx', # Enables linking to other libs like gpiozero
    'sphinx.ext.coverage',
    'sphinx.ext.napoleon', # Converts Google-style code comments to RST
    'sphinx.ext.extlinks', # Enables arbitrary link shorthand like 'github'
]

# Config for the extlinks extension
extlinks = {'github': ('https://github.com/google/aiyprojects-raspbian/tree/aiyprojects/%s',
                       ''),
            'assistant': ('https://developers.google.com/assistant/sdk/reference/library/python/#%s',
                          ''),
            'assistant-rpc': ('https://developers.google.com/assistant/sdk/reference/rpc/#%s',
                          '')}

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

source_parsers = {
    '.md': 'recommonmark.parser.CommonMarkParser',
}

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = ['.rst', '.md']

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store', 'README*']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Left nav header
# html_logo = '_static/images/aiy-logo-white.svg'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Add our custom stylesheet. By default, Sphinx looks for this in _static/.
def setup(app):
    app.add_stylesheet('custom.css')

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'AIYProjectsdoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'AIYProjects.tex', 'AIY Projects Documentation',
     'Google LLC', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'aiyprojects', 'AIY Projects Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'AIYProjects', 'AIY Projects Documentation',
     author, 'AIYProjects', 'One line description of project.',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
# Controls external linking to other python libraries
intersphinx_mapping = {
    'python': ('https://docs.python.org/', None),
    'gpiozero': ('https://gpiozero.readthedocs.io/en/stable/', None)
}
