# gatsby-starter-typescript

[![Build Status](https://travis-ci.org/goblindegook/gatsby-starter-typescript.svg?branch=master)](https://travis-ci.org/goblindegook/gatsby-starter-typescript)

A Gatsby starter using [TypeScript](https://www.typescriptlang.org) and [emotion](https://emotion.sh).

View the [demo site](https://gatsby-starter-typescript.netlify.com).

## Install

Make sure that you have the Gatsby CLI program installed:

```sh
$ npm install --global gatsby-cli
```

And run from your CLI:

```sh
$ gatsby new gatsby-example-site https://github.com/goblindegook/gatsby-starter-typescript
```

Then you can run it by:

```sh
$ cd gatsby-example-site
$ npm run develop
```

## Gatsby Plugins

- gatsby-plugin-catch-links
- gatsby-plugin-emotion
- gatsby-plugin-feed
- gatsby-plugin-lunr
- gatsby-plugin-manifest
- gatsby-plugin-mdx
- gatsby-plugin-netlify
- gatsby-plugin-nprogress
- gatsby-plugin-offline
- gatsby-plugin-react-helmet
- gatsby-plugin-sharp
- gatsby-plugin-sitemap
- gatsby-plugin-typegen
- gatsby-plugin-typescript
- gatsby-plugin-typography
- gatsby-remark-copy-linked-files
- gatsby-remark-images
- gatsby-remark-prismjs
- gatsby-remark-smartypants
- gatsby-source-filesystem
- gatsby-transformer-sharp

## Tools

- Testing: [Jest](https://jestjs.io) and [react-testing-library](https://github.com/testing-library/react-testing-library)
- Linter: [ESLint](https://eslint.org) with support for TypeScript, React, [Standard](https://standardjs.com) and [Prettier](https://prettier.io).
