# Development Tools
Stumpless uses both custom and external tools to make development easier,
implement features, and maintain the code base. This directory has files that
are specific to these tools such as configuration files and scripts.


## [`check_headers`](./check_headers)
A custom tool written to make sure that appropriate headers are included in
sources according to project conventions.


## [`cmake`](./cmake)
CMake scripts used in the configuration and build of Stumpless.


## [`doxygen`](./doxygen)
Configuration files for generating project documentation with Doxygen.


## [`pkg-config`](./pkg-config)
Configuration for `pkg-config` support.


## [`portage`](./portage)
Packaging files for Gentoo's Portage system.


## [`sonar`](./sonar)
Configuration for Sonarcloud code scanning and analysis.


## [`valgrind`](./valgrind)
Configuration files for valgrind, including false positive annotations.


## [`wrapture`](./wrapture)
Templates for generating C++ language bindings with Wrapture.
