# Functionality Testing
Functionality testing of the library consists of several tests on the
exposed interfaces. These tests use the Google Test framework to execute, which
must be available in order for the tests to build.


## `config`
Test suites that are specific to particular configuration options.

## `leak`
Test suites for memory leaks.


## `level`
Test suites to ensure that severity level filters function correctly.


## `python`
Test suites for the python extension of the library.


## `target`
Test suites for specific target types.


## `element.cpp`
Tests functions that deal with elements.


## `entry.cpp`
Tests functions that deal with entries.


## `error.cpp`
Tests error handling and querying functions.


## `filter.cpp`
Tests for the filters that are included with the library.


## `memory.cpp`
Tests for the memory handling routines of the library.


## `param.cpp`
Tests functions that deal with params.


## `severity.cpp`
Tests for functions that deal with severities.


## `target.cpp`
Tests for general target functionality.


## `version.cpp`
Tests for versioning of the library.


## `priority.cpp`
Tests for functions that deal with priority values (PRIVAL).
