/* SPDX-License-Identifier: Apache-2.0 */

/*
 * Copyright 2020-2024 Joel E. Anderson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** @file
 * India Telugu localization strings.
 */

#ifndef __STUMPLESS_PRIVATE_CONFIG_LOCALE_TE_IN_H
#  define __STUMPLESS_PRIVATE_CONFIG_LOCALE_TE_IN_H

#  define L10N_BIND_UNIX_SOCKET_FAILED_ERROR_MESSAGE \
"స్థానిక యునిక్స్ సాకెట్కు బంధించబడలేదు"

#  define L10N_BUFFER_TOO_SMALL_ERROR_MESSAGE \
"ఇచ్చిన సందేశానికి బఫర్ చాలా చిన్నది"

// todo translate
#  define L10N_CHAIN_TARGETS_UNSUPPORTED \
"chain targets are not supported by this build"

#  define L10N_CLOSE_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"మద్దతు లేని లక్ష్య రకాన్ని మూసివేయడానికి ప్రయత్నించారు"

#  define L10N_COMMIT_TRANSACTION_FAILED_ERROR_MESSAGE \
"కమిట్ ట్రాన్సాక్షన్ విఫలమైంది"

#  define L10N_CONNECT_SYS_SOCKET_FAILED_ERROR_MESSAGE \
"sys/socket.h సాకెట్తో కనెక్ట్ చేయడం విఫలమైంది"

#  define L10N_CONNECT_WIN_SOCKET_FAILED_ERROR_MESSAGE \
"విన్సాక్2 సాకెట్తో కనెక్ట్ చేయడం విఫలమైంది"

#  define L10N_CREATE_TRANSACTION_FAILED_ERROR_MESSAGE \
"CreateTransaction విఫలమైంది"

#  define L10N_DESTINATION_NETWORK_ONLY_ERROR_MESSAGE \
"గమ్యం నెట్వర్క్ లక్ష్యాలకు మాత్రమే చెల్లుతుంది"

#  define L10N_DUPLICATE_ELEMENT_ERROR_MESSAGE \
"అందించిన పేరుతో ఒక మూలకం ఇప్పటికే ఈ ఎంట్రీలో ఉంది"

#  define L10N_ELEMENT_NOT_FOUND_ERROR_MESSAGE \
"పేర్కొన్న లక్షణాలతో ఒక మూలకం కనుగొనబడలేదు"

#  define L10N_ERRNO_ERROR_CODE_TYPE \
"విఫలమైన కాల్ తర్వాత తప్పు"

#  define L10N_FILE_OPEN_FAILURE_ERROR_MESSAGE \
"పేర్కొన్న ఫైల్ను తెరవడం సాధ్యం కాలేదు"

#  define L10N_FILE_WRITE_FAILURE_ERROR_MESSAGE \
"ఫైల్కి వ్రాయడం సాధ్యం కాలేదు"

#  define L10N_FORMAT_ERROR_MESSAGE(ARG) \
"చెల్లని" ARG " ఫార్మాట్"

#  define L10N_FUNCTION_TARGET_FAILURE_CODE_TYPE \
"లాగ్ హ్యాండ్లర్ ఫంక్షన్ యొక్క రిటర్న్ కోడ్"

#  define L10N_FUNCTION_TARGET_FAILURE_ERROR_MESSAGE \
"ఫంక్షన్ లక్ష్యం కోసం లాగ్ హ్యాండ్లర్ విఫలమైంది"

#  define L10N_GETADDRINFO_FAILURE_ERROR_MESSAGE \
"అందించిన హోస్ట్ పేరులో getaddrinfo విఫలమైంది"

#  define L10N_GETADDRINFO_RETURN_ERROR_CODE_TYPE \
"విఫలమైన getaddrinfo కాల్ రిటర్న్ కోడ్"

#  define L10N_GETCOMPUTERNAME_FAILED_ERROR_MESSAGE \
"కంప్యూటర్ పేరు తెలుసుకోలేదు"

#  define L10N_GETHOSTNAME_FAILED_ERROR_MESSAGE \
"గెథోస్ట్ పేరు విఫలమైంది"

#  define L10N_GETLASTERROR_ERROR_CODE_TYPE \
"విఫలమైన కాల్ తర్వాత GetLastError ఫలితం"

#  define L10N_GETMODULEFILENAMEW_FAILED_ERROR_MESSAGE \
"GetModuleFileNameW విఫలమైంది"

#  define L10N_GETMODULEHANDLEXW_FAILED_ERROR_MESSAGE \
"GetModuleHandleExW విఫలమైంది"

#  define L10N_INDEX_OUT_OF_BOUNDS_ERROR_CODE_TYPE \
"నెగేటివ్ ఇండెక్స్ కలిగిన సూచిక చిన్నది"

#  define L10N_INVALID_FACILITY_ERROR_CODE_TYPE \
"చెల్లని సౌకర్యం"

#  define L10N_INVALID_FACILITY_ERROR_MESSAGE \
"సౌకర్యాల కోడ్లు RFC 5424 ప్రకారం, 8 గుణకారం"

#  define L10N_INVALID_ID_ERROR_MESSAGE \
"చెల్లని లక్ష్యం ఐడి"

#  define L10N_INVALID_INDEX_ERROR_MESSAGE( INDEXED_THING ) \
"చెల్లని " INDEXED_THING " సూచిక"

#  define L10N_INVALID_MULTI_SZ_ERROR_MESSAGE \
"మల్టీ_ఎస్జెడ్ విలువ తప్పుగా ఉంది"

#  define L10N_INVALID_PARAM_ERROR_MESSAGE \
"స్ట్రింగ్ పేరు=\"విలువ\" ఆకృతికి సంబంధించినది కాదు"

#  define L10N_INVALID_SEVERITY_ERROR_CODE_TYPE \
"చెల్లని తీవ్రత"

#  define L10N_INVALID_SEVERITY_ERROR_MESSAGE \
"తీవ్రత కోడ్లు RFC 5424 ప్రకారం: 0-7 విలువలు"

#  define L10N_INVALID_STATE_DURING_UTF8_PARSING \
"UTF-8 స్ట్రింగ్ పార్సింగ్ సమయంలో చెల్లని స్థితికి చేరుకుంది"

#  define L10N_INVALID_TARGET_TYPE_ERROR_MESSAGE \
"లక్ష్య రకం ఈ ఆపరేషన్కు అనుకూలంగా లేదు"

#  define L10N_JOURNALD_FAILURE_ERROR_CODE_TYPE \
"sd_journal_sendv రిటర్న్ కోడ్"

#  define L10N_JOURNALD_FAILURE_ERROR_MESSAGE \
"sd_journal_sendv విఫలమైంది"

#  define L10N_LOCAL_SOCKET_NAME_FILE_OPEN_ERROR_MESSAGE \
"mkstemp ఉపయోగించి ఎంచుకున్న స్థానిక సాకెట్ పేరుతో ఫైల్ను సృష్టించలేకపోయింది"

#  define L10N_MAX_MESSAGE_SIZE_UDP_ONLY_ERROR_MESSAGE \
"గరిష్ట సందేశ పరిమాణం UDP నెట్వర్క్ లక్ష్యాలకు మాత్రమే చెల్లుతుంది"

#  define L10N_MB_TO_WIDE_CONVERSION_ERROR_CODE_TYPE \
"విఫలమైన కాల్ తర్వాత GetLastError ఫలితం"

#  define L10N_MB_TO_WIDE_CONVERSION_ERROR_MESSAGE \
"అందించిన మల్టీబైట్ స్ట్రింగ్ను వైడ్ చార్ స్ట్రింగ్గా మార్చలేకపోయింది"

#  define L10N_MEMORY_ALLOCATION_FAILURE_ERROR_MESSAGE \
"మెమొరీ కేటాయింపు కాల్ విఫలమైంది"

#  define L10N_MESSAGE_SIZE_ERROR_CODE_TYPE \
"పంపడానికి ప్రయత్నించిన సందేశం పరిమాణం"

#  define L10N_MESSAGE_TOO_BIG_FOR_DATAGRAM_ERROR_MESSAGE \
"ఒకే డేటాగ్రామ్లో పంపడానికి సందేశం చాలా పెద్దది"

#  define L10N_NAME_RESOLUTION_FAILED_ERROR_MESSAGE \
"gethostbyname[2] మరియు inet_pton పేరును పరిష్కరించడంలో విఫలమయ్యాయి"

#  define L10N_NETWORK_CLOSED_ERROR_MESSAGE \
"నెట్వర్క్ కనెక్షన్ మూసివేయబడింది"

#  define L10N_NETWORK_PROTOCOL_UNSUPPORTED_ERROR_MESSAGE \
"ఎంచుకున్న నెట్వర్క్ ప్రోటోకాల్కు మద్దతు లేదు"

#  define L10N_NETWORK_TARGETS_UNSUPPORTED \
"ఈ బిల్డ్ ద్వారా నెట్వర్క్ లక్ష్యాలకు మద్దతు లేదు"

#  define L10N_NULL_ARG_ERROR_MESSAGE( ARG_NAME ) \
ARG_NAME " శూన్యం"

#  define L10N_OPEN_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"మద్దతు లేని లక్ష్య రకాన్ని తెరవడానికి ప్రయత్నించారు"

#  define L10N_PARAM_NOT_FOUND_ERROR_MESSAGE \
"పేర్కొన్న లక్షణాలతో పారామ్ కనుగొనబడలేదు"

#  define L10N_REGISTRY_SUBKEY_CREATION_FAILED_ERROR_MESSAGE \
"రిజిస్ట్రీ సబ్కీని సృష్టించడం సాధ్యం కాలేదు"

#  define L10N_REGISTRY_SUBKEY_DELETION_FAILED_ERROR_MESSAGE \
"రిజిస్ట్రీ సబ్కీని తొలగించడం సాధ్యం కాలేదు"

#  define L10N_REGISTRY_SUBKEY_OPEN_FAILED_ERROR_MESSAGE \
"రిజిస్ట్రీ సబ్కీ తెరవబడలేదు"

#  define L10N_REGISTRY_VALUE_GET_FAILED_ERROR_MESSAGE \
"రిజిస్ట్రీ విలువ చదవబడలేదు"

#  define L10N_REGISTRY_VALUE_SET_FAILED_ERROR_MESSAGE \
"రిజిస్ట్రీ విలువ సెట్ చేయబడలేదు"

#  define L10N_SENDTO_UNIX_SOCKET_FAILED_ERROR_MESSAGE \
"యునిక్స్ సాకెట్తో పంపడం విఫలమైంది"

#  define L10N_SEND_ENTRY_TO_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"మద్దతు లేని లక్ష్య రకానికి ఎంట్రీని పంపడానికి ప్రయత్నించారు"

#  define L10N_SEND_MESSAGE_TO_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"మద్దతు లేని లక్ష్య రకానికి సందేశాన్ని పంపడానికి ప్రయత్నించారు"

#  define L10N_SEND_SYS_SOCKET_FAILED_ERROR_MESSAGE \
"sys/socket.h సాకెట్తో పంపడం విఫలమైంది"

#  define L10N_SEND_WIN_SOCKET_FAILED_ERROR_MESSAGE \
"విన్సాక్2 సాకెట్తో పంపడం విఫలమైంది"

// todo translate
#  define L10N_SEVERITY_COLORS_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"severity colors are only supported for stream targets"

#  define L10N_SOCKET_FAILED_ERROR_MESSAGE \
"సాకెట్ తెరవడంలో విఫలమైంది"

#  define L10N_SOURCE_REGISTRATION_TRANSACTION_DESCRIPTION_W \
"విండోస్ ఈవెంట్ లాగ్ సోర్స్ యొక్క స్టంప్లెస్ రిజిస్ట్రేషన్"

#  define L10N_SQLITE3_BIND_FAILED_ERROR_MESSAGE( PARAM )  \
"PARAM ని స్టేట్మెంట్కి బంధించలేకపోయింది"

#  define L10N_SQLITE3_BUSY_ERROR_MESSAGE \
"డేటాబేస్ బిజీగా ఉంది మరియు లావాదేవీని పూర్తి చేయలేకపోయింది"

#  define L10N_SQLITE3_CLOSE_FAILED_ERROR_MESSAGE \
"sqlite3 డేటాబేస్ను మూసివేయడం సాధ్యం కాలేదు"

#  define L10N_SQLITE3_CUSTOM_PREPARE_FAILED_ERROR_MESSAGE \
"సిద్ధమైన స్టేట్మెంట్ల కోసం అనుకూల కాల్బ్యాక్ విఫలమైంది"

#  define L10N_SQLITE3_OPEN_FAILED_ERROR_MESSAGE \
"sqlite3 డేటాబేస్ తెరవలేకపోయింది"

#  define L10N_SQLITE3_PREPARE_FAILED_ERROR_MESSAGE \
"sqlite3_prepare_v2 విఫలమైంది"

#  define L10N_SQLITE3_RESULT_CODE_TYPE \
"విఫలమైన sqlite3 కాల్ రిటర్న్ కోడ్"

#  define L10N_SQLITE3_RETRY_COUNT_CODE_TYPE \
"ఆపరేషన్ ఎన్నిసార్లు తిరిగి ప్రయత్నించబడింది"

#  define L10N_SQLITE3_STEP_FAILED_ERROR_MESSAGE \
"sqlite3_step విఫలమైంది"

#  define L10N_SQLITE3_TARGETS_UNSUPPORTED \
"ఈ బిల్డ్ ద్వారా sqlite3 లక్ష్యాలకు మద్దతు లేదు"

#  define L10N_STREAM_WRITE_FAILURE_ERROR_MESSAGE \
"స్ట్రీమ్కు వ్రాయలేకపోయాను"

#  define L10N_STRING_LENGTH_ERROR_CODE_TYPE \
"ఆక్షేపణ స్ట్రింగ్ యొక్క పొడవు"

#  define L10N_STRING_TOO_LONG_ERROR_MESSAGE \
"స్ట్రింగ్ యొక్క పొడవు గరిష్ట పరిమితిని మించిపోయింది"

#  define L10N_TARGET_ALWAYS_OPEN_ERROR_MESSAGE \
"ఈ లక్ష్య రకం ఎల్లప్పుడూ తెరిచి ఉంటుంది"

#  define L10N_TRANSPORT_PORT_NETWORK_ONLY_ERROR_MESSAGE \
"రవాణా పోర్టులు నెట్వర్క్ లక్ష్యాలకు మాత్రమే చెల్లుతాయి"

#  define L10N_TRANSPORT_PROTOCOL_UNSUPPORTED_ERROR_MESSAGE \
"ఎంచుకున్న రవాణా ప్రోటోకాల్కు మద్దతు లేదు"

#  define L10N_UNIX_SOCKET_FAILED_ERROR_MESSAGE \
"సాకెట్ ఫంక్షన్తో యునిక్స్ సాకెట్ను తెరవడంలో విఫలమైంది"

#  define L10N_UNSUPPORTED_TARGET_IS_OPEN_ERROR_MESSAGE \
"మద్దతు లేని లక్ష్యం రకం తెరవబడిందో లేదో తనిఖీ చేయబడింది"

#  define L10N_WEL_CLOSE_FAILURE_ERROR_MESSAGE \
"Windows ఈవెంట్ లాగ్ను మూసివేయడం సాధ్యం కాలేదు"

#  define L10N_WEL_OPEN_FAILURE_ERROR_MESSAGE \
"Windows ఈవెంట్ లాగ్ను తెరవలేకపోయింది"

#  define L10N_WIDE_TO_MB_CONVERSION_ERROR_MESSAGE \
"అందించిన వైడ్ చార్ స్ట్రింగ్ను మల్టీబైట్ స్ట్రింగ్గా మార్చలేకపోయింది"

#  define L10N_WINDOWS_RETURN_ERROR_CODE_TYPE \
"విఫలమైన కాల్ ద్వారా విండోస్ లోపం కోడ్ తిరిగి వచ్చింది"

#  define L10N_WINDOWS_SOCKET_ERROR_CODE_TYPE \
"Windows సాకెట్ లోపం కోడ్"

#  define L10N_WINDOWS_WIDE_TO_MB_CONVERSION_ERROR_CODE_TYPE \
"విఫలమైన కాల్ తర్వాత GetLastError ఫలితం"

#  define L10N_WINSOCK2_SOCKET_FAILED_ERROR_MESSAGE \
"విన్సాక్2 సాకెట్ తెరవడంలో విఫలమైంది"

#  define L10N_WSAGETLASTERROR_ERROR_CODE_TYPE \
"విఫలమైన కాల్ తర్వాత WSAGetLastError ఫలితం"

#endif /* __STUMPLESS_PRIVATE_CONFIG_LOCALE_TE_IN_H */
