/* SPDX-License-Identifier: Apache-2.0 */

/*
 * Copyright 2020-2023 Joel E. Anderson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** @file
 * Sinhala localization strings.
 */

#ifndef __STUMPLESS_PRIVATE_CONFIG_LOCALE_SI_LK_H
#  define __STUMPLESS_PRIVATE_CONFIG_LOCALE_SI_LK_H

#  define L10N_BIND_UNIX_SOCKET_FAILED_ERROR_MESSAGE \
"දේශීය යුනික්ස් සොකට් එකට බැඳීමට නොහැකි විය"

#  define L10N_BUFFER_TOO_SMALL_ERROR_MESSAGE \
"දී ඇති පණිවිඩයට බෆරය කුඩා වැඩිය"

// todo translate
#  define L10N_CHAIN_TARGETS_UNSUPPORTED \
"chain targets are not supported by this build"

#  define L10N_CLOSE_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"සහාය නොදක්වන ඉලක්ක වර්ගයක් වැසීමට උත්සාහ කරන ලදී"

#  define L10N_COMMIT_TRANSACTION_FAILED_ERROR_MESSAGE \
"CommitTransaction අසාර්ථක විය"

#  define L10N_CONNECT_SYS_SOCKET_FAILED_ERROR_MESSAGE \
"sys/socket.h socket සමඟ සම්බන්ධ වීම අසාර්ථක විය"

#  define L10N_CONNECT_WIN_SOCKET_FAILED_ERROR_MESSAGE \
"winsock2 socket සමඟ සම්බන්ධ වීම අසාර්ථක විය"

#  define L10N_CREATE_TRANSACTION_FAILED_ERROR_MESSAGE \
"CreateTransaction අසාර්ථක විය"

#  define L10N_DESTINATION_NETWORK_ONLY_ERROR_MESSAGE \
"ගමනාන්තය වලංගු වන්නේ ජාල ඉලක්ක සඳහා පමණි"

#  define L10N_DUPLICATE_ELEMENT_ERROR_MESSAGE \
"සපයා ඇති නම සහිත මූලද්‍රව්‍යයක් දැනටමත් මෙම ප්‍රවේශයේ ඇත"

#  define L10N_ELEMENT_NOT_FOUND_ERROR_MESSAGE \
"නිශ්චිත ලක්ෂණ සහිත මූලද්රව්යයක් සොයාගත නොහැකි විය"

#  define L10N_ERRNO_ERROR_CODE_TYPE \
"අසාර්ථක වූ ඇමතුමෙන් පසු errno"

#  define L10N_FILE_OPEN_FAILURE_ERROR_MESSAGE \
"නිශ්චිත ගොනුව විවෘත කිරීමට නොහැකි විය"

#  define L10N_FILE_WRITE_FAILURE_ERROR_MESSAGE \
"ගොනුවට ලිවීමට නොහැකි විය"

#  define L10N_FORMAT_ERROR_MESSAGE(ARG) \
"වලංගු නොවන " ARG " ආකෘතිය"

#  define L10N_FUNCTION_TARGET_FAILURE_CODE_TYPE \
"ලොග් හසුරුවන්න කාර්යයේ ආපසු කේතය"

#  define L10N_FUNCTION_TARGET_FAILURE_ERROR_MESSAGE \
"කාර්යය ඉලක්කයක් සඳහා ලොග් හසුරුවන්නා අසාර්ථක විය"

#  define L10N_GETADDRINFO_FAILURE_ERROR_MESSAGE \
"getaddrinfo සපයා ඇති සත්කාරක නාමය මත අසාර්ථක විය"

#  define L10N_GETADDRINFO_RETURN_ERROR_CODE_TYPE \
"අසාර්ථක getaddrinfo ඇමතුමේ කේතය ආපසු දෙන්න"

#  define L10N_GETCOMPUTERNAME_FAILED_ERROR_MESSAGE \
"GetComputerName අසාර්ථක විය"

#  define L10N_GETHOSTNAME_FAILED_ERROR_MESSAGE \
"gethostname අසාර්ථක විය"

#  define L10N_GETLASTERROR_ERROR_CODE_TYPE \
"අසාර්ථක ඇමතුමෙන් පසු GetLastError හි ප්‍රතිඵලය"

#  define L10N_GETMODULEFILENAMEW_FAILED_ERROR_MESSAGE \
"GetModuleFileNameW අසාර්ථක විය"

#  define L10N_GETMODULEHANDLEXW_FAILED_ERROR_MESSAGE \
"GetModuleHandleExW අසාර්ථක විය"

#  define L10N_INDEX_OUT_OF_BOUNDS_ERROR_CODE_TYPE \
"වලංගු නොවන දර්ශකය, හෝ එහි -1 int ලෙස නිරූපණය කිරීමට විශාල වැඩිය"

#  define L10N_INVALID_FACILITY_ERROR_CODE_TYPE \
"වලංගු නොවන පහසුකම"

#  define L10N_INVALID_FACILITY_ERROR_MESSAGE \
"පහසුකම් කේත 8න් ගුණ කිරීමෙන් පසු RFC 5424 අනුව අර්ථ දැක්විය යුතුය."

#  define L10N_INVALID_ID_ERROR_MESSAGE \
"වලංගු නොවන ඉලක්ක id"

#  define L10N_INVALID_INDEX_ERROR_MESSAGE( INDEXED_THING ) \
"වලංගු නොවන " INDEXED_THING " දර්ශකය"

#  define L10N_INVALID_MULTI_SZ_ERROR_MESSAGE \
"MULTI_SZ රෙජිස්ට්‍රි අගයක් හිස් හෝ NULL අක්ෂර දෙකකින් අවසන් නොවීය"

#  define L10N_INVALID_PARAM_ERROR_MESSAGE \
"තන්තුව name=\"අගය\" ආකෘතියෙන් නොවේ"

#  define L10N_INVALID_SEVERITY_ERROR_CODE_TYPE \
"වලංගු නොවන බරපතලකම"

#  define L10N_INVALID_SEVERITY_ERROR_MESSAGE \
"බරපතලතා කේත RFC 5424 අනුව නිර්වචනය කළ යුතුය: 0 සහ 7 ඇතුළත් අගයන්"

#  define L10N_INVALID_STATE_DURING_UTF8_PARSING \
"UTF-8 තන්තු විග්‍රහ කිරීමේදී වලංගු නොවන තත්ත්වයට ළඟා විය"

#  define L10N_INVALID_TARGET_TYPE_ERROR_MESSAGE \
"ඉලක්ක වර්ගය මෙම මෙහෙයුම සමඟ නොගැලපේ"

#  define L10N_JOURNALD_FAILURE_ERROR_CODE_TYPE \
"sd_journal_sendv හි ආපසු කේතය"

#  define L10N_JOURNALD_FAILURE_ERROR_MESSAGE \
"sd_journal_sendv අසාර්ථක විය"

#  define L10N_LOCAL_SOCKET_NAME_FILE_OPEN_ERROR_MESSAGE \
"mkstemp භාවිතයෙන් තෝරාගත් දේශීය සොකට් නාමය සහිත ගොනුවක් නිර්මාණය" \
" කිරීමට නොහැකි විය"

#  define L10N_MAX_MESSAGE_SIZE_UDP_ONLY_ERROR_MESSAGE \
"උපරිම පණිවිඩ ප්‍රමාණය වලංගු වන්නේ UDP ජාල ඉලක්ක සඳහා පමණි"

#  define L10N_MB_TO_WIDE_CONVERSION_ERROR_CODE_TYPE \
"අසාර්ථක ඇමතුමෙන් පසු GetLastError හි ප්‍රතිඵලය"

#  define L10N_MB_TO_WIDE_CONVERSION_ERROR_MESSAGE \
"සපයා ඇති බහුබයිට් තන්තුව පුළුල් අක්ෂර තන්තුවකට පරිවර්තනය කළ නොහැක"

#  define L10N_MEMORY_ALLOCATION_FAILURE_ERROR_MESSAGE \
"මතක වෙන් කිරීමේ ඇමතුමක් අසාර්ථක විය"

#  define L10N_MESSAGE_SIZE_ERROR_CODE_TYPE \
"යැවීමට උත්සාහ කළ පණිවිඩයේ විශාලත්වය"

#  define L10N_MESSAGE_TOO_BIG_FOR_DATAGRAM_ERROR_MESSAGE \
"පණිවිඩය තනි දත්ත ග්‍රෑම් එකකින් යැවීමට නොහැකි තරම් විශාලය"

#  define L10N_NAME_RESOLUTION_FAILED_ERROR_MESSAGE \
"gethostbyname[2] සහ inet_pton නම විසඳීමට අසමත් විය"

#  define L10N_NETWORK_CLOSED_ERROR_MESSAGE \
"ජාල සම්බන්ධතාවය වසා ඇත"

#  define L10N_NETWORK_PROTOCOL_UNSUPPORTED_ERROR_MESSAGE \
"තෝරාගත් ජාල ප්‍රොටෝකෝලය සහාය නොදක්වයි"

#  define L10N_NETWORK_TARGETS_UNSUPPORTED \
"ජාල ඉලක්ක මෙම ගොඩනැගීමට සහාය නොදක්වයි"

#  define L10N_NULL_ARG_ERROR_MESSAGE( ARG_NAME ) \
ARG_NAME " NULL විය"

#  define L10N_OPEN_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"සහාය නොදක්වන ඉලක්ක වර්ගයක් විවෘත කිරීමට උත්සාහ කළා"

#  define L10N_PARAM_NOT_FOUND_ERROR_MESSAGE \
"නිශ්චිත ලක්ෂණ සහිත පරාමිතියක් සොයාගත නොහැකි විය"

#  define L10N_REGISTRY_SUBKEY_CREATION_FAILED_ERROR_MESSAGE \
"රෙජිස්ට්‍රි උප යතුරක් සෑදිය නොහැක"

#  define L10N_REGISTRY_SUBKEY_DELETION_FAILED_ERROR_MESSAGE \
"රෙජිස්ට්‍රි උප යතුරක් මකා දැමිය නොහැක"

#  define L10N_REGISTRY_SUBKEY_OPEN_FAILED_ERROR_MESSAGE \
"රෙජිස්ට්‍රි උප යතුරක් විවෘත කළ නොහැක"

#  define L10N_REGISTRY_VALUE_GET_FAILED_ERROR_MESSAGE \
"රෙජිස්ට්රි අගයක් කියවිය නොහැක"

#  define L10N_REGISTRY_VALUE_SET_FAILED_ERROR_MESSAGE \
"රෙජිස්ට්රි අගයක් සැකසිය නොහැක"

#  define L10N_SENDTO_UNIX_SOCKET_FAILED_ERROR_MESSAGE \
"යුනික්ස් සොකට් එකකින් sendto අසාර්ථක විය"

#  define L10N_SEND_ENTRY_TO_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"සහාය නොදක්වන ඉලක්ක වර්ගයකට ප්‍රවේශයක් යැවීමට උත්සාහ කරන ලදී"

#  define L10N_SEND_MESSAGE_TO_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"සහාය නොදක්වන ඉලක්ක වර්ගයකට පණිවිඩයක් යැවීමට උත්සාහ කරන ලදී"

#  define L10N_SEND_SYS_SOCKET_FAILED_ERROR_MESSAGE \
"sys/socket.h සොකට් එකක් සමඟ යැවීම අසාර්ථක විය"

#  define L10N_SEND_WIN_SOCKET_FAILED_ERROR_MESSAGE \
"winsock2 socket සමඟ යැවීම අසාර්ථක විය"

// todo translate
#  define L10N_SEVERITY_COLORS_UNSUPPORTED_TARGET_ERROR_MESSAGE \
"severity colors are only supported for stream targets"

#  define L10N_SOCKET_FAILED_ERROR_MESSAGE \
"සොකට් එකක් විවෘත කිරීමට අසමත් විය"

#  define L10N_SOURCE_REGISTRATION_TRANSACTION_DESCRIPTION_W \
L"Windows Event Log Source හි Stumpless ලියාපදිංචිය"

#  define L10N_SQLITE3_BIND_FAILED_ERROR_MESSAGE( PARAM )  \
PARAM " ප්‍රකාශයට බැඳීමට නොහැකි විය"

#  define L10N_SQLITE3_BUSY_ERROR_MESSAGE \
"දත්ත සමුදාය කාර්යබහුල වූ අතර ගනුදෙනුව සම්පූර්ණ කිරීමට නොහැකි විය"

#  define L10N_SQLITE3_CLOSE_FAILED_ERROR_MESSAGE \
"sqlite3 දත්ත සමුදාය වසා දැමීමට නොහැකි විය"

#  define L10N_SQLITE3_CUSTOM_PREPARE_FAILED_ERROR_MESSAGE \
"සකස් කළ ප්‍රකාශ සඳහා අභිරුචි ආපසු කැඳවීමක් අසාර්ථක විය"

#  define L10N_SQLITE3_OPEN_FAILED_ERROR_MESSAGE \
"sqlite3 දත්ත සමුදාය විවෘත කිරීමට නොහැකි විය"

#  define L10N_SQLITE3_PREPARE_FAILED_ERROR_MESSAGE \
"sqlite3_prepare_v2 අසාර්ථක විය"

#  define L10N_SQLITE3_RESULT_CODE_TYPE \
"අසාර්ථක වූ sqlite3 ඇමතුමේ ආපසු කේතය"

#  define L10N_SQLITE3_RETRY_COUNT_CODE_TYPE \
"මෙහෙයුම නැවත උත්සාහ කළ වාර ගණන"

#  define L10N_SQLITE3_STEP_FAILED_ERROR_MESSAGE \
"sqlite3_step අසාර්ථක විය"

#  define L10N_SQLITE3_TARGETS_UNSUPPORTED \
"sqlite3 ඉලක්ක මෙම ගොඩනැගීමෙන් සහාය නොදක්වයි"

#  define L10N_STREAM_WRITE_FAILURE_ERROR_MESSAGE \
"ධාරාවට ලිවීමට නොහැකි විය"

#  define L10N_STRING_LENGTH_ERROR_CODE_TYPE \
"වැරදි නූලෙහි දිග"

#  define L10N_STRING_TOO_LONG_ERROR_MESSAGE \
"නූල් දිග උපරිම සීමාව ඉක්මවා ඇත"

#  define L10N_TARGET_ALWAYS_OPEN_ERROR_MESSAGE \
"මෙම ඉලක්ක වර්ගය සැමවිටම විවෘත වේ"

#  define L10N_TRANSPORT_PORT_NETWORK_ONLY_ERROR_MESSAGE \
"ප්‍රවාහන වරායන් වලංගු වන්නේ ජාල ඉලක්ක සඳහා පමණි"

#  define L10N_TRANSPORT_PROTOCOL_UNSUPPORTED_ERROR_MESSAGE \
"තෝරාගත් ප්‍රවාහන ප්‍රොටෝකෝලය සහාය නොදක්වයි"

#  define L10N_UNIX_SOCKET_FAILED_ERROR_MESSAGE \
"සොකට් ක්‍රියාකාරිත්වය සහිත යුනික්ස් සොකට් එකක් විවෘත කිරීමට අපොහොසත් විය"

#  define L10N_UNSUPPORTED_TARGET_IS_OPEN_ERROR_MESSAGE \
"සහය නොදක්වන ඉලක්ක වර්ගයක් විවෘත දැයි බැලීමට පරීක්ෂා කරන ලදී"

#  define L10N_WEL_CLOSE_FAILURE_ERROR_MESSAGE \
"Windows Event Log එක වැසීමට නොහැකි විය"

#  define L10N_WEL_OPEN_FAILURE_ERROR_MESSAGE \
"Windows Event Log විවෘත කිරීමට නොහැකි විය"

#  define L10N_WIDE_TO_MB_CONVERSION_ERROR_MESSAGE \
"සපයා ඇති පුළුල් අක්ෂර තන්තුව බහුබයිට් තන්තුවකට පරිවර්තනය කළ නොහැක"

#  define L10N_WINDOWS_RETURN_ERROR_CODE_TYPE \
"අසාර්ථක ඇමතුම මඟින් වින්ඩෝස් දෝෂ කේතය ආපසු ලබා දුන්නේය"

#  define L10N_WINDOWS_SOCKET_ERROR_CODE_TYPE \
"වින්ඩෝස් සොකට් දෝෂ කේතය"

#  define L10N_WINDOWS_WIDE_TO_MB_CONVERSION_ERROR_CODE_TYPE \
"අසාර්ථක ඇමතුමෙන් පසු GetLastError හි ප්‍රතිඵලය"

#  define L10N_WINSOCK2_SOCKET_FAILED_ERROR_MESSAGE \
"winsock2 socket එකක් විවෘත කිරීමට අපොහොසත් විය"

#  define L10N_WSAGETLASTERROR_ERROR_CODE_TYPE \
"අසාර්ථක ඇමතුමෙන් පසු WSAGetLastError හි ප්‍රතිඵලය"

#endif //STUMPLESS_SI_LK_H