# Installing a Stumpless package
If you just want to use stumpless and aren't looking to modify or otherwise
develop it, the easiest path is to use one of the release packages. These are
available for a few common platforms, and are attached to each
[release](https://github.com/goatshriek/stumpless/releases) of stumpless. If you
need a package format that is not available here, please submit an issue with a
request for the format and the project team will see if this can be added.

Stumpless is not currently registered in any online package repositories such
as Chocolatey or Debian. If you need the library in a location like this, please
open an issue and the project team will see what we can do.

The provided release packages contain all of the items in the following list.
If you want a package with only a selection of these items, you'll need to build
it yourself using `cpack` and the appropriate configuration.

 * shared library
 * header files
 * `.pc` file for `pkg-config` implementations
 * examples
 * HTML documentation
 * man pages


## Debian Package
A `.deb` package is provided for use in environments that support them, like
Debian and Ubuntu. The package can be installed with the usual command:

```sh
# you might need sudo (or root privileges) to install
dpkg -i libstumpless-2.2.0-amd64.deb
```


## RPM Package
A `.rpm` package is provided for use in Red Hat Linux environments. It can be
installed in the traditional way as well:

```sh
# again, make sure you have the correct permissions
rpm -i libstumpless-2.2.0-x86_64.rpm
```


## FreeBSD Package
A `.pkg` package is provided for use in FreeBSD environments. Of course, it is
installed just as any other pkg would be:

```sh
# permissions need to be correct, of course
pkg add libstumpless-2.2.0-amd64.pkg
```


## Gentoo ebuild
A `.ebuild` package is provided with each release version of the library, and
is also generated during the configuration stage of the build by cmake. The
generated ebuild is in the `tools/portage` folder of the build directory.

The generated ebuild will be named after the version of stumpless you have.
If you want the latest commit instead of a release, you'll need to rename this
to version `libstumpless-9999.ebuild` to perform what Gentoo refers to as a
[live ebuild](https://wiki.gentoo.org/wiki/Ebuild#Live_ebuilds). If you have a
commit in a release that hasn't been published yet and do not rename the ebuild,
then the download of the source will fail.

In either case, you could install the ebuild by putting it into a repository and
running ebuild ultimately as something like:

```sh
ebuild libstumpless-2.2.0.ebuild clean manifest install merge
```

USE flags and other customizations can be done here as well. Gentoo installs are
more nuanced than can be discussed here; start with the relevant
[handbook page](https://wiki.gentoo.org/wiki/Ebuild) if you want to learn more.


## Generic Shell Installer
CMake generates a shell script that can be used to install the library on
systems lacking a more traditional package manager, for example Cygwin. Simply
execute the script from the prefix where you want to install the library. The
script is a self-extracting TGZ archive that provides the headers and library
files.

```sh
# you might need to do this with sudo!
# make sure your permissions allow you to write to the install locations
cd /usr
./libstumpless-2.2.0.sh
```


## Windows Installer
A simple `.msi` installer is provided that puts the DLL, `.lib`, and include
headers into a Program Files folder. Note that you may need to update search
paths to locate these resources after installation, as the installer does not
currently handle this.


## C++ Installers
For each provided package, there is also a C++ package (`stumpless-cpp`)
that includes the C++ library. These packages also include the C library, so
if you think you might need the C++ library at some point down the road you
can use this one to install it at the same time as the base library.


## Single File Builds
The `single-file` build target will generate the `stumpless.c` and
`include/single_file/stumpless.h` files in the build directory, which can be
used as single-file dropins. These can be compiled into other programs to
provide stumpless functionality without needing static linking or dynamic
loading of the library. The single header can be used as a replacement for
installing the complete header hierarchy that the typical install depends on.

Note that these rollup files will only contain functionality enabled by the
configuration it was generated by. Furthermore, the time needed to generate
these files is not insignificant, and the files are relatively large and
contain significant duplicate code. This option is included to provide a fast
and easy way to use the library by giving up some efficiency.


# Building Stumpless from the source
In order to compile Stumpless you will at a bare minimum cmake and a compatible
build system such as the GNU toolchain or Microsoft Visual Studio. While the
source itself can be downloaded using a number of tools (wget, a browser, etc.)
git is the recommended way to do this if you need to get specific release tags,
branches, or make any changes yourself.


## Prepping your System
Since there are so many possible ways to set up an environment, stumpless does
not provide any single way to do this. However, here are some snippets that
can get everything installed for you in some common environments.

Note that some depenencies for developing Stumpless are left out of these
snippets, most notably Git, Ruby, and Valgrind. For a full list of dependencies
check the [dependency documentation](./docs/dependencies.md), which lists all of
the tools you might need. The snippets below allow you to build and test the
library, as well as build the documentation for it.

Similarly, if you only want to build the library, you may not need all of these.
A C++ compiler is only needed to build the test suites, and doxygen is only
needed if you build the documentation. If you only want to build the library and
immediately install/use it, you will only need cmake and a C toolchain.

For Linux systems with a package manager like `apt`, you can install the needed
tools (for a GNU toolchain) with something like the following:

```sh
# for distributions using apt, such as Ubuntu or Debian:
sudo apt-get install cmake make gcc g++ doxygen

# for distributions that use pacman such as Arch Linux or MSYS2:
pacman -S cmake make gcc doxygen

# For MinGW be sure that you use the MinGW packages, such as in the following
# pacman invocation. Be sure that you are in a MinGW shell when building this
# way. For example, MSYS2 provides some MinGW terminals.
pacman -S $MINGW_PACKAGE_PREFIX-cmake \
          $MINGW_PACKAGE_PREFIX-make \
          $MINGW_PACKAGE_PREFIX-gcc \
          $MINGW_PACKAGE_PREFIX-doxygen
```

Cygwin lacks a package manager in the environment itself, requiring packages to
be installed using the setup script. You can install the needed packages in the
GUI, or if you want to just do it via command line, you can do something like
this:

```sh
setup-x86_64.exe -q -P cmake,make,gcc-core,gcc-g++,doxygen
```


## Building
Once all of the build dependencies are available, actually building the library
is straightforward. The examples below show how to do this in an environment
using `make` from a fresh clone.

```sh
# cloning the latest version of the source tree
# if you don't want to use git, you can download a zip of the sources from
# github
git clone git@github.com:goatshriek/stumpless.git

# creating a new build directory
mkdir build
cd build

# configuring the new build
cmake ../stumpless

# building the library itself
cmake --build .
```

Other environments should be built according to their normal style. For example
Visual Studio provides a CMake menu in the IDE that will display all available
targets.

CMake will use the build toolchain it feels is best, but on systems with
multiple available toolchains you may want to override this. For example, MinGW
systems may default to using Ninja, instead of the MinGW toolchain. In these
situations, you'll likely want to specify a
[generator](https://cmake.org/cmake/help/latest/manual/cmake-generators.7.html)
during the configuration stage. Sticking with the MinGW case, this might look
like this:

```sh
# run within the MinGW shell, in our fresh build directory
cmake -G "MinGW Makefiles" ../stumpless
```

If you're unsure of the build commands for the toolchain on your system, then
cmake can run these commands for you if you invoke it in
[build mode](https://cmake.org/cmake/help/latest/manual/cmake.1.html#build-a-project).
This is especially handy in environments like Visual Studio or MinGW, where the
build toolchain might require prefixes and/or options to work properly.

```sh
# build the default target ("all") using whatever toolchain cmake detected
# during the configuration stage
# the argument to the `--build` parameter is the root of the folder where we
# ran the original cmake configuration command
cmake --build .

# we can build and run any other target with the `--target` option
# for example, this invocation builds and runs the test suite
cmake --build . --target check
```

The type of build can be changed at configuration time by defining the
`CMAKE_BUILD_TYPE` symbol during configuration.

```sh
# benchmark testing should always be done using Release builds
cmake -DCMAKE_BUILD_TYPE=Release ../stumpless
```

However, some environments (Visual Studio being one) require the configuration
to be passed in during build steps. In the above example, builds would still use
the default build type, effectively ignoring the configuration step. To specify
the build type you will need to provide a config to use during build:

```sh
# explicitly use the Release configuration we have in our toolchain
cmake --build . --config x64-Release --target bench
```

In systems like this, it is easiest to use an IDE that does this work for you,
for example Visual Studio. For more information on these build topics, refer to
the CMake documentation on
[build mode](https://cmake.org/cmake/help/latest/manual/cmake.1.html#build-a-project)
and
[multi-config generators](https://cmake.org/cmake/help/latest/prop_gbl/GENERATOR_IS_MULTI_CONFIG.html).

The rest of this documentation uses make commands for simplicity, but for any
target you can build it using cmake build mode if you need truly portable
command line invocation.


## Building Documentation
The documentation for the library can be built using the `docs` target. Note
that this target will only be available if doxygen was detected during the
configuration of the system.

```sh
# the resulting documentation will appear in a folder named docs in the build
# directory
cmake --build . --target docs
```


## Verifying your Build
If you want to run the test suite on the library during development or as a
sanity check before installation, you can use the `check` target to run all
tests and display the results. If you're concerned that the build may not work
on your architecture, then this is the best way to verify.

```sh
cmake --build . --target check
```

The `check` target will download and build the Google Test library in the build
folder to run the tests when it is invoked for the first time.

If you're curious about how the library will perform on your system, use the
`bench` target to run the performance benchmarks. Like the `check` target, this
will download and build the Google Benchmark library in order to run.

```sh
cmake --build . --target bench
```


## Installing your Build
You can use the install target to install the library on your machine after the
build. This example uses the cmake `--install` command, but you could also use
the `install` build target for your specific build system, for example
`make install` in a GNU make build.

```sh
cmake --install .

# if the above doesn't work, you might need sudo to install files into the
# correct system folders
sudo cmake --install .
```

A simple way to make sure that your install is working as you expected is to
compile one of the examples without using the built-in targets. If the target
builds but your own compilation doesn't, then there is something wrong with
your install.

```sh
# first we use the build target to make sure it works
cmake --build . --target run-example-entry

# next, we compile the same example manually
gcc docs/examples/entry/entry_example.c -lstumpless -omanual_entry_example
# this should work if everything was correct
./manual_entry_example
```

If you do have issues, there are a few simple things for you to check. An easy
issue is if the installed library is not in the system's library search path,
which will usually lead to an error message of `cannot find -lstumpless` or
similar. If you see this, check the current search path and if needed set
appropriate environment variables or add compilation flags to add the location
that stumpless was installed to the search path. Some examples are gcc's `-L`
option, the `LD_LIBRARY_PATH` environment variable on many Linux systems, and
the environment variable `LIBRARY_PATH` in Cygwin.

If you find that stumpless has installed to unexpected locations and you want
to modify this, use the `CMAKE_INSTALL_PREFIX` definition during the
configuration step of the build. You can always re-run cmake to update this in
an existing build tree if you need to change it, or supply the `--prefix` option
to `cmake --install` to change it at install time.

```sh
# our initial build installed to /usr/local locations, which we didn't want
cat install_manifest.txt
# /usr/local/include/stumpless/target/network.h
# /usr/local/include/stumpless/target/socket.h
# /usr/local/lib/libstumpless.so.2.0.0
# /usr/local/lib/libstumpless.so
# /usr/local/include/stumpless.h
# <output truncated>

# re-do the install with a different prefix
sudo cmake --install . --prefix /usr

# now we see things in the right place!
cat install_manifest.txt
# /usr/include/stumpless/target/network.h
# /usr/include/stumpless/target/socket.h
# /usr/lib/libstumpless.so.2.0.0
# /usr/lib/libstumpless.so
# /usr/include/stumpless.h
# /usr/include/stumpless/config.h
# <output truncated>
```

Some tools, such as Visual Studio, will run the installation step for you. In
Visual Studio 2022 for example, this is in the `Build->Install stumpless` menu.


### Uninstalling
There is currently no uninstall target supported, so removal of the library
and its include files must be done manually if it is no longer needed. Please
submit an issue on the project's Github site if you feel that you need a build
target providing this feature. If you are on a Linux system, you can run the
contents of the `install_manifest.txt` file (generated during the install)
through `rm` like this:

```sh
xargs rm < install_manifest.txt
```


## C++ Library
If you want to build, test, and install the C++ bindings for stumpless as well,
you will need to modify the above steps slightly.

As a prerequisite, you will also need to make sure that you have the Wrapture
gem installed for this to work. This can be done with a simple
`gem install wrapture`, or you can use the `Gemfile` included in stumpless and
simply do a `bundle install` to pull it in.

If you need a ruby environment, we recommend using `rvm` to manage versions and
gemsets. You can find more information on rvm on the
[project website](https://rvm.io/). Other options are `rbenv`, your package
manager's distribution of ruby, or RubyInstaller (for Windows).

After you have a ruby environment and wrapture is available, building and
testing the C++ library can be done like this:

```sh
# in the build directory, modify the cmake to enable c++
# this will emit a warning and leave c++ disabled if wrapture cannot be found
cmake -DENABLE_CPP=ON ../stumpless

# the default target will now include the stumpless c++ library
cmake --build .

# to test the library, use the `check-cpp` target
cmake --build . --target check-cpp

# when enabled, the C++ bindings are installed along with the library itself
# so the following command will install the c++ headers and library in addition
# to the c headers and library
cmake --install .
```
