export default {
  visibility: {
    internal: 'Internal',
    private: 'Private',
    public: 'Public'
  },
  common: {
    success: 'Successful',
    failed: 'Failed',
    repo: 'Repo',
    viewDetail: 'View Detail',
    testing: 'Testing',
    organization: 'Organization',
    inputText: 'Please input',
    jump_to: 'Jump To ',
    add: 'Add',
    save: 'Save',
    update: 'Update',
    remark: 'Remark',
    selectText: 'Please select',
    action: 'Action',
    edit: 'Edit',
    startTimeText: 'Start time',
    endTimeText: 'End time',
    login: 'Login',
    required: 'This is required',
    loginOut: 'Login out',
    document: 'Document',
    reminder: 'Reminder',
    loginOutMessage: 'Exit the system?',
    back: 'Back',
    ok: 'OK',
    cancel: 'Cancel',
    reload: 'Reload current',
    closeTab: 'Close current',
    closeTheLeftTab: 'Close left',
    closeTheRightTab: 'Close right',
    closeOther: 'Close other',
    closeAll: 'Close all',
    prevLabel: 'Prev',
    nextLabel: 'Next',
    skipLabel: 'Jump',
    doneLabel: 'End',
    menu: 'Menu',
    menuDes: 'Menu bar rendered in routed structure',
    collapse: 'Collapse',
    collapseDes: 'Expand and zoom the menu bar',
    tagsView: 'Tags view',
    tagsViewDes: 'Used to record routing history',
    tool: 'Tool',
    toolDes: 'Used to set up custom systems',
    query: 'Query',
    reset: 'Reset',
    shrink: 'Put away',
    expand: 'Expand',
    delMessage: 'Delete the selected data?',
    delWarning: 'Warning',
    delOk: 'OK',
    delCancel: 'Cancel',
    delNoData: 'Please select the data to delete',
    delSuccess: 'Deleted successfully',
    confirmMsgTitle: 'Confirming',
    close: 'Close',
    submit: 'Submit',
    install: 'Install',
    copied: 'Copied'
  },
  error: {
    noPermission: `Sorry, you don't have permission to access this page.`,
    pageError: 'Sorry, the page you visited does not exist.',
    networkError: 'Sorry, the server reported an error.',
    returnToHome: 'Return to home',
    repoEmpty: 'repository is empty, click button to bind one',
    builderEmpty: 'building node is empty, click button to create one'
  },
  setting: {
    projectSetting: 'Project setting',
    theme: 'Theme',
    layout: 'Layout',
    systemTheme: 'System theme',
    menuTheme: 'Menu theme',
    interfaceDisplay: 'Interface display',
    breadcrumb: 'Breadcrumb',
    breadcrumbIcon: 'Breadcrumb icon',
    collapseMenu: 'Collapse menu',
    hamburgerIcon: 'Hamburger icon',
    screenfullIcon: 'Screenfull icon',
    sizeIcon: 'Size icon',
    localeIcon: 'Locale icon',
    tagsView: 'Tags view',
    logo: 'Logo',
    greyMode: 'Grey mode',
    fixedHeader: 'Fixed header',
    headerTheme: 'Header theme',
    cutMenu: 'Cut Menu',
    copy: 'Copy',
    clearAndReset: 'Clear cache and reset',
    copySuccess: 'Copy success',
    copyFailed: 'Copy failed',
    footer: 'Footer',
    uniqueOpened: 'Unique opened',
    tagsViewIcon: 'Tags view icon',
    dynamicRouter: 'Dynamic router',
    reExperienced: 'Please exit the login experience again'
  },
  size: {
    default: 'Default',
    large: 'Large',
    small: 'Small'
  },
  login: {
    welcome: 'Welcome to GoToCloud',
    message: 'Simple and easy-to-use CI/CD tool',
    username: 'Username',
    password: 'Password',
    register: 'Register',
    checkPassword: 'Confirm password',
    login: 'Sign in',
    otherLogin: 'Sign in with',
    remember: 'Remember me',
    hasUser: 'Existing account? Go to login',
    forgetPassword: 'Forget password',
    usernamePlaceholder: 'Please input username',
    passwordPlaceholder: 'Please input password',
    code: 'Verification code',
    codePlaceholder: 'Please input verification code'
  },
  router: {
    login: 'Login',
    analysis: 'Analysis',
    workplace: 'Workplace',
    projects: 'Projects',
    configure: 'Configure',
    builders: 'Build Nodes',
    pipelines: 'Pipelines',
    approach: 'Approach',
    coderepo: 'Code Repository',
    artifacts: 'Artifact Repository',
    k8s: 'Deploy Environment',
    monitor: 'Apps Monitor',
    authorization: 'Authorization',
    user: 'User management',
    role: 'Role management',
    org: 'Organization management'
  },
  permission: {
    hasPermission: 'Please set the operation permission value'
  },
  analysis: {
    newUser: 'New user',
    unreadInformation: 'Unread information',
    transactionAmount: 'Transaction amount',
    totalShopping: 'Total Shopping',
    monthlySales: 'Monthly sales',
    userAccessSource: 'User access source',
    january: 'January',
    february: 'February',
    march: 'March',
    april: 'April',
    may: 'May',
    june: 'June',
    july: 'July',
    august: 'August',
    september: 'September',
    october: 'October',
    november: 'November',
    december: 'December',
    estimate: 'Estimate',
    actual: 'Actual',
    directAccess: 'Airect access',
    mailMarketing: 'Mail marketing',
    allianceAdvertising: 'Alliance advertising',
    videoAdvertising: 'Video advertising',
    searchEngines: 'Search engines',
    weeklyUserActivity: 'Weekly user activity',
    activeQuantity: 'Active quantity',
    monday: 'Monday',
    tuesday: 'Tuesday',
    wednesday: 'Wednesday',
    thursday: 'Thursday',
    friday: 'Friday',
    saturday: 'Saturday',
    sunday: 'Sunday'
  },
  workplace: {
    goodMorning: 'Good morning',
    happyDay: 'Wish you happy every day!',
    toady: `It's sunny today`,
    projects: 'Project',
    access: 'Project access',
    toDo: 'To do',
    introduction: 'A serious introduction',
    more: 'More',
    shortcutOperation: 'Shortcut operation',
    operation: 'Operation',
    index: 'Index',
    personal: 'Personal',
    team: 'Team',
    quote: 'Quote',
    contribution: 'Contribution',
    hot: 'Hot',
    yield: 'Yield',
    dynamic: 'Dynamic',
    push: 'push',
    pushCode: 'Archer push code to Github',
    follow: 'Follow'
  },
  project: {
    name: 'Project Name',
    modules: 'Module Manage',
    action: 'Actions',
    title: 'Projects',
    desc: 'description',
    all: 'All Projects',
    archived: 'Archived Projects',
    create: 'New Project',
    update: 'Update Project',
    createSuccess: 'Project Create Success',
    createFailure: 'Project Create Failed',
    updateSuccess: 'Project Update Success',
    updateFailure: 'Project Update Failed',
    at_least_one_org: 'At least One Organization',
    latest_ci: 'Latest Build',
    updatedAt: 'Imported On',
    remove: 'Delete Project',
    removeConfirm: 'Project will be deleted. Continue？',
    sourceCode: {
      removeConfirm: 'Source Code will be remove from project. Continue?',
      importSuccess: 'Import Success'
    },
    ci: {
      build_env: 'Build Environment',
      plan: 'CI Plan',
      new_plan: 'New Plan',
      plan_name: 'Plan Name',
      code_repo_header: 'Code Repo',
      code_repo: 'Git Address',
      code_branch: 'Build Branch',
      qa_header: 'QA',
      unit_test: 'Unit Test',
      lint_check: 'Lint',
      artifact_header: 'Artifact',
      dockerfile: 'Dockerfile',
      build_workdir: 'Work Context',
      artifact_repo: 'Artifact Repo',
      artifact_name: 'Image Name',
      artifact_name_rule: 'Image name not match the rule, a-z, 0-9, . _ - only',
      stage_enable: 'Enable',
      last_build: 'Last Build',
      build_at: 'Build At',
      build_now: 'Build Now',
      cancel_building: 'Stop Building',
      build_history: 'Build History',
      delete_plan: 'Delete Plan',
      steps: 'Build Step',
      build_logs: 'Build Logs',
      result: {
        never: 'Never',
        success: 'Success',
        failed: 'Failure',
        building: 'Building',
        cancel: 'Cancelled'
      },
      removeConfirm: 'Build plan will be removed. Continue?'
    },
    cd: {
      plan: 'CD Plan',
      new_app: 'New Plan',
      target_env: 'Deployment Env',
      app_name: 'App Name',
      namespace: 'Namespace',
      artifact_name: 'Image Name',
      deploy_version: 'Deploy Version',
      deploy_version_fixed: 'Fixed Version',
      deploy_version_latest: 'Always Latest',
      replicate_num: 'Replicate Numbers',
      port_mapping: 'Port Mapping',
      service_port: 'Service Port',
      container_port: 'Container Port',
      node_port: 'Node Port',
      env_vars: 'Environment Variables',
      env_vars_key: 'Variable',
      env_vars_value: 'Value',
      resource_limit: {
        text: 'Resource Limit',
        cpu_request: 'CPU Request',
        cpu_limit: 'CPU Limit',
        mem_request: 'Memory Request',
        mem_limit: 'Memory Limit'
      },
      health_checker: 'Health Checker',
      health_checker_port: 'Health Checker Port',
      ops: 'Operation',
      action: 'Actions',
      first_deploy: 'Start Deploy',
      redeploy: 'Redeploy',
      rollback: 'Rollback...',
      rollback_to: 'Rollback Artifact To ',
      delete: 'Delete App',
      detail: 'Detail...',
      submitAndDeploy: 'Submit And Deploy',
      deployed_at: 'Deployed At',
      last_deploy_at: 'Last Deploy At',
      deploy_history: 'Deploy History',
      delete_deployment: 'Delete Deployment',
      result: {
        never: 'Never',
        success: 'Success',
        failed: 'Failure',
        building: 'Building'
      },
      deleteConfirm: 'Deployment will be deleted since App would NOT. Continue?',
      start_deploy: 'Start Deploy',
      deploy_failed: 'Deploy failed, Please Check and Retry.'
    },
    toolset: {
      code: 'Code Repository',
      ci: 'Continuous Integration',
      cd: 'Continuous Deployment',
      delivery: 'Continuous Delivery',
      artifact: 'Artifact Repository'
    }
  },
  coderepo: {
    name: 'Repo Name',
    bind: 'Bind Repo',
    all: 'All Git Repo',
    origin: 'Repo Origin',
    type: 'Repo Type',
    action: 'Actions',
    url: 'Git URL',
    user: 'User Name',
    token: 'Access Token',
    testingPassed: 'Code Repo Testing Passed',
    testingFailed: 'Code Repo Testing Failed',
    bindSuccess: 'Code Repo Bind Success',
    bindFailure: 'Code Repo Bind Failure',
    updateSuccess: 'Code Repo Update Success',
    updateFailure: 'Code Repo Update Failure',
    at_least_one_org: 'At least One Organization',
    updatedAt: 'Imported On',
    remove: 'Remove Code Repo',
    removeConfirm: 'Bind repo will be removed. Continue?',
    git: {
      name: 'Git Source',
      import: 'Import Code'
    }
  },
  builder: {
    name: 'Building Node',
    node_name: 'Node Name',
    max_worker: 'Max Workers Number',
    available_nodes_number: 'Idle Workers',
    workload: 'Work Load',
    node_status: 'Node Status',
    install: 'Install Build Node',
    install_success: 'Install success',
    install_failure: 'Install failure, please try later, or check your kubeconfig',
    uninstall: 'Uninstall Build Node',
    uninstall_confirm: 'Builder Node will be uninstalled，continue?',
    uninstall_success: 'Uninstall success',
    uninstall_failure: 'Uninstall failure, try it later.',
    update_success: 'Update success',
    update_failure: 'Update failure, try it later',
    all: 'All Nodes',
    node_type: {
      name: 'Node Type',
      k8s: {
        namespace: 'Namespace'
      }
    },
    introduce: {
      install_on_k8s: 'Install Builder Node on k8s as a Pod',
      install_on_Windows: 'Install Builder Node on Windows, coming soon!',
      install_on_Linux: 'Install Builder Node on Linux, coming soon!',
      where_is_kubeconfig:
        "try to find config in '$HOME/.kube', or '/etc/rancher/k3s' if it is k3s",
      what_is_namespace: 'namespace in k8s, for agent pod works'
    }
  },
  artifacts: {
    name: 'Artifacts Repo Name',
    bind: 'Bind Artifact Repo',
    security_type: 'Artifact Repo Security',
    security: {
      insecurity: 'HTTP',
      security: 'HTTPS'
    },
    origin: 'Artifact Type',
    url: 'Artifact Repo URL',
    user: 'User',
    password: 'Password',
    docker: {
      list: 'Image Name',
      latest_version: 'Latest Version',
      tag_version: 'Image Tag',
      latest_push_at: 'Latest Publish',
      push_at: 'Published At',
      publish_counter: 'Publish Times',
      title_artifact_history: 'Image History',
      view_artifact_history: 'View Image History',
      copy_latest_image: 'Copy Latest Image URL',
      copy_image: 'Copy Image URL',
      delete_image: 'Delete Image',
      delete_latest_image: 'Delete Latest Image',
      delete_image_confirm: 'Image will be deleted. Continue?',
      delete_all_images: 'Delete All Images',
      action: 'Operation',
      remove: 'Remove Artifact Repo'
    },
    testingPassed: 'Artifact Repo Testing Passed',
    testingFailed: 'Artifact Repo Testing Failed',
    bindSuccess: 'Artifact Repo Bind Success',
    bindFailure: 'Artifact Repo Bind Failure',
    updateSuccess: 'Artifact Repo Update Success',
    updateFailure: 'Artifact Repo Update Failure',
    removeConfirm: 'Bind repo will be removed. Continue?'
  },
  k8s: {
    bind: 'Bind K8S Cluster',
    name: 'Cluster Name',
    kubeconfig: 'KubeConfig',
    all: 'All K8s Cluster',
    action: 'Actions',
    serverVer: 'K8s Cluster Version',
    testingPassed: 'K8S Cluster Testing Passed',
    testingFailed: 'K8S Cluster Testing Failed',
    bindSuccess: 'K8S Cluster Bind Success',
    bindFailure: 'K8S Cluster Bind Failure',
    updateSuccess: 'K8S Cluster Update Success',
    updateFailure: 'K8S Cluster Update Failure',
    at_least_one_org: 'At least On Organization',
    updatedAt: 'Imported On',
    remove: 'Remove K8S Cluster',
    removeConfirm: 'Bind cluster will be removed. Continue?'
  },
  monitor: {
    appName: 'App Name',
    podName: 'Pod Name',
    refresh: 'Refresh Apps',
    refreshPod: 'Refresh Pods',
    namespace: 'Namespace',
    pod_number: 'Pods',
    replicas: 'Replicas',
    publish_time: 'Age',
    conditions: 'Conditions',
    action: 'Actions',
    scale: 'Scale',
    restart: 'Restart',
    delete_deployment: 'Delete App',
    start: 'Start',
    pods_detail: 'Pods Detail',
    container: 'Containers',
    restarts: 'Restarts',
    pod_age: 'Age',
    pod_status: 'Status',
    pod_logs: 'View Logs',
    container_shell: 'Shell',
    delete_pod: 'Delete Pod',
    deletePodConfirm: 'Pod will be deleted. Continue?',
    switch_container: 'Select Container',
    delete_deployment_confirm: 'Deployment will be deleted. Continue?',
    xterm: {
      connecting: 'Connecting to pod...',
      disconnected: 'Disconnected'
    }
  },
  authz: {
    user: {
      new: 'New User',
      title: 'Users',
      message: 'Users management, CRUD And reset password, set belongs Here',
      username: 'UserName',
      account: 'Account',
      password: 'Password',
      reset_password: 'Reset Password',
      belongs: 'Belongs',
      email: 'Email',
      mobile: 'Mobile',
      detail: 'Detail',
      delete: 'Delete',
      deleteConfirm: 'User will be deleted, Continue?',
      createSuccess: 'User Created!',
      updateSuccess: 'User Updated!',
      deleteSuccess: 'User Deleted!',
      createFailure: 'User Create Failed!',
      updateFailure: 'User Update Failed!',
      deleteFailure: 'User Delete Failed!',
      resetSuccess: 'Password Reset!',
      resetFailure: 'Password Reset Failed!',
      old_password: 'Old Password',
      new_password: 'New Password',
      copy_password: 'Copy Password',
      allOrg: 'All Organization',
      kind: 'Role',
      org_filter_placeholder: 'Organization Name'
    },
    org: {
      title: 'Organization',
      message:
        'A group of users is typically organized into an organization, such as including the development team members of a project. A user can belong to multiple organizations.',
      name: 'Name',
      member_count: 'Member Count',
      detail: 'Detail',
      new: 'New Organization',
      delete: 'Delete Organization',
      deleteConfirm: 'Organization will be deleted, Continue?',
      createSuccess: 'Organization Created!',
      updateSuccess: 'Organization Updated!',
      deleteSuccess: 'Organization Deleted!',
      createFailure: 'Organization Create Failed!',
      updateFailure: 'Organization Update Failed!',
      deleteFailure: 'Organization Delete Failed!',
      member: 'Member Management',
      member_filter_placeholder: 'User Name',
      allMember: 'All Members',
      joinedMember: 'Joined Members',
      joinFailed: 'Save Members Failed'
    },
    created_at: 'Created Time',
    index: 'Index',
    role: 'Role',
    remark: 'Remark',
    remarkMessage1: 'Back end control routing permission',
    remarkMessage2: 'Front end control routing permission'
  },
  formDemo: {
    input: 'Input',
    inputNumber: 'InputNumber',
    default: 'Default',
    icon: 'Icon',
    mixed: 'Mixed',
    textarea: 'Textarea',
    slot: 'Slot',
    position: 'Position',
    autocomplete: 'Autocomplete',
    select: 'Select',
    selectGroup: 'Select Group',
    selectV2: 'SelectV2',
    cascader: 'Cascader',
    switch: 'Switch',
    rate: 'Rate',
    colorPicker: 'Color Picker',
    transfer: 'Transfer',
    render: 'Render',
    radio: 'Radio',
    button: 'Button',
    checkbox: 'Checkbox',
    slider: 'Slider',
    datePicker: 'Date Picker',
    shortcuts: 'Shortcuts',
    today: 'Today',
    yesterday: 'Yesterday',
    aWeekAgo: 'A week ago',
    week: 'Week',
    year: 'Year',
    month: 'Month',
    dates: 'Dates',
    daterange: 'Date Range',
    monthrange: 'Month Range',
    dateTimePicker: 'DateTimePicker',
    dateTimerange: 'Datetime Range',
    timePicker: 'Time Picker',
    timeSelect: 'Time Select',
    inputPassword: 'input Password',
    passwordStrength: 'Password Strength',
    defaultForm: 'All examples',
    formDes:
      'The secondary encapsulation of form components based on ElementPlus realizes data-driven and supports all Form parameters',
    example: 'example',
    operate: 'operate',
    change: 'Change',
    restore: 'Restore',
    disabled: 'Disabled',
    disablement: 'Disablement',
    delete: 'Delete',
    add: 'Add',
    setValue: 'Set value',
    resetValue: 'Reset value',
    set: 'Set',
    subitem: 'Subitem',
    formValidation: 'Form validation',
    verifyReset: 'Verify reset'
  },
  guideDemo: {
    guide: 'Guide',
    start: 'Start',
    message:
      'The guide page is very useful for some people who enter the project for the first time. You can briefly introduce the functions of the project. The boot page is based on intro js'
  },
  iconDemo: {
    icon: 'Icon',
    localIcon: 'Local Icon',
    iconify: 'Iconify component',
    recommendedUse: 'Recommended use',
    recommendeDes:
      'Iconify component basically contains all icons. You can query any icon you want. And packaging will only package the icons used.',
    accessAddress: 'Access address'
  },
  echartDemo: {
    echart: 'Echart',
    echartDes:
      'Based on the secondary packaging components of eckarts, the width is adaptive. The corresponding chart can be displayed by passing in the options and height attributes.'
  },
  countToDemo: {
    countTo: 'CountTo',
    countToDes:
      'The transformation is based on vue-count-to and supports all vue-count-to parameters.',
    suffix: 'Suffix',
    prefix: 'Prefix',
    separator: 'Separator',
    duration: 'Duration',
    endVal: 'End val',
    startVal: 'Start val',
    start: 'Start',
    pause: 'Pause',
    resume: 'Resume'
  },
  watermarkDemo: {
    watermark: 'Watermark',
    createdWatermark: 'Created watermark',
    clearWatermark: 'Clear watermark',
    resetWatermark: 'Reset watermark'
  },
  qrcodeDemo: {
    qrcode: 'Qrcode',
    qrcodeDes: 'Secondary packaging based on qrcode',
    basicUsage: 'Basic usage',
    imgTag: 'Img tag',
    style: 'Style config',
    click: 'Click event',
    asynchronousContent: 'Asynchronous content',
    invalid: 'Invalid',
    logoConfig: 'Logo config',
    logoStyle: 'Logo style',
    size: 'size config'
  },
  highlightDemo: {
    highlight: 'Highlight',
    message: 'The best time to plant a tree is ten years ago, followed by now.',
    keys1: 'ten years ago',
    keys2: 'now'
  },
  infotipDemo: {
    infotip: 'Infotip',
    infotipDes: 'Secondary packaging of components based on Highlight',
    title: 'matters needing attention'
  },
  levelDemo: {
    menu: 'Multi level menu cache'
  },
  searchDemo: {
    search: 'Search',
    searchDes:
      'Based on the secondary encapsulation of form components, the functions of query and reset are realized',
    operate: 'operate',
    change: 'Change',
    grid: 'grid',
    button: 'Button',
    restore: 'Restore',
    inline: 'inline',
    bottom: 'Bottom',
    position: 'position',
    left: 'left',
    center: 'center',
    right: 'right',
    dynamicOptions: 'Dynamic options'
  },
  stickyDemo: {
    sticky: 'Sticky'
  },
  tableDemo: {
    table: 'Table',
    tableDes: 'Secondary packaging of Table components based on ElementPlus',
    index: 'Index',
    title: 'Title',
    author: 'Author',
    displayTime: 'Display time',
    importance: 'Importance',
    pageviews: 'Pageviews',
    action: 'Action',
    important: 'Important',
    good: 'Good',
    commonly: 'Commonly',
    operate: 'operate',
    example: 'example',
    show: 'Show',
    hidden: 'Hidden',
    pagination: 'pagination',
    reserveIndex: 'Reserve index',
    restoreIndex: 'Restore index',
    showSelections: 'Show selections',
    hiddenSelections: 'Restore selections',
    showExpandedRows: 'Show expanded rows',
    hiddenExpandedRows: 'Hidden expanded rows',
    changeTitle: 'Change title',
    header: 'Header'
  },
  richText: {
    richText: 'Rich text',
    richTextDes: 'Secondary packaging based on wangeditor'
  },
  dialogDemo: {
    dialog: 'Dialog',
    dialogDes: 'Secondary packaging of Dialog components based on ElementPlus',
    open: 'Open',
    close: 'Close',
    combineWithForm: 'Combine with form',
    submit: 'Submit'
  },
  imageViewerDemo: {
    open: 'Open',
    imageViewer: 'Image viewer',
    imageViewerDes: 'Secondary packaging of ImageViewer components based on ElementPlus'
  },
  descriptionsDemo: {
    descriptions: 'Descriptions',
    descriptionsDes: 'Secondary packaging of Descriptions components based on ElementPlus',
    username: 'Username',
    nickName: 'NickName',
    phone: 'Phone',
    email: 'Email',
    addr: 'Address',
    form: 'Combined with Form component'
  },
  exampleDemo: {
    title: 'Title',
    add: 'Add',
    del: 'Delete',
    edit: 'Edit',
    author: 'Author',
    displayTime: 'Display time',
    importance: 'Importance',
    pageviews: 'Pageviews',
    important: 'Important',
    content: 'Content',
    save: 'Save',
    detail: 'Detail'
  },
  inputPasswordDemo: {
    title: 'InputPassword',
    inputPasswordDes: 'Secondary packaging of Input components based on ElementPlus'
  }
}
