// Copyright 2014 Manu Martinez-Almeida.  All rights reserved.
// Use of this source code is governed by a MIT style
// license that can be found in the LICENSE file.

package mid

import (
	"bytes"
	"testing"

	"github.com/go-ego/ego"
	"github.com/stretchr/testify/assert"
)

// TestPanicInHandler assert that panic has been recovered.
func TestPanicInHandler(t *testing.T) {
	buffer := new(bytes.Buffer)
	router := ego.New()
	router.Use(RecoveryWithWriter(buffer))
	router.GET("/recovery", func(_ *ego.Context) {
		panic("Oupps, Houston, we have a problem")
	})
	// RUN
	w := performRequest(router, "GET", "/recovery")
	// TEST
	assert.Equal(t, 500, w.Code)
	assert.Contains(t, buffer.String(), "GET /recovery")
	assert.Contains(t, buffer.String(), "Oupps, Houston, we have a problem")
	assert.Contains(t, buffer.String(), "TestPanicInHandler")
}

// TestPanicWithAbort assert that panic has been recovered even if context.Abort was used.
func TestPanicWithAbort(t *testing.T) {
	router := ego.New()
	router.Use(RecoveryWithWriter(nil))
	router.GET("/recovery", func(c *ego.Context) {
		c.AbortWithStatus(400)
		panic("Oupps, Houston, we have a problem")
	})
	// RUN
	w := performRequest(router, "GET", "/recovery")
	// TEST
	assert.Equal(t, 400, w.Code)
}
