export const CSSPropertiesMap = {
  alignContent: 'stretch',
  alignItems: 'stretch',
  alignSelf: 'auto',
  aspectRatio: 'auto',
  borderBottomWidth: '0',
  borderLeftWidth: '0',
  borderRightWidth: '0',
  borderTopWidth: '0',
  borderEndWidth: '0',
  borderStartWidth: '0',
  borderEndEndRadius: '0',
  borderStartStartRadius: '0',
  borderStartEndRadius: '0',
  borderEndStartRadius: '0',
  borderWidth: '0',
  bottom: 'auto',
  direction: 'ltr',
  display: 'flex',
  end: 'auto',
  start: 'auto',
  flex: 'none',
  flexDirection: 'column',
  flexBasis: 'auto',
  flexGrow: '0',
  flexShrink: '1',
  flexWrap: 'nowrap',
  gap: 'normal',
  rowGap: 'normal',
  columnGap: 'normal',
  height: 'auto',
  justifyContent: 'flex-start',
  left: 'auto',
  margin: '0',
  marginBottom: '0',
  marginHorizontal: '0',
  marginLeft: '0',
  marginRight: '0',
  marginTop: '0',
  marginVertical: '0',
  marginEnd: '0',
  marginStart: '0',
  maxHeight: 'none',
  maxWidth: 'none',
  minHeight: 'auto',
  minWidth: 'auto',
  padding: '0',
  paddingBottom: '0',
  paddingHorizontal: '0',
  paddingLeft: '0',
  paddingRight: '0',
  paddingTop: '0',
  paddingVertical: '0',
  paddingEnd: '0',
  paddingStart: '0',
  position: 'relative',
  right: 'auto',
  top: 'auto',
  width: 'auto',
  zIndex: 'auto',
  shadowColor: 'transparent',
  shadowOffset: '0px 0px',
  shadowOpacity: '0',
  shadowRadius: '0',
  transform: 'none',
  transformOrigin: 'initial',
  backfaceVisibility: 'visible',
  backgroundColor: 'transparent',
  borderBottomLeftRadius: '0',
  borderBottomRightRadius: '0',
  borderColor: 'initial',
  borderBlockColor: 'initial',
  borderBlockEndColor: 'initial',
  borderBlockStartColor: 'initial',
  borderRadius: '0',
  borderTopLeftRadius: '0',
  borderTopRightRadius: '0',
  opacity: '1',
  overflow: 'visible',
  overflowX: 'visible',
  overflowY: 'visible',
  borderBottomColor: 'initial',
  borderLeftColor: 'initial',
  borderRightColor: 'initial',
  borderStyle: 'none',
  borderTopColor: 'initial',
  elevation: '0',
  color: 'initial',
  fontFamily: 'system-ui',
  fontSize: 'initial',
  fontStyle: 'normal',
  fontVariant: 'normal',
  textTransform: 'none',
  fontWeight: 'normal',
  lineHeight: 'initial',
  textAlign: 'auto',
  textDecorationLine: 'none',
  textShadowColor: 'transparent',
  textShadowOffset: '0px 0px',
  textShadowRadius: '0',
  textAlignVertical: 'auto',
  verticalAlign: 'auto',
  letterSpacing: 'normal',
  textDecorationColor: 'initial',
  textDecorationStyle: 'solid',
  borderBottomEndRadius: '0',
  borderBottomStartRadius: '0',
  borderEndColor: 'initial',
  borderStartColor: 'initial',
  borderTopEndRadius: '0',
  borderTopStartRadius: '0',
  userSelect: 'auto',
};

type reservedKeyTypes =
  | 'isState'
  | 'isColorMode'
  | 'isPlatform'
  | 'isMediaQuery';

export type reservedKeyType = {
  key: string;
} & {
  [key in reservedKeyTypes]?: boolean;
};

export const reservedKeys: Record<string, reservedKeyType> = {
  indeterminate: { key: ':indeterminate', isState: true },
  checked: { key: ':checked', isState: true },
  readOnly: { key: ':readOnly', isState: true },

  required: { key: ':required', isState: true },
  invalid: { key: ':invalid', isState: true },

  focus: { key: ':focus', isState: true },
  focusVisible: { key: ':focusVisible', isState: true },
  hover: { key: ':hover', isState: true },
  pressed: { key: ':pressed', isState: true },
  active: { key: ':active', isState: true },
  loading: { key: ':loading', isState: true },

  disabled: { key: ':disabled', isState: true },
  light: { key: '_light', isColorMode: true },
  dark: { key: '_dark', isColorMode: true },
  web: { key: '_web', isPlatform: true },
  ios: { key: '_ios', isPlatform: true },
  android: { key: '_android', isPlatform: true },
};
