[![CI](https://github.com/gilesknap/mciwb/actions/workflows/ci.yml/badge.svg)](https://github.com/gilesknap/mciwb/actions/workflows/ci.yml)
[![Coverage](https://codecov.io/gh/gilesknap/mciwb/branch/main/graph/badge.svg)](https://codecov.io/gh/gilesknap/mciwb)
[![PyPI](https://img.shields.io/pypi/v/mciwb.svg)](https://pypi.org/project/mciwb)
[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

# mciwb

Minecraft Interactive World Builder
===================================

This project is intended as a fun way to learn the Python Programming Language.

Experienced Python programmers can also use this library to create
Minecraft worlds with interactive Python features.

Source          | <https://github.com/gilesknap/mciwb>
:---:           | :---:
PyPI            | pip install mciwb
Documentation   | <https://gilesknap.github.io/mciwb>
Releases        | <https://github.com/gilesknap/mciwb/releases>


Quick Start
-----------

To get started learning Python, see
[Introduction](https://gilesknap.github.io/mciwb/main/user/tutorials/00-prereq.html)

For existing Python developers, see
[API documentation](https://gilesknap.github.io/mciwb/main/user/reference/api.html)

Example Build
-------------

The pagoda and castle with working portcullis were all created programmatically
with Python and the current version of MCIWB.

https://github.com/gilesknap/mciwb/assets/964827/026b3551-f514-403a-bebe-8d168c7170b0


Goals
-----

Minecraft Interactive World Builder's goals are:

 - Use Python to create anything inside of Minecraft worlds.
 - Call Python code when events occur inside the world.
 - Use an iPython prompt to interact with the world by typing Python commands
 - Have your player inside the world execute Python code by placing command
   signs or activating switches/levers with Python actions.

All instructions on how to set up a Minecraft Server and the Python developer
environment are included. There are step by step tutorials to
introduce Python Programming and the features of Minecraft Interactive World
Builder.

.. note::

    This is a work in progress. There are now enough tutorials to learn the
    fundamentals of Python and enough functionality to have some fun
    interacting with Minecraft from Python code.

    I will continue to expand the tutorials and add more features to the
    library.

Credits
-------

This project would not be possible without [mcipc](https://github.com/conqp/mcipc/),
which provides the client library for Minecraft RCON.

<!-- README only content. Anything below this line won't be included in index.md -->

See https://gilesknap.github.io/mciwb for more detailed documentation.
