/*!
 * Copyright (c) 2017-present Ghostery GmbH. All rights reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import { expect } from 'chai';
import 'mocha';

import { toASCII, toUnicode } from '../src/punycode.js';

describe('#punycode', () => {
  const checkString = (hostname: string): void => {
    expect(toUnicode(toASCII(hostname))).to.equal(hostname);
  };

  it('empty string', () => {
    checkString('');
  });

  [
    // ASCII hostnames
    'expogrim.com',

    // Unicode hostnames from public suffix list
    'aéroport.ci',
    'comunicações.museum',
    'correios-e-telecomunicações.museum',
    'läns.museum',
    'åkrehamn.no',
    'ålgård.no',
    'brønnøysund.no',
    'drøbak.no',
    'florø.no',
    'hønefoss.no',
    'jørpeland.no',
    'langevåg.no',
    'mjøndalen.no',
    'mosjøen.no',
    'osøyro.no',
    'råholt.no',
    'sandnessjøen.no',
    'stjørdalshalsen.no',
    'åfjord.no',
    'ål.no',
    'ålesund.no',
    'áltá.no',
    'álaheadju.no',
    'åmli.no',
    'åmot.no',
    'andøy.no',
    'årdal.no',
    'ås.no',
    'åseral.no',
    'askøy.no',
    'åsnes.no',
    'aurskog-høland.no',
    'averøy.no',
    'bálát.no',
    'báhccavuotna.no',
    'bájddar.no',
    'báidár.no',
    'berlevåg.no',
    'bearalváhki.no',
    'bjarkøy.no',
    'bodø.no',
    'bådåddjå.no',
    'brønnøy.no',
    'bærum.no',
    'bø.telemark.no',
    'bø.nordland.no',
    'bievát.no',
    'bømlo.no',
    'båtsfjord.no',
    'báhcavuotna.no',
    'dyrøy.no',
    'dønna.no',
    'evenášši.no',
    'finnøy.no',
    'flå.no',
    'fræna.no',
    'frøya.no',
    'førde.no',
    'gáŋgaviika.no',
    'gildeskål.no',
    'gjøvik.no',
    'kråanghke.no',
    'hábmer.no',
    'hápmir.no',
    'hámmárfeasta.no',
    'ákŋoluokta.no',
    'herøy.møre-og-romsdal.no',
    'herøy.nordland.no',
    'hobøl.no',
    'holtålen.no',
    'hægebostad.no',
    'høyanger.no',
    'høylandet.no',
    'hå.no',
    'inderøy.no',
    'jølster.no',
    'kárášjohka.no',
    'gálsá.no',
    'karmøy.no',
    'klæbu.no',
    'kragerø.no',
    'krødsherad.no',
    'ráhkkerávju.no',
    'kvitsøy.no',
    'kvæfjord.no',
    'kvænangen.no',
    'návuotna.no',
    'kåfjord.no',
    'gáivuotna.no',
    'loabát.no',
    'lindås.no',
    'láhppi.no',
    'lurøy.no',
    'lærdal.no',
    'lødingen.no',
    'lørenskog.no',
    'løten.no',
    'måsøy.no',
    'muosát.no',
    'meløy.no',
    'meråker.no',
    'moåreke.no',
    'målselv.no',
    'málatvuopmi.no',
    'nååmesjevuemie.no',
    'unjárga.no',
    'davvenjárga.no',
    'ráisa.no',
    'nærøy.no',
    'nøtterøy.no',
    'øksnes.no',
    'oppegård.no',
    'ørland.no',
    'ørskog.no',
    'ørsta.no',
    'osterøy.no',
    'østre-toten.no',
    'øvre-eiker.no',
    'øyer.no',
    'øygarden.no',
    'øystre-slidre.no',
    'porsáŋgu.no',
    'radøy.no',
    'rennesøy.no',
    'risør.no',
    'rælingen.no',
    'rødøy.no',
    'rømskog.no',
    'røros.no',
    'røst.no',
    'røyken.no',
    'røyrvik.no',
    'råde.no',
    'sálát.no',
    'sálat.no',
    'sande.møre-og-romsdal.no',
    'sandøy.no',
    'skjervøy.no',
    'skiervá.no',
    'skjåk.no',
    'skånland.no',
    'skánit.no',
    'smøla.no',
    'snåsa.no',
    'snåase.no',
    'stjørdal.no',
    'søgne.no',
    'sømna.no',
    'søndre-land.no',
    'sør-aurdal.no',
    'sør-fron.no',
    'sør-odal.no',
    'sør-varanger.no',
    'mátta-várjjat.no',
    'sørfold.no',
    'sørreisa.no',
    'sørum.no',
    'tjøme.no',
    'tranøy.no',
    'tromsø.no',
    'træna.no',
    'trøgstad.no',
    'tysvær.no',
    'tønsberg.no',
    'vadsø.no',
    'čáhcesuolo.no',
    'vardø.no',
    'várggát.no',
    'vegårshei.no',
    'vestvågøy.no',
    'værøy.no',
    'vågan.no',
    'vågsøy.no',
    'vågå.no',
    'våler.østfold.no',
    'våler.hedmark.no',
    'vermögensberater',
    'vermögensberatung',
  ].forEach((hostname) => {
    it(hostname, () => {
      checkString(hostname);
    });
  });
});
