import XCTest

 #if os(iOS) || os(tvOS) || targetEnvironment(macCatalyst)
 class UIViewControllerSentryTests: XCTestCase {

     func testOnlyOneViewController() {
         let viewController = UIViewController()

         XCTAssertEqual([viewController], SentryViewController.descendants(of: viewController))
     }

     func testTwoChildViewController() {
         let root = UIViewController()

         let child1 = UIViewController()
         root.addChild(child1)

         let child2 = UIViewController()
         root.addChild(child2)

         XCTAssertEqual(Set([root, child2, child1]), Set(SentryViewController.descendants(of: root)))
     }

     func testGrandChildViewController() {
         let root = UIViewController()

         let child = UIViewController()
         root.addChild(child)

         let grandChild1 = UIViewController()
         child.addChild(grandChild1)

         let grandChild2 = UIViewController()
         child.addChild(grandChild2)

         XCTAssertEqual(Set([root, child, grandChild2, grandChild1]), Set(SentryViewController.descendants(of: root)))
     }
 }

 #endif
