// Adapted from: https://github.com/kstenerud/KSCrash
//
//  SentryCrashDebug.c
//
//  Created by Karl Stenerud on 2012-01-29.
//
//  Copyright (c) 2012 Karl Stenerud. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall remain in place
// in this source code.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#include "SentryCrashDebug.h"

#include "SentryAsyncSafeLog.h"

#include <errno.h>
#include <string.h>
#include <sys/sysctl.h>
#include <unistd.h>

/** Check if the current process is being traced or not.
 *
 * @return true if we're being traced.
 */
bool
sentrycrashdebug_isBeingTraced(void)
{
    struct kinfo_proc procInfo;

    // Initialize the flags so that, if sysctl fails for some bizarre
    // reason, we get a predictable result. (see
    // https://developer.apple.com/library/archive/qa/qa1361/_index.html)
    procInfo.kp_proc.p_flag = 0;

    size_t structSize = sizeof(procInfo);
    int mib[] = { CTL_KERN, KERN_PROC, KERN_PROC_PID, getpid() };

    if (sysctl(mib, sizeof(mib) / sizeof(*mib), &procInfo, &structSize, NULL, 0) != 0) {
        SENTRY_ASYNC_SAFE_LOG_ERROR("sysctl: %s", strerror(errno));
        return false;
    }

    return (procInfo.kp_proc.p_flag & P_TRACED) != 0;
}
