#import "NSLocale+Sentry.h"

@implementation SentryLocale

+ (BOOL)timeIs24HourFormat
{
    NSDateFormatter *formatter = [NSDateFormatter new];
    [formatter setDateStyle:NSDateFormatterNoStyle];
    [formatter setTimeStyle:NSDateFormatterShortStyle];
    NSString *dateString = [formatter stringFromDate:[NSDate date]];
    NSRange amRange = [dateString rangeOfString:[formatter AMSymbol]];
    NSRange pmRange = [dateString rangeOfString:[formatter PMSymbol]];
    BOOL is24Hour = amRange.location == NSNotFound && pmRange.location == NSNotFound;
    return is24Hour;
}

+ (BOOL)isRightToLeftLanguage
{
    return [NSLocale characterDirectionForLanguage:NSLocale.currentLocale.languageCode]
        == NSLocaleLanguageDirectionRightToLeft;
}

@end
