export function TailwindHubLogo({ width = "2rem", height = "2rem" }) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      width={width}
      height={height}
      xmlSpace="preserve"
      version="1.1"
      viewBox="0 0 500 500"
    >
      <image
        width="500"
        height="500"
        xlinkHref="data:image/png;base64,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"
      />
    </svg>
  );
}
