"use strict";

const { WEBDRIVER_PROTOCOL, SAVE_HISTORY_MODE, NODEJS_TEST_RUN_ENV } = require("../constants/config");

module.exports = {
    baseUrl: "http://localhost",
    gridUrl: "http://localhost:4444/wd/hub",
    browserWSEndpoint: null,
    desiredCapabilities: null,
    automationProtocol: WEBDRIVER_PROTOCOL,
    sessionEnvFlags: {},
    screenshotsDir: "testplane/screens",
    diffColor: "#ff00ff",
    tolerance: 2.3,
    antialiasingTolerance: 4,
    disableAnimation: true,
    compareOpts: {
        shouldCluster: false,
        clustersSize: 10,
        stopOnFirstFail: false,
    },
    buildDiffOpts: {
        ignoreAntialiasing: true,
        ignoreCaret: true,
    },
    assertViewOpts: {
        ignoreElements: [],
        captureElementFromTop: true,
        allowViewportOverflow: false,
        ignoreDiffPixelCount: 0,
    },
    openAndWaitOpts: {
        waitNetworkIdle: true,
        waitNetworkIdleTimeout: 500,
        failOnNetworkError: true,
        ignoreNetworkErrorsPatterns: [],
    },
    calibrate: false,
    screenshotMode: "auto",
    screenshotDelay: 0,
    compositeImage: true,
    prepareBrowser: null,
    prepareEnvironment: null,
    waitTimeout: 3000,
    waitInterval: 500,
    httpTimeout: 30000,
    urlHttpTimeout: null,
    pageLoadTimeout: 20000,
    sessionRequestTimeout: null,
    sessionQuitTimeout: 5000,
    testTimeout: null,
    takeScreenshotOnFails: {
        testFail: true,
        assertViewFail: true,
    },
    takeScreenshotOnFailsTimeout: 5000,
    takeScreenshotOnFailsMode: "fullpage",
    reporters: ["flat"],
    debug: false,
    parallelLimit: Infinity,
    sessionsPerBrowser: 1,
    testsPerSession: Infinity,
    workers: 1,
    testsPerWorker: Infinity,
    retry: 0,
    shouldRetry: null,
    mochaOpts: {
        slow: 10000,
        timeout: 60000,
    },
    expectOpts: {
        wait: 3000,
        interval: 100,
    },
    patternsOnReject: [],
    meta: null,
    windowSize: null,
    tempDir: "",
    orientation: null,
    waitOrientationChange: true,
    resetCursor: true,
    strictTestsOrder: false,
    saveHistoryMode: SAVE_HISTORY_MODE.ALL,
    fileExtensions: [".js", ".mjs", ".ts", ".mts", ".jsx", ".tsx"],
    outputDir: null,
    agent: null,
    headers: null,
    transformRequest: null,
    transformResponse: null,
    strictSSL: null,
    user: null,
    key: null,
    region: null,
    headless: null,
    isolation: null,
    testRunEnv: NODEJS_TEST_RUN_ENV,
    lastFailed: {
        only: false,
        output: ".testplane/failed.json",
        input: ".testplane/failed.json",
    },
    devServer: {
        command: null,
        cwd: null,
        env: {},
        args: [],
        logs: true,
        readinessProbe: {
            url: null,
            isReady: null,
            timeouts: {
                waitServerTimeout: 60000, // 60s
                probeRequestTimeout: 10000, // 10s
                probeRequestInterval: 1000, // 1s
            },
        },
    },
    passive: false,
};

module.exports.configPaths = [
    ".testplane.conf.ts",
    ".testplane.conf.js",
    "testplane.config.ts",
    "testplane.config.js",
    "testplane.config.cts",
    "testplane.config.cjs",
    ".hermione.conf.ts",
    ".hermione.conf.js",
];
