enum Scopes {
    BROWSER = "b",
    ELEMENT = "e",
}

const wdioBrowserCommands = [
    "$$",
    "$",
    "action",
    "actions",
    "addCommand",
    "call",
    "custom$$",
    "custom$",
    "debug",
    "deleteCookies",
    "execute",
    "executeAsync",
    "getCookies",
    "getPuppeteer",
    "getWindowSize",
    "keys",
    "mock",
    "mockClearAll",
    "mockRestoreAll",
    "newWindow",
    "overwriteCommand",
    "pause",
    "react$$",
    "react$",
    "reloadSession",
    "savePDF",
    "saveRecordingScreen",
    "saveScreenshot",
    "scroll",
    "setCookies",
    "setTimeout",
    "setWindowSize",
    "switchWindow",
    "throttle",
    "touchAction",
    "uploadFile",
    "url",
    "waitUntil",
];

const wdioElementCommands = [
    "$$",
    "$",
    "addValue",
    "clearValue",
    "click",
    "custom$",
    "custom$$",
    "doubleClick",
    "dragAndDrop",
    "getAttribute",
    "getCSSProperty",
    "getComputedLabel",
    "getComputedRole",
    "getHTML",
    "getLocation",
    "getProperty",
    "getSize",
    "getTagName",
    "getText",
    "getValue",
    "isClickable",
    "isDisplayed",
    "isDisplayedInViewport",
    "isEnabled",
    "isEqual",
    "isExisting",
    "isFocused",
    "isSelected",
    "moveTo",
    "nextElement",
    "parentElement",
    "previousElement",
    "react$",
    "react$$",
    "saveScreenshot",
    "scrollIntoView",
    "selectByAttribute",
    "selectByIndex",
    "selectByVisibleText",
    "setValue",
    "shadow$",
    "shadow$$",
    "touchAction",
    "waitForClickable",
    "waitForDisplayed",
    "waitForEnabled",
    "waitForExist",
    "waitUntil",
];

export const getBrowserCommands = (): typeof wdioBrowserCommands => wdioBrowserCommands;
export const getElementCommands = (): typeof wdioElementCommands => wdioElementCommands;
export const createScope = (elementScope: boolean): `${Scopes}` => {
    return elementScope ? Scopes.ELEMENT : Scopes.BROWSER;
};
