import fs from "fs-extra";
import { getBrowserPlatform } from "../../../utils";

export const fetchChromiumMilestoneVersions = async (): Promise<string[]> => {
    try {
        const platform = getBrowserPlatform();

        const revisionsPath = require.resolve(`../../../chromium/revisions/autogenerated/${platform}`);
        const versions = await fs.readJSON(revisionsPath);

        return Object.keys(versions);
    } catch (err) {
        throw new Error(`Couldn't get chromium versions: ${err}`);
    }
};
