---
title: Getting started with gem5 development
author: Jason Lowe-Power
slides_code: "intro-05-intro-devel-jason.pdf"
livestream_code: U4xThpRC1AI
---

## Why develop gem5?

- Add new models
- Extend current models
- Fix things and contribute back!

### A bit about the difference between C++ and python

- The *models* are in C++
- The parameters that you can change are declared in `src/`, but in a "python" file (SimObject description file)
- You have an "instance" or "configuration" which sets the parameters.

- An analogy
  - The model is "An out of order CPU"
  - The parameters are the size of the reorder buffer and the issue width
  - The "instance" or "configuration" is an i7-7700

### What is a SimObject?

- Main thing that gem5 uses as the bridge from the C++ models to the python configuration
- Things in `src/` and in the SimObjects should be the *model* not the configuration.

### gem5's event queue

- A bit about event-driven programming
- What it means for events to execute
- Relation between SimObjects and events

## Building gem5

- Dependencies
- Build system: [SCons](https://scons.org/)
- Build parameters
  - Two types: gem5 features and compiler parameters
  - Opt/fast, profiling, linker
  - ISA, GPU, Ruby protocol, others

## Making modifications and using git

- Install the hooks!
- Use the style checker! Don't ignore it!
- Create a branch for yourself
- Use good commit messages... it's worth the time!
