---
title: Getting started with gem5
author: ["Jason Lowe-Power", "Hoa Nguyen"]
livestream_code: n-jeY_tWzVY
slides_code: "intro-04-python3-reminder-hoa.pdf"
example_code: /materials/introduction/02-gem5-basics
---

## Running gem5

- Interface is python3.
- gem5 python environment can be thought as python3 environment + m5 library + gem5 standard library.
  - There is no magic: the paths to the m5 library and gem5 standard library are compiled to the gem5 library (provide reference to the source code).
  - Scripts without using m5 library and gem5 library can be run by both gem5 and python.
- Demo of,
  - A simple script that can be run by both gem5 and python3.
  - A simple script that can only be run by gem5.
- The python script inputted to gem5 is usually referred as "system configuration", "configuration script", "python config", etc.

## Things to touch on

- "Model" vs "configuration"


### First configuration example

```python

```

## gem5's output

- `m5out/`
- `stats.txt`
  - Where the stats are.
  - Dumping stats: telling gem5 to emit all stats by appending the stat to the file `stats.txt`.
  - The stats will always be dumped at the end of simulations.
  - The stats can be manually dumped multiple times *during* a simulation, thus there could be multiple sets of stats in `stats.txt`.
    - The first N-1 ones are manually dumped.
    - The last one is dumped automatically.
  - Stats can be reset via m5.stats.reset() or m5_reset_stats()?
  - It is important to know which stats set belong to which stat dump command.
- `config.ini`, `config.json`, `config.dot`, `config.dot.pdf`, `config.dot.svg`,
  - How gem5 interpret the system configuration script.
  - Useful for sanity check: strongly recommended to check the outputted config file for each simulation.
- The difference between simulated and wallclock

## Python reminder

This is where we give a brief overview of python.

- Briefly going over the basics of the language,
  - Types: int, string, dict, list, set, tuple.
  - Controls: for/while loops, if statements.
  - Functions.
- Detailed covering of frequently used features,
  - List comprehension: used for making a list of SimObject's.
    - Appending a SimObject to a list is not allowed.
  - Iterator/Generator: "lazily" constructing a list of object,
    - Returning all objects in a list all at once vs returning the next object when queried.
    - Examples.
  - Importing modules,
    - Importing python standard modules.
    - Importing a python file as a module.
    - Importing m5 module, gem5 module (the gem5 module is known as the gem5 standard library).
  - Object oriented programming,
    - Base (parent) class, derived (child) class.
      - The child class inherits all functions and variables.
    - Overriding a function.
      - If the child class and the parent class provide a function with the same name, the child's function will be called.
    - Class vs instance/object.
      - A class can be thought as a blueprint for an object of the same class.
    - Class variables vs object variables.
      - The class variables are not unique among objects.
      - The object variables are unique among objects.
    - Class functions vs object functions.
      - The class functions are not unique among objects.
      - The object functions are unique among objects.
    - Abstract functions, abstract classes.
      - abc library in python.
      - How to use @abstractmethod to define an abstract function.
      - A class is abstract if it contains at least one abstract functions.
      - Providing the guarantee (or interface) that all classes inherited from this class will have the abstract function defined.
  - m5 library,
    - m5.instatiate()
      - Tell gem5 to connect SimObject as specified in the script.
      - After this statement, the system configuration should not be modified.
    - m5.simulate()
      - Running the simulation.
      - Can specify how many instructions to simulate.
    - m5.stats.dump()
    - m5.stats.reset()
  - argparse
    - Parameterize the configuration script.
    - Example usage.
  - seaborn
    - Example usage of a barplot.


### Example for Python reminder

- Parameterized input using argparse.
- Calling m5.stats.dump() once.
- Using python3 to parse the stats file and graphing results using seaborn.
