% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{about_search_regex}
\alias{about_search_regex}
\alias{search_regex}
\alias{stringi-search-regex}
\title{Regular Expressions in \pkg{stringi}}
\description{
A regular expression is a pattern describing, possibly in a very
abstract way, a text fragment.
With so many regex functions in \pkg{stringi},
regular expressions may be a very powerful tool
to perform string searching, substring extraction, string splitting, etc.,
tasks.
}
\details{
All \code{stri_*_regex} functions in \pkg{stringi} use
the \pkg{ICU} regex engine. Its settings may be tuned up (for example
to perform case-insensitive search) via the
\code{\link{stri_opts_regex}} function.


Regular expression patterns in \pkg{ICU} are quite similar in form and
behavior to Perl's regexes. Their implementation is loosely inspired
by JDK 1.4 \code{java.util.regex}.
\pkg{ICU} Regular Expressions conform to the Unicode Technical Standard #18
(see References section) and its features are summarized in
the ICU User Guide (see below). A good general introduction
to regexes is (Friedl, 2002).
Some general topics are also covered in the \R manual, see \link{regex}.
}
\section{\pkg{ICU} Regex Operators at a Glance}{


Here is a list of operators provided by the
ICU User Guide on regexes.

\describe{
\item{\code{|}}{Alternation. \code{A|B} matches either A or B.}
\item{\code{*}}{Match 0 or more times. Match as many times as possible.}
\item{\code{+}}{Match 1 or more times. Match as many times as possible.}
\item{\code{?}}{Match zero or one times. Prefer one.}
\item{\code{{n}} }{Match exactly n times.}
\item{\code{{n,}} }{Match at least n times. Match as many times as possible.}
\item{\code{{n,m}} }{Match between n and m times.
Match as many times as possible, but not more than m.}
\item{\code{*?}}{Match 0 or more times. Match as few times as possible.}
\item{\code{+?}}{Match 1 or more times. Match as few times as possible.}
\item{\code{??}}{Match zero or one times. Prefer zero.}
\item{\code{{n}?}}{Match exactly n times.}
\item{\code{{n,}?}}{Match at least n times, but no more than required
for an overall pattern match.}
\item{\code{{n,m}?}}{Match between n and m times. Match as few times
as possible, but not less than n.}
\item{\code{*+}}{Match 0 or more times. Match as many times as possible
when first encountered, do not retry with fewer even if overall match fails
(Possessive Match).}
\item{\code{++}}{Match 1 or more times. Possessive match.}
\item{\code{?+}}{Match zero or one times. Possessive match.}
\item{\code{{n}+}}{Match exactly n times.}
\item{\code{{n,}+}}{Match at least n times. Possessive Match.}
\item{\code{{n,m}+}}{Match between n and m times. Possessive Match.}
\item{\code{(...)}}{Capturing parentheses. Range of input that matched
the parenthesized sub-expression is available after the match,
see \code{\link{stri_match}}.}
\item{\code{(?:...)}}{Non-capturing parentheses. Groups the included pattern,
but does not provide capturing of matching text. Somewhat more efficient
than capturing parentheses.}
\item{\code{(?>...)}}{Atomic-match parentheses. The first match of the
parenthesized sub-expression is the only one tried; if it does not lead to
an overall pattern match, back up the search for a match to a position
before the \code{(?>}.}
\item{\code{(?#...)}}{Free-format comment \code{(?# comment )}.}
\item{\code{(?=...)}}{Look-ahead assertion. True if the parenthesized
pattern matches at the current input position, but does not advance
the input position.}
\item{\code{(?!...)}}{Negative look-ahead assertion. True if the
parenthesized pattern does not match at the current input position.
Does not advance the input position.}
\item{\code{(?<=...)}}{Look-behind assertion. True if the parenthesized
pattern matches text preceding the current input position, with the last
character of the match being the input character just before the current
position. Does not alter the input position. The length of possible strings
matched by the look-behind pattern must not be unbounded (no \code{*}
or \code{+} operators.)}
\item{\code{(?<!...)}}{Negative Look-behind assertion. True if the
parenthesized pattern does not match text preceding the current input
position, with the last character of the match being the input character
just before the current position. Does not alter the input position.
The length of possible strings matched by the look-behind pattern must
not be unbounded (no \code{*} or \code{+} operators.)}
\item{\code{(?<name>...)}}{Named capture group, where \code{name}
    (enclosed within the angle brackets)
    is a sequence like \code{[A-Za-z][A-Za-z0-9]*}}
\item{\code{(?ismwx-ismwx:...)}}{Flag settings. Evaluate the parenthesized
expression with the specified flags enabled or \code{-}disabled,
see also \code{\link{stri_opts_regex}}.}
\item{\code{(?ismwx-ismwx)}}{Flag settings. Change the flag settings.
Changes apply to the portion of the pattern following the setting.
For example, \code{(?i)} changes to a case insensitive match,
see also \code{\link{stri_opts_regex}}.}
}
}

\section{\pkg{ICU} Regex Meta-characters at a Glance}{


Here is a list of meta-characters provided by the
ICU User Guide on regexes.

\describe{
\item{\code{\\a}}{Match a BELL, \code{\\u0007}.}
\item{\code{\\A}}{Match at the beginning of the input. Differs from \code{^}.
   in that \code{\\A} will not match after a new line within the input.}
\item{\code{\\b}}{Match if the current position is a word boundary.
   Boundaries occur at the transitions between word (\code{\\w}) and non-word
   (\code{\\W}) characters, with combining marks ignored. For better word
   boundaries, see \pkg{ICU} Boundary Analysis, e.g., \code{\link{stri_extract_all_words}}.}
\item{\code{\\B}}{Match if the current position is not a word boundary.}
\item{\code{\\cX}}{Match a control-\code{X} character.}
\item{\code{\\d}}{Match any character with the Unicode General Category of
   \code{Nd} (Number, Decimal Digit.).}
\item{\code{\\D}}{Match any character that is not a decimal digit.}
\item{\code{\\e}}{Match an ESCAPE, \code{\\u001B}.}
\item{\code{\\E}}{Terminates a \code{\\Q} ... \code{\\E} quoted sequence.}
\item{\code{\\f}}{Match a FORM FEED, \code{\\u000C}.}
\item{\code{\\G}}{Match if the current position is at the end of the
   previous match.}
\item{\code{\\h}}{Match a Horizontal White Space character.
   They are characters with Unicode General Category of Space_Separator plus
   the ASCII tab, \code{\\u0009}. [Since ICU 55]}
\item{\code{\\H}}{Match a non-Horizontal White Space character.
   [Since ICU 55]}
\item{\code{\\k<name>}}{Named Capture Back Reference. [Since ICU 55]}
\item{\code{\\n}}{Match a LINE FEED, \code{\\u000A}.}
\item{\code{\\N{UNICODE CHARACTER NAME}} }{Match the named character.}
\item{\code{\\p{UNICODE PROPERTY NAME}} }{Match any character with the
   specified Unicode Property.}
\item{\code{\\P{UNICODE PROPERTY NAME}} }{Match any character not having
   the specified Unicode Property.}
\item{\code{\\Q}}{Quotes all following characters until \code{\\E}.}
\item{\code{\\r}}{Match a CARRIAGE RETURN, \code{\\u000D}.}
\item{\code{\\s}}{Match a white space character. White space is defined
   as \code{[\\t\\n\\f\\r\\p{Z}]}.}
\item{\code{\\S}}{Match a non-white space character.}
\item{\code{\\t}}{Match a HORIZONTAL TABULATION, \code{\\u0009}.}
\item{\code{\\uhhhh}}{Match the character with the hex value \code{hhhh}.}
\item{\code{\\Uhhhhhhhh}}{Match the character with the hex value \code{hhhhhhhh}.
   Exactly eight hex digits must be provided, even though the largest
   Unicode code point is \code{\\U0010ffff}.}
\item{\code{\\w}}{Match a word character. Word characters are
   \code{[\\p{Alphabetic}\\p{Mark}\\p{Decimal_Number}\\p{Connector_Punctuation}\\u200c\\u200d]}.}
\item{\code{\\W}}{Match a non-word character.}
\item{\code{\\x{hhhh}} }{Match the character with hex value hhhh.
From one to six hex digits may be supplied.}
\item{\code{\\xhh}}{Match the character with two digit hex value hh }
\item{\code{\\X}}{Match a Grapheme Cluster.}
\item{\code{\\Z}}{Match if the current position is at the end of input,
 but before the final line terminator, if one exists.}
\item{\code{\\z}}{Match if the current position is at the end of input.}
\item{\code{\\n}}{Back Reference. Match whatever the nth capturing
group matched. n must be a number > 1 and < total number of capture
groups in the pattern.}
\item{\code{\\0ooo}}{Match an Octal character.  \code{'ooo'} is from one to three
octal digits.  0377 is the largest allowed Octal character.  The leading
zero is required; it distinguishes Octal constants from back references.}
\item{\code{[pattern]}}{Match any one character from the set.}
\item{\code{.}}{Match any character except for - by default - newline, compare \code{\link{stri_opts_regex}}.}
\item{\code{^}}{Match at the beginning of a line.}
\item{\code{$}}{Match at the end of a line.}
\item{\code{\\}}{[outside of sets] Quotes the following character.
Characters that must be quoted to be treated as literals are
   \code{* ? + [ ( ) { } ^ $ | \\ .}.}
\item{\code{\\}}{[inside sets] Quotes the following character.
   Characters that must be quoted to be treated as literals are
   \code{[ ] \\}; Characters that may need to be quoted, depending
   on the context are \code{- &}.}
}
}

\section{Character Classes}{


The syntax is similar, but not 100\% compatible with the one
described in \link{about_search_charclass}. In particular,
whitespaces are not ignored and set-theoretic operations are
denoted slightly differently. However, other than this
\link{about_search_charclass} is a good reference
on the capabilities offered.

The ICU User Guide on regexes lists what follows.

\describe{
\item{\code{[abc]}}{Match any of the characters a, b, or c}
\item{\code{[^abc]}}{Negation -- match any character except a, b, or c}
\item{\code{[A-M]}}{Range -- match any character from A to M (based on Unicode code point ordering)}
\item{\code{[\\p{L}]}, \code{[\\p{Letter}]}, \code{[\\p{General_Category=Letter}]}, \code{[:letter:]}}{Characters with Unicode Category = Letter (4 equivalent forms)}
\item{\code{[\\P{Letter}]}}{Negated property -- natch everything except Letters}
\item{\code{[\\p{numeric_value=9}]}}{Match all numbers with a numeric value of 9}
\item{\code{[\\p{Letter}&&\\p{script=cyrillic}]}}{Intersection; match the set of all Cyrillic letters}
\item{\code{[\\p{Letter}--\\p{script=latin}]}}{Set difference; match all non-Latin letters}
\item{\code{[[a-z][A-Z][0-9]]}, \code{[a-zA-Z0-9]}}{Union; match ASCII letters and digits (2 equivalent forms)}
}
}

\section{Regex Functions in \pkg{stringi}}{


Note that if a given regex \code{pattern} is empty,
then all the functions in \pkg{stringi} give \code{NA} in result
and generate a warning.
On a syntax error, a quite informative failure message is shown.

If you wish to search for a fixed pattern,
refer to \link{about_search_coll} or \link{about_search_fixed}.
They allow to perform a locale-aware text lookup,
or a very fast exact-byte search, respectively.
}

\references{
\emph{Regular expressions} -- ICU User Guide,
\url{https://unicode-org.github.io/icu/userguide/strings/regexp.html}

J.E.F. Friedl, \emph{Mastering Regular Expressions}, O'Reilly, 2002

\emph{Unicode Regular Expressions} -- Unicode Technical Standard #18,
\url{https://www.unicode.org/reports/tr18/}

\emph{Unicode Regular Expressions} -- Regex tutorial,
\url{https://www.regular-expressions.info/unicode.html}
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other search_regex: 
\code{\link{about_search}},
\code{\link{stri_opts_regex}()}

Other stringi_general_topics: 
\code{\link{about_arguments}},
\code{\link{about_encoding}},
\code{\link{about_locale}},
\code{\link{about_search}},
\code{\link{about_search_boundaries}},
\code{\link{about_search_charclass}},
\code{\link{about_search_coll}},
\code{\link{about_search_fixed}},
\code{\link{about_stringi}}
}
\concept{search_regex}
\concept{stringi_general_topics}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
