% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{about_search_fixed}
\alias{about_search_fixed}
\alias{search_fixed}
\alias{stringi-search-fixed}
\title{Locale-Insensitive Fixed Pattern Matching in \pkg{stringi}}
\description{
String searching facilities described here
provide a way to locate a specific sequence of bytes in a string.
The search engine's settings may be tuned up (for example
to perform case-insensitive search) via a call to the
\code{\link{stri_opts_fixed}} function.
}
\section{Byte Compare}{


The fast Knuth-Morris-Pratt search algorithm, with worst time complexity of
O(n+p) (\code{n == length(str)}, \code{p == length(pattern)})
is implemented (with some tweaks for very short search patterns).

Be aware that, for natural language processing,
fixed pattern searching might not be what
you actually require. It is because a bitwise match will
not give correct results in cases of:
\enumerate{
\item accented letters;
\item conjoined letters;
\item ignorable punctuation;
\item ignorable case,
}
see also \link{about_search_coll}.

Note that the conversion of input data
to Unicode is done as usual.
}

\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other search_fixed: 
\code{\link{about_search}},
\code{\link{stri_opts_fixed}()}

Other stringi_general_topics: 
\code{\link{about_arguments}},
\code{\link{about_encoding}},
\code{\link{about_locale}},
\code{\link{about_search}},
\code{\link{about_search_boundaries}},
\code{\link{about_search_charclass}},
\code{\link{about_search_coll}},
\code{\link{about_search_regex}},
\code{\link{about_stringi}}
}
\concept{search_fixed}
\concept{stringi_general_topics}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
