# stri_replace_na: Replace Missing Values in a Character Vector

## Description

This function gives a convenient way to replace each missing (`NA`) value with a given string.

## Usage

``` r
stri_replace_na(str, replacement = "NA")
```

## Arguments

|               |                                            |
|---------------|--------------------------------------------|
| `str`         | character vector or an object coercible to |
| `replacement` | single string                              |

## Details

This function is roughly equivalent to `str2 <- stri_enc_toutf8(str); str2[is.na(str2)] <- stri_enc_toutf8(replacement); str2`. It may be used, e.g., wherever the \'plain R\' `NA` handling is desired, see Examples.

## Value

Returns a character vector.

## Author(s)

[Marek Gagolewski](https://www.gagolewski.com/) and other contributors

## See Also

The official online manual of <span class="pkg">stringi</span> at <https://stringi.gagolewski.com/>

Gagolewski M., <span class="pkg">stringi</span>: Fast and portable character string processing in R, *Journal of Statistical Software* 103(2), 2022, 1-59, [doi:10.18637/jss.v103.i02](https://doi.org/10.18637/jss.v103.i02)

Other utils: [`stri_list2matrix()`](stri_list2matrix.md), [`stri_na2empty()`](stri_na2empty.md), [`stri_remove_empty()`](stri_remove_empty.md)

## Examples




``` r
x <- c('test', NA)
stri_paste(x, 1:2)                           # 'test1' NA
```

```
## [1] "test1" NA
```

``` r
paste(x, 1:2)                                # 'test 1' 'NA 2'
```

```
## [1] "test 1" "NA 2"
```

``` r
stri_paste(stri_replace_na(x), 1:2, sep=' ') # 'test 1' 'NA 2'
```

```
## [1] "test 1" "NA 2"
```
