# stri_list2matrix: Convert a List to a Character Matrix

## Description

This function converts a given list of atomic vectors to a character matrix.

## Usage

``` r
stri_list2matrix(
  x,
  byrow = FALSE,
  fill = NA_character_,
  n_min = 0,
  by_row = byrow
)
```

## Arguments

|  |  |
|----|----|
| `x` | a list of atomic vectors |
| `byrow` | a single logical value; should the resulting matrix be transposed? |
| `fill` | a single string, see Details |
| `n_min` | a single integer value; minimal number of rows (`byrow==FALSE`) or columns (otherwise) in the resulting matrix |
| `by_row` | alias of `byrow` |

## Details

This function is similar to the built-in [`simplify2array`](https://stat.ethz.ch/R-manual/R-devel/library/base/html/lapply.html) function. However, it always returns a character matrix, even if each element in `x` is of length 1 or if elements in `x` are not of the same lengths. Moreover, the elements in `x` are always coerced to character vectors.

If `byrow` is `FALSE`, then a matrix with `length(x)` columns is returned. The number of rows is the length of the longest vector in `x`, but no less than `n_min`. Basically, we have `result[i,j] == x[[j]][i]` if `i <= length(x[[j]])` and `result[i,j] == fill` otherwise, see Examples.

If `byrow` is `TRUE`, then the resulting matrix is a transposition of the above-described one.

This function may be useful, e.g., in connection with [`stri_split`](stri_split.md) and [`stri_extract_all`](stri_extract.md).

## Value

Returns a character matrix.

## Author(s)

[Marek Gagolewski](https://www.gagolewski.com/) and other contributors

## See Also

The official online manual of <span class="pkg">stringi</span> at <https://stringi.gagolewski.com/>

Gagolewski M., <span class="pkg">stringi</span>: Fast and portable character string processing in R, *Journal of Statistical Software* 103(2), 2022, 1-59, [doi:10.18637/jss.v103.i02](https://doi.org/10.18637/jss.v103.i02)

Other utils: [`stri_na2empty()`](stri_na2empty.md), [`stri_remove_empty()`](stri_remove_empty.md), [`stri_replace_na()`](stri_replace_na.md)

## Examples




``` r
simplify2array(list(c('a', 'b'), c('c', 'd'), c('e', 'f')))
```

```
##      [,1] [,2] [,3]
## [1,] "a"  "c"  "e" 
## [2,] "b"  "d"  "f"
```

``` r
stri_list2matrix(list(c('a', 'b'), c('c', 'd'), c('e', 'f')))
```

```
##      [,1] [,2] [,3]
## [1,] "a"  "c"  "e" 
## [2,] "b"  "d"  "f"
```

``` r
stri_list2matrix(list(c('a', 'b'), c('c', 'd'), c('e', 'f')), byrow=TRUE)
```

```
##      [,1] [,2]
## [1,] "a"  "b" 
## [2,] "c"  "d" 
## [3,] "e"  "f"
```

``` r
simplify2array(list('a', c('b', 'c')))
```

```
## [[1]]
## [1] "a"
## 
## [[2]]
## [1] "b" "c"
```

``` r
stri_list2matrix(list('a', c('b', 'c')))
```

```
##      [,1] [,2]
## [1,] "a"  "b" 
## [2,] NA   "c"
```

``` r
stri_list2matrix(list('a', c('b', 'c')), fill='')
```

```
##      [,1] [,2]
## [1,] "a"  "b" 
## [2,] ""   "c"
```

``` r
stri_list2matrix(list('a', c('b', 'c')), fill='', n_min=5)
```

```
##      [,1] [,2]
## [1,] "a"  "b" 
## [2,] ""   "c" 
## [3,] ""   ""  
## [4,] ""   ""  
## [5,] ""   ""
```
