#include "version.h"
#include <thread>
#include <chrono>
#include "main.h"
#include <filesystem>

HMODULE version_dll;

#define WRAPPER_GENFUNC(name) \
	FARPROC o##name; \
	__declspec(naked) void _##name() \
	{ \
		__asm jmp[o##name] \
	}

WRAPPER_GENFUNC(GetFileVersionInfoA)
WRAPPER_GENFUNC(GetFileVersionInfoByHandle)
WRAPPER_GENFUNC(GetFileVersionInfoExW)
WRAPPER_GENFUNC(GetFileVersionInfoExA)
WRAPPER_GENFUNC(GetFileVersionInfoSizeA)
WRAPPER_GENFUNC(GetFileVersionInfoSizeExA)
WRAPPER_GENFUNC(GetFileVersionInfoSizeExW)
WRAPPER_GENFUNC(GetFileVersionInfoSizeW)
WRAPPER_GENFUNC(GetFileVersionInfoW)
WRAPPER_GENFUNC(VerFindFileA)
WRAPPER_GENFUNC(VerFindFileW)
WRAPPER_GENFUNC(VerInstallFileA)
WRAPPER_GENFUNC(VerInstallFileW)
WRAPPER_GENFUNC(VerLanguageNameA)
WRAPPER_GENFUNC(VerLanguageNameW)
WRAPPER_GENFUNC(VerQueryValueA)
WRAPPER_GENFUNC(VerQueryValueW)

#define WRAPPER_FUNC(name) o##name = GetProcAddress(version_dll, ###name);

void load_version() {
	char systemPath[MAX_PATH];
	GetSystemDirectoryA(systemPath, MAX_PATH);
	strcat_s(systemPath, "\\version.dll");
	version_dll = LoadLibraryA(systemPath);	

#if _DEBUG
	if (!version_dll) {
		std::string message = "Unable to load " + std::string(systemPath);
		MessageBoxA(NULL, message.c_str(), "SickoMenu", MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
	}
#endif

	if (!version_dll) return;

	WRAPPER_FUNC(GetFileVersionInfoA);
	WRAPPER_FUNC(GetFileVersionInfoByHandle);
	WRAPPER_FUNC(GetFileVersionInfoExW);
	WRAPPER_FUNC(GetFileVersionInfoExA);
	WRAPPER_FUNC(GetFileVersionInfoSizeA);
	WRAPPER_FUNC(GetFileVersionInfoSizeExW);
	WRAPPER_FUNC(GetFileVersionInfoSizeExA);
	WRAPPER_FUNC(GetFileVersionInfoSizeW);
	WRAPPER_FUNC(GetFileVersionInfoW);
	WRAPPER_FUNC(VerFindFileA);
	WRAPPER_FUNC(VerFindFileW);
	WRAPPER_FUNC(VerInstallFileA);
	WRAPPER_FUNC(VerInstallFileW);
	WRAPPER_FUNC(VerLanguageNameA);
	WRAPPER_FUNC(VerLanguageNameW);
	WRAPPER_FUNC(VerQueryValueA);
	WRAPPER_FUNC(VerQueryValueW);
}

std::filesystem::path getApplicationPath() {
	TCHAR buff[MAX_PATH];
	GetModuleFileName(NULL, buff, MAX_PATH);
	return std::filesystem::path(buff);
}

DWORD WINAPI Load(LPVOID lpParam) {
	auto applicationPath = getApplicationPath();

	load_version();
	if (!version_dll)
		return 0;

	if (applicationPath.filename() != "Among Us.exe") return 0;

	// Wait for Unity.InitializeEngineNoGraphics().
	HWND hWnd = nullptr;
	while (true) {
		hWnd = FindWindowEx(nullptr, hWnd, TEXT("UnityWndClass"), nullptr);
		if (hWnd) {
			DWORD pid = 0;
			GetWindowThreadProcessId(hWnd, &pid);
			if (pid == GetCurrentProcessId()) {
				break;
			}
			continue;
		}
		std::this_thread::sleep_for(std::chrono::milliseconds(1000));
	}
	// Wait for Unity.InitializeEngineGraphics().
	while (!IsWindowVisible(hWnd)) {
		std::this_thread::sleep_for(std::chrono::milliseconds(1000));
	}
	//std::this_thread::sleep_for(std::chrono::milliseconds(3000));
	Run(lpParam);

	return 0;
}