import type { Pluggable } from 'unified';

export type ResolvePlugins = Pluggable[] | ((v: Pluggable[]) => Pluggable[]);

export function pluginOption(
  def: (v: Pluggable[]) => (Pluggable | false)[],
  options: ResolvePlugins = [],
): Pluggable[] {
  const list = def(Array.isArray(options) ? options : []).filter(
    Boolean,
  ) as Pluggable[];

  if (typeof options === 'function') {
    return options(list);
  }

  return list;
}
