/**
 * Users who sponsored with their personal account as an organization
 */
export const organizationUsers = ['marclave', 'rishi-raj-jain', 'handotdev'];

export const sponsorTiers = [
  {
    type: 'golden',
    label: 'Golden Sponsor',
  },
  {
    type: 'sliver',
    label: 'Sliver Sponsor',
  },
];

export const sponsorData: Record<
  string,
  (typeof sponsorTiers)[number]['type']
> = {
  hirosystems: 'sliver',
};

export const organizationSponsors = [
  {
    url: 'https://orama.com',
    label: 'Orama Search',
    tier: 'golden',
    github: 'oramasearch',
    logo: (
      <svg
        className="h-full py-1"
        viewBox="0 0 100 25"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M94.0139 17.9251C95.8443 17.9251 97.5498 17.1763 97.8202 16.0115C97.9034 16.7603 98.3194 17.3219 98.9226 17.6131C99.4634 17.8835 100.129 17.9251 100.774 17.6755V15.8035C100.503 15.8659 100.212 15.8867 99.9834 15.6995C99.7546 15.5123 99.5882 15.0963 99.5882 14.3267V10.6452C99.5882 8.37798 97.8826 6.9636 94.9083 6.9636C92.3291 6.9636 90.3739 8.02438 90.1243 9.62596L92.1211 10.2084C92.2875 9.39717 93.2651 8.83557 94.7835 8.83557C96.2394 8.83557 97.3834 9.31397 97.3834 10.1044C97.3834 10.8531 96.3434 11.2067 93.7643 11.3939C91.3099 11.5811 89.8123 12.7667 89.8123 14.6803C89.8123 16.5731 91.2891 17.9251 94.0139 17.9251ZM94.0139 16.0739C92.7867 16.0739 92.0379 15.5539 92.0379 14.7011C92.0379 13.8899 92.7451 13.3283 93.8891 13.2451C95.8235 13.1203 97.009 12.8915 97.4042 12.4339C97.4042 14.6387 95.9899 16.0739 94.0139 16.0739Z"
          fill="currentColor"
        />
        <path
          d="M83.517 7.03298C81.9038 7.03298 80.4461 7.79361 79.7269 8.96382C79.1633 7.7351 77.8805 7.05249 76.5005 7.03298C75.1205 7.03298 73.9543 7.7351 73.3324 8.8468V7.32553H71.2332V17.6547H73.3712V12.0063C73.3712 10.212 74.4597 9.04183 76.0146 9.04183C77.4917 9.04183 78.4247 10.134 78.4247 11.9478V17.6547H80.5627V11.9673C80.5627 10.1925 81.6317 9.04183 83.1866 9.04183C84.6443 9.04183 85.5773 10.056 85.5773 11.9088V17.6547H87.7153V11.5578C87.7153 10.173 87.3265 9.06134 86.5491 8.2617C85.7911 7.44255 84.7804 7.03298 83.517 7.03298Z"
          fill="currentColor"
        />
        <path
          d="M35.3396 17.9251C38.6676 17.9251 40.914 15.6787 40.914 12.3715C40.914 9.08517 38.7092 6.9844 35.3396 6.9844C31.9701 6.9844 29.7445 9.10597 29.7445 12.3715C29.7445 15.6787 32.0325 17.9251 35.3396 17.9251ZM35.3396 15.9283C33.3429 15.9283 31.9701 14.4515 31.9701 12.3715C31.9701 10.3124 33.3013 8.98117 35.3396 8.98117C37.3988 8.98117 38.6884 10.3124 38.6884 12.3715C38.6884 14.4723 37.3364 15.9283 35.3396 15.9283Z"
          fill="currentColor"
        />
        <path
          d="M50.7483 6.9636C49.022 6.9636 47.5452 7.67079 46.63 8.85637V7.1092H43.4684V8.91877H46.5884C45.9644 9.75076 45.6108 10.8115 45.6108 12.0387V15.8451H43.5308V17.6547H50.5611V15.8451H47.8572V11.9763C47.8572 10.3124 49.126 9.06437 50.7483 9.06437C52.0587 9.06437 52.9115 9.91716 53.1611 10.9779L55.1995 10.25C54.7627 8.27398 53.0987 6.9636 50.7483 6.9636Z"
          fill="currentColor"
        />
        <path
          d="M61.7982 17.9251C63.6286 17.9251 65.3341 17.1763 65.6045 16.0115C65.6877 16.7603 66.1037 17.3219 66.7069 17.6131C67.2477 17.8835 67.9133 17.9251 68.5581 17.6755V15.8035C68.2877 15.8659 67.9965 15.8867 67.7677 15.6995C67.5389 15.5123 67.3725 15.0963 67.3725 14.3267V10.6452C67.3725 8.37798 65.6669 6.9636 62.6926 6.9636C60.1134 6.9636 58.1582 8.02438 57.9086 9.62596L59.9054 10.2084C60.0718 9.39717 61.0494 8.83557 62.5678 8.83557C64.0238 8.83557 65.1677 9.31397 65.1677 10.1044C65.1677 10.8531 64.1278 11.2067 61.5486 11.3939C59.0942 11.5811 57.5966 12.7667 57.5966 14.6803C57.5966 16.5731 59.0734 17.9251 61.7982 17.9251ZM61.7982 16.0739C60.571 16.0739 59.8222 15.5539 59.8222 14.7011C59.8222 13.8899 60.5294 13.3283 61.6734 13.2451C63.6078 13.1203 64.7933 12.8915 65.1885 12.4339C65.1885 14.6387 63.7742 16.0739 61.7982 16.0739Z"
          fill="currentColor"
        />
        <g clipPath="url(#clip1_9_574)">
          <path
            d="M22.0583 4.6907C21.872 4.43943 21.676 4.1957 21.471 3.96004L21.4821 4.25988L21.6889 4.70448L22.0583 4.6907Z"
            fill="#FB81B8"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.9265 5.19456C14.714 5.1386 13.4595 5.54589 12.5523 6.35144C12.5475 6.35579 12.5427 6.36011 12.5379 6.36443C10.7026 8.00567 10.5449 10.8255 12.1864 12.6598C12.8816 13.4367 12.8155 14.6301 12.0386 15.3254C11.2618 16.0206 10.0684 15.9545 9.37314 15.1776C6.34464 11.7933 6.63168 6.59774 10.0045 3.56523C10.0104 3.55975 10.0165 3.55431 10.0225 3.5489C11.7264 2.02402 13.9761 1.32505 16.1005 1.42313C18.2275 1.52131 20.4065 2.43551 21.779 4.35896C22.3845 5.20761 22.1875 6.3865 21.3389 6.99208C20.613 7.51004 19.6456 7.44084 19.002 6.87895C18.6367 6.37014 18.1934 5.93535 17.7515 5.69836C17.2401 5.4041 16.6189 5.22653 15.9265 5.19456Z"
            fill="url(#paint0_linear_9_574)"
          />
          <mask
            id="mask0_9_574"
            style={{ maskType: 'alpha' }}
            maskUnits="userSpaceOnUse"
            x="7"
            y="1"
            width="16"
            height="15"
          >
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M15.9265 5.19454C14.714 5.13857 13.4595 5.54588 12.5523 6.35145C12.5475 6.3558 12.5427 6.36012 12.5379 6.36443C10.7026 8.00567 10.5449 10.8255 12.1864 12.6598C12.8816 13.4367 12.8155 14.6301 12.0386 15.3254C11.2618 16.0206 10.0684 15.9545 9.37315 15.1776C6.34461 11.7933 6.63166 6.59767 10.0046 3.56517C10.0105 3.55971 10.0165 3.55428 10.0225 3.54888C11.7264 2.024 13.9761 1.32503 16.1006 1.4231C18.2275 1.52129 20.4065 2.43548 21.779 4.35894C22.3846 5.20759 22.1875 6.38648 21.3389 6.99206C20.6131 7.51002 19.6456 7.44081 19.002 6.87894C18.6368 6.37012 18.1934 5.93532 17.7516 5.69834C17.2401 5.40407 16.619 5.22651 15.9265 5.19454Z"
              fill="url(#paint1_linear_9_574)"
            />
          </mask>
          <g mask="url(#mask0_9_574)">
            <g
              style={{
                mixBlendMode: 'multiply',
              }}
            >
              <path
                d="M10.1327 2.00051L3.71988 8.27149L15.4385 10.0932L20.1546 6.3904V3.90669L10.1327 2.00051Z"
                fill="url(#paint2_linear_9_574)"
              />
            </g>
          </g>
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.80116 3.36834C7.49608 4.1455 7.42943 5.33889 6.65229 6.03383C3.09986 9.21057 2.7955 14.6646 5.9723 18.2174C6.66722 18.9946 6.60058 20.188 5.82344 20.8829C5.0463 21.5779 3.85296 21.5112 3.15804 20.734C-1.40841 15.6271 -0.971164 7.78629 4.13576 3.21947C4.9129 2.52452 6.10624 2.59117 6.80116 3.36834Z"
            fill="url(#paint3_linear_9_574)"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.30692 18.0686C4.08406 17.3736 5.27739 17.4403 5.97231 18.2175C9.14892 21.77 14.6028 22.0744 18.1554 18.8975C18.9326 18.2025 20.1259 18.2692 20.8208 19.0463C21.5158 19.8235 21.4491 21.0169 20.672 21.7118C15.5653 26.2785 7.7247 25.8412 3.15805 20.7341C2.46313 19.9569 2.52978 18.7635 3.30692 18.0686Z"
            fill="url(#paint4_linear_9_574)"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M20.3283 5.37956C21.229 4.8546 22.3847 5.15925 22.9097 6.06C25.7727 10.9728 25.2032 17.6601 20.6738 21.7114C19.8968 22.4064 18.7034 22.3399 18.0084 21.5629C17.3134 20.7858 17.3799 19.5924 18.1569 18.8973C21.2036 16.1722 21.7107 11.5007 19.6479 7.96104C19.1229 7.06028 19.4276 5.90451 20.3283 5.37956Z"
            fill="url(#paint5_linear_9_574)"
          />
          <mask
            id="mask1_9_574"
            style={{
              maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x="17"
            y="5"
            width="8"
            height="18"
          >
            <path
              fillRule="evenodd"
              clipRule="evenodd"
              d="M20.3283 5.37954C21.229 4.85459 22.3847 5.15923 22.9097 6.05999C25.7727 10.9728 25.2032 17.66 20.6738 21.7114C19.8968 22.4064 18.7034 22.3399 18.0084 21.5628C17.3134 20.7858 17.3799 19.5924 18.1569 18.8973C21.2036 16.1721 21.7107 11.5007 19.6479 7.96102C19.1229 7.06027 19.4276 5.9045 20.3283 5.37954Z"
              fill="url(#paint6_linear_9_574)"
            />
          </mask>
          <g mask="url(#mask1_9_574)">
            <g
              style={{
                mixBlendMode: 'multiply',
              }}
            >
              <path
                d="M19.5769 13.1274L13.2628 19.7127L22.5182 22.3467L26.4866 12.7998L21.2577 1.4279L20.7908 10.9279L19.5769 13.1274Z"
                fill="url(#paint7_linear_9_574)"
              />
            </g>
          </g>
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M20.7079 3.18388L21.2598 3.79464L21.8132 4.40541C21.7996 4.38492 21.785 4.36373 21.7696 4.34193L21.8205 4.39655C21.7976 4.36629 21.7553 4.31349 21.6992 4.24566C21.4466 3.91051 21.0443 3.47422 20.7079 3.18388Z"
            fill="#F97CBF"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.52319 12.5116C10.3003 11.8167 11.4937 11.8833 12.1886 12.6605C13.8298 14.4958 16.6495 14.6535 18.4837 13.012C19.2606 12.3167 20.454 12.3829 21.1492 13.1598C21.8444 13.9367 21.7782 15.1301 21.0014 15.8253C17.6117 18.859 12.4046 18.5659 9.37435 15.1771C8.67942 14.3999 8.74606 13.2066 9.52319 12.5116Z"
            fill="url(#paint8_linear_9_574)"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M21.6492 4.19655C20.954 3.41966 19.7606 3.35348 18.9838 4.04874C18.311 4.65082 18.1712 5.62646 18.5973 6.3817C18.8314 6.63452 19.0489 6.92543 19.2352 7.23141C20.4355 9.04617 20.1547 11.516 18.4844 13.0097C17.7073 13.7046 17.6407 14.898 18.3356 15.6752C19.0305 16.4523 20.2239 16.519 21.001 15.824C24.3896 12.7937 24.6827 7.58639 21.6492 4.19655Z"
            fill="url(#paint9_linear_9_574)"
          />
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M18.4397 6.21973C15.7768 3.10541 10.1878 2.87421 6.65239 6.0357C5.87526 6.73065 4.68191 6.664 3.987 5.88683C3.29208 5.10966 3.35873 3.91628 4.13586 3.22133C9.12999 -1.24461 17.6643 -1.24472 21.7643 4.34028C22.3812 5.18069 22.2001 6.36212 21.3597 6.9791C20.6349 7.51121 19.6565 7.44967 19.0053 6.88352C18.8316 6.64113 18.6403 6.41543 18.4397 6.21973Z"
            fill="url(#paint10_linear_9_574)"
          />
        </g>
        <defs>
          <linearGradient
            id="paint0_linear_9_574"
            x1="10.2489"
            y1="12.4938"
            x2="11.5214"
            y2="4.31398"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#F6D25B" />
            <stop offset="1" stopColor="#F8B580" />
          </linearGradient>
          <linearGradient
            id="paint1_linear_9_574"
            x1="10.2489"
            y1="12.4938"
            x2="11.5214"
            y2="4.31396"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#F6D25B" />
            <stop offset="1" stopColor="#F8B580" />
          </linearGradient>
          <linearGradient
            id="paint2_linear_9_574"
            x1="15.9516"
            y1="0.457961"
            x2="8.62303"
            y2="8.91785"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#895200" />
            <stop offset="0.833333" stopColor="#E28800" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint3_linear_9_574"
            x1="3.64085"
            y1="4.62665"
            x2="4.54803"
            y2="17.9021"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#ED51F2" />
            <stop offset="1" stopColor="#B771F2" />
          </linearGradient>
          <linearGradient
            id="paint4_linear_9_574"
            x1="3.61446"
            y1="18.6741"
            x2="17.6907"
            y2="19.5218"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#B971F3" />
            <stop offset="1" stopColor="#8F6FDE" />
          </linearGradient>
          <linearGradient
            id="paint5_linear_9_574"
            x1="21.1549"
            y1="8.11746"
            x2="18.9747"
            y2="21.0193"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#6A4BB2" />
            <stop offset="1" stopColor="#9170E0" />
          </linearGradient>
          <linearGradient
            id="paint6_linear_9_574"
            x1="21.1549"
            y1="6.94958"
            x2="18.61"
            y2="20.8552"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#6A4BB2" />
            <stop offset="1" stopColor="#9170E0" />
          </linearGradient>
          <linearGradient
            id="paint7_linear_9_574"
            x1="18.0363"
            y1="12.2851"
            x2="21.3171"
            y2="19.2051"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#542DA7" />
            <stop offset="0.833333" stopColor="#5F2EAF" stopOpacity="0" />
          </linearGradient>
          <linearGradient
            id="paint8_linear_9_574"
            x1="11.2487"
            y1="12.5846"
            x2="17.7014"
            y2="14.4022"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#F6D25B" />
            <stop offset="1" stopColor="#F9A38F" />
          </linearGradient>
          <linearGradient
            id="paint9_linear_9_574"
            x1="20.5294"
            y1="7.54504"
            x2="20.8007"
            y2="14.4168"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#FA80B7" />
            <stop offset="1" stopColor="#F8A48D" />
          </linearGradient>
          <linearGradient
            id="paint10_linear_9_574"
            x1="5.88654"
            y1="4.1322"
            x2="19.7917"
            y2="4.85924"
            gradientUnits="userSpaceOnUse"
          >
            <stop stopColor="#E755F3" />
            <stop offset="1" stopColor="#F97FB6" />
          </linearGradient>
          <clipPath id="clip0_9_574">
            <rect width="100.798" height="24.87" fill="white" />
          </clipPath>
          <clipPath id="clip1_9_574">
            <rect width="24.6701" height="24.87" fill="white" />
          </clipPath>
        </defs>
      </svg>
    ),
  },
  {
    url: 'https://mintlify.com',
    label: 'Mintlify',
    tier: 'golden',
    github: 'mintlify',
    logo: (
      <svg
        viewBox="0 0 103 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        className="h-full max-w-[160px]"
      >
        <path
          d="M33.8891 18H30.7691V4H34.5891L38.4091 14.26L42.2091 4H46.0291V18H42.9091V9.36L39.6891 18H37.1091L33.8891 9.36V18ZM49.5854 6.34C49.0787 6.34 48.6454 6.16667 48.2854 5.82C47.9387 5.46 47.7654 5.02 47.7654 4.5C47.7654 3.99333 47.9387 3.56667 48.2854 3.22C48.6454 2.87333 49.0787 2.7 49.5854 2.7C50.1054 2.7 50.5387 2.87333 50.8854 3.22C51.2321 3.56667 51.4054 3.99333 51.4054 4.5C51.4054 5.02 51.2321 5.46 50.8854 5.82C50.5387 6.16667 50.1054 6.34 49.5854 6.34ZM51.1254 18H48.0454V7.4H51.1254V18ZM52.9626 18V7.4H55.4426L55.7026 8.9C55.9959 8.34 56.4492 7.88667 57.0626 7.54C57.6892 7.19333 58.3892 7.02 59.1626 7.02C60.2826 7.02 61.1759 7.38 61.8426 8.1C62.5226 8.82 62.8626 9.78667 62.8626 11V18H59.7826V11.16C59.7826 10.7067 59.6359 10.3467 59.3426 10.08C59.0492 9.81333 58.6492 9.68 58.1426 9.68C57.5426 9.68 57.0426 9.86 56.6426 10.22C56.2426 10.58 56.0426 11.0467 56.0426 11.62V18H52.9626ZM69.2688 18C68.0022 18 67.0288 17.7067 66.3488 17.12C65.6822 16.5333 65.3488 15.68 65.3488 14.56V10H63.6088V7.4H65.3488V3.78H68.4288V7.4H71.0288V10H68.4288V14.22C68.4288 14.6067 68.5288 14.9 68.7288 15.1C68.9288 15.3 69.2155 15.4 69.5888 15.4H70.8088V18H69.2688ZM75.3891 18H72.3091V3H75.3891V18ZM78.7854 6.34C78.2787 6.34 77.8454 6.16667 77.4854 5.82C77.1387 5.46 76.9654 5.02 76.9654 4.5C76.9654 3.99333 77.1387 3.56667 77.4854 3.22C77.8454 2.87333 78.2787 2.7 78.7854 2.7C79.3054 2.7 79.7387 2.87333 80.0854 3.22C80.4321 3.56667 80.6054 3.99333 80.6054 4.5C80.6054 5.02 80.4321 5.46 80.0854 5.82C79.7387 6.16667 79.3054 6.34 78.7854 6.34ZM80.3254 18H77.2454V7.4H80.3254V18ZM83.3426 18V10H81.6026V7.4H83.3426V6.24C83.3426 5.18667 83.6626 4.38667 84.3026 3.84C84.9426 3.28 85.8692 3 87.0826 3H89.3426V5.6H87.4026C86.7492 5.6 86.4226 5.92667 86.4226 6.58V7.4H89.1426V10H86.4226V18H83.3426ZM90.4591 22V19.4H92.5991C93.3191 19.4 93.7725 19.1467 93.9591 18.64L94.1991 18H93.7391L89.5391 7.4H92.8391L95.4791 14.54L98.1191 7.4H101.319L96.8391 19.42C96.5191 20.2867 96.0191 20.9333 95.3391 21.36C94.6591 21.7867 93.7458 22 92.5991 22H90.4591Z"
          fill="currentColor"
        />
        <g clipPath="url(#clip0_115_7772)">
          <path
            d="M5.53338 7.66241C5.54806 5.66259 6.34114 3.74714 7.74443 2.32227H7.74185L2.32412 7.73999H2.32671C2.30654 7.75586 2.28753 7.77314 2.26981 7.79171C0.95223 9.10757 0.153396 10.8545 0.0199146 12.7118C-0.113567 14.5691 0.42726 16.4123 1.54314 17.9031L7.01517 12.431L7.07206 12.3767C6.05218 11.0186 5.51109 9.36073 5.53338 7.66241Z"
            fill="#0C8C5E"
          />
          <path
            d="M18.6882 13.2688C17.6513 14.285 16.3497 14.9894 14.9318 15.3017C13.514 15.614 12.0369 15.5216 10.669 15.0351C9.93963 14.7761 9.25417 14.4073 8.63634 13.9412L8.57945 13.9981L3.10742 19.4675C4.59878 20.5806 6.44095 21.1197 8.29711 20.9863C10.1533 20.8529 11.8994 20.0558 13.2162 18.7408L13.2705 18.6865L18.6882 13.2688Z"
            fill="#0C8C5E"
          />
          <path
            d="M21.0104 7.73998V3.87298e-06H13.2704C12.2539 -0.00101453 11.2472 0.198818 10.3081 0.588023C9.36903 0.977229 8.51612 1.54814 7.79835 2.26795L7.74404 2.32226C6.79795 3.28273 6.12105 4.47511 5.78125 5.77977C6.39637 5.62048 7.02851 5.53626 7.66388 5.52893C9.36226 5.50894 11.0196 6.05079 12.3782 7.0702C13.5992 7.98076 14.5233 9.23241 15.0341 10.6674C15.5546 12.134 15.623 13.7231 15.2306 15.2291C16.5355 14.8899 17.728 14.2129 18.6881 13.2663L18.7424 13.2146C19.4625 12.4965 20.0336 11.6432 20.4228 10.7037C20.812 9.76414 21.0117 8.75694 21.0104 7.73998Z"
            fill="#18E299"
          />
        </g>
        <defs>
          <clipPath id="clip0_115_7772">
            <rect width="21" height="21" fill="white" />
          </clipPath>
        </defs>
      </svg>
    ),
  },
  {
    url: 'https://inkeep.com',
    tier: 'golden',
    label: 'Inkeep',
    github: 'inkeep',
    logo: (
      <svg
        viewBox="0 0 99 24"
        className="h-full py-2"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <path
          d="M27.9032 1.75683V20.0633C27.9032 21.0827 27.0272 21.8898 26.0123 21.8048L14.7742 20.9341C13.4495 20.8279 12.1248 21.1252 10.9711 21.7729L7.0933 23.9498C6.75146 24.1409 6.37756 23.748 6.59122 23.4188L8.53547 20.4562L10.3408 17.6954C10.5331 17.3981 10.907 17.26 11.2489 17.3662C14.0798 18.2794 17.2846 17.2282 18.9831 14.6372C21.0128 11.526 20.1262 7.36347 17.0068 5.34593C13.8768 3.31777 9.68919 4.20973 7.65948 7.31037C5.96094 9.91194 6.30278 13.2462 8.27908 15.4442C8.5141 15.7097 8.54615 16.1026 8.34318 16.3999L6.05708 19.9041C5.91821 20.1058 5.68319 20.2226 5.43749 20.212L1.24987 19.8935C0.534134 19.8404 0 19.267 0 18.5661V3.24344C0 2.55323 0.534134 1.9692 1.23919 1.91611L26.0123 0.00475303C27.0272 -0.0695774 27.9032 0.737439 27.9032 1.75683ZM13.2999 6.38655C10.7468 6.38655 8.67434 8.44657 8.67434 10.9844C8.67434 12.2162 9.16574 13.3418 9.96695 14.17C10.4583 14.6691 11.0566 15.062 11.7296 15.3062C12.221 15.4867 12.7444 15.5823 13.2999 15.5823C15.8531 15.5823 17.9255 13.5223 17.9255 10.9844C17.9255 8.43595 15.8531 6.38655 13.2999 6.38655Z"
          fill="currentColor"
        />
        <path
          d="M37.6778 2.17096C37.6778 2.77622 37.4855 3.25406 37.0903 3.59386C36.695 3.94427 36.2357 4.11417 35.7015 4.11417C35.1674 4.11417 34.708 3.94427 34.3128 3.59386C33.9175 3.24344 33.7252 2.77622 33.7252 2.17096C33.7252 1.5657 33.9175 1.08786 34.3128 0.748066C34.708 0.397651 35.1674 0.227753 35.7015 0.227753C36.2357 0.227753 36.695 0.397651 37.0903 0.748066C37.4855 1.08786 37.6778 1.5657 37.6778 2.17096ZM37.368 17.1432H34.0564V5.52645H37.368V17.1432Z"
          fill="currentColor"
        />
        <path
          d="M39.5472 5.91933C40.1134 5.76005 40.8398 5.61139 41.7265 5.46273C42.6131 5.32469 43.5532 5.25036 44.5253 5.25036C45.5188 5.25036 46.3414 5.37778 47.0037 5.63263C47.6661 5.88748 48.1895 6.25913 48.5741 6.72635C48.9587 7.19357 49.2364 7.75635 49.3966 8.40409C49.5569 9.05183 49.6424 9.77389 49.6424 10.5703V17.1326H46.3307V10.9738C46.3307 9.91194 46.1918 9.15801 45.9034 8.72265C45.6257 8.27667 45.0915 8.0643 44.3224 8.0643C44.0874 8.0643 43.831 8.07491 43.5639 8.09615C43.2968 8.11739 43.0618 8.14924 42.8482 8.17048V17.1432H39.5365V5.91933H39.5472Z"
          fill="currentColor"
        />
        <path
          d="M55.0051 9.69954C55.3256 9.34913 55.6674 8.97748 56.02 8.60582C56.3725 8.22355 56.7037 7.8519 57.0348 7.46963C57.3553 7.09798 57.6651 6.73694 57.9535 6.40777C58.242 6.06797 58.4877 5.78127 58.7013 5.52642H62.6432C61.8527 6.41839 61.0942 7.2785 60.3465 8.09613C59.5987 8.91376 58.7761 9.75264 57.8894 10.6234C58.3381 11.0269 58.7975 11.4941 59.2675 12.0463C59.7375 12.5984 60.1969 13.1718 60.6456 13.7665C61.0942 14.3611 61.5002 14.9452 61.8634 15.5398C62.2373 16.1344 62.5471 16.6654 62.7928 17.1538H58.9898C58.7547 16.7716 58.4877 16.3468 58.1779 15.8796C57.8788 15.4124 57.5583 14.9451 57.2164 14.4885C56.8746 14.0213 56.5221 13.5753 56.1375 13.1506C55.7636 12.7259 55.3897 12.3648 55.0158 12.0675V17.1644H51.7042V0.535662L55.0158 0.00473022V9.69954H55.0051Z"
          fill="currentColor"
        />
        <path
          d="M62.5364 11.4198C62.5364 10.3898 62.6966 9.48726 63.0171 8.7121C63.3376 7.93694 63.7542 7.29982 64.2777 6.77951C64.8011 6.25919 65.3887 5.87692 66.0617 5.61146C66.7347 5.34599 67.4291 5.21857 68.1341 5.21857C69.7899 5.21857 71.1039 5.72826 72.0654 6.72641C73.0268 7.73518 73.5075 9.22179 73.5075 11.1756C73.5075 11.3668 73.4968 11.5791 73.4862 11.8021C73.4755 12.0357 73.4541 12.2375 73.4434 12.4074H65.9335C66.0083 13.087 66.3288 13.6179 66.8843 14.0214C67.4504 14.4143 68.1982 14.6161 69.149 14.6161C69.7579 14.6161 70.3561 14.563 70.933 14.4462C71.5205 14.34 71.9906 14.2019 72.3645 14.0427L72.8131 16.7185C72.6315 16.8035 72.3965 16.8991 72.0974 16.984C71.7983 17.069 71.4671 17.1539 71.1039 17.2176C70.7407 17.2813 70.3561 17.3344 69.9395 17.3875C69.5229 17.43 69.1063 17.4512 68.7003 17.4512C67.6534 17.4512 66.7347 17.292 65.9549 16.984C65.175 16.6761 64.5341 16.2513 64.0213 15.7098C63.5085 15.1682 63.1346 14.5311 62.8889 13.7984C62.6646 13.0764 62.5364 12.28 62.5364 11.4198ZM70.3134 10.1668C70.3027 9.89077 70.2493 9.61468 70.1638 9.34922C70.0784 9.08375 69.9609 8.85014 69.7899 8.63777C69.619 8.43601 69.4054 8.26611 69.149 8.12807C68.8926 8.00065 68.5721 7.92632 68.1875 7.92632C67.8136 7.92632 67.5039 7.99003 67.2368 8.11745C66.9697 8.24488 66.7454 8.40416 66.5745 8.61653C66.3929 8.81828 66.2647 9.06251 66.1685 9.3386C66.0724 9.61468 65.9976 9.89077 65.9549 10.1668H70.3134Z"
          fill="currentColor"
        />
        <path
          d="M74.7147 11.4198C74.7147 10.3898 74.8749 9.48726 75.1954 8.7121C75.5159 7.93694 75.9325 7.29982 76.4559 6.77951C76.9794 6.25919 77.5669 5.87692 78.2399 5.61146C78.913 5.34599 79.6073 5.21857 80.3124 5.21857C81.9682 5.21857 83.2822 5.72826 84.2436 6.72641C85.2051 7.73518 85.6858 9.22179 85.6858 11.1756C85.6858 11.3668 85.6751 11.5791 85.6644 11.8021C85.6537 12.0357 85.6324 12.2375 85.6217 12.4074H78.1118C78.1865 13.087 78.507 13.6179 79.0625 14.0214C79.6287 14.4143 80.3765 14.6161 81.3272 14.6161C81.9362 14.6161 82.5344 14.563 83.1112 14.4462C83.6988 14.34 84.1688 14.2019 84.5427 14.0427L84.9914 16.7185C84.8098 16.8035 84.5748 16.8991 84.2757 16.984C83.9765 17.069 83.6454 17.1539 83.2822 17.2176C82.919 17.2813 82.5344 17.3344 82.1178 17.3875C81.7011 17.43 81.2845 17.4512 80.8786 17.4512C79.8317 17.4512 78.913 17.292 78.1331 16.984C77.3533 16.6761 76.7123 16.2513 76.1995 15.7098C75.6868 15.1682 75.3129 14.5311 75.0672 13.7984C74.8429 13.0764 74.7147 12.28 74.7147 11.4198ZM82.4917 10.1668C82.481 9.89077 82.4276 9.61468 82.3421 9.34922C82.2566 9.08375 82.1391 8.85014 81.9682 8.63777C81.7973 8.43601 81.5836 8.26611 81.3272 8.12807C81.0709 8.00065 80.7504 7.92632 80.3658 7.92632C79.9919 7.92632 79.6821 7.99003 79.415 8.11745C79.148 8.24488 78.9236 8.40416 78.7527 8.61653C78.5711 8.81828 78.4429 9.06251 78.3468 9.3386C78.2506 9.61468 78.1759 9.89077 78.1331 10.1668H82.4917Z"
          fill="currentColor"
        />
        <path
          d="M98.1845 11.3348C98.1845 12.2374 98.0776 13.0551 97.8533 13.7877C97.629 14.5204 97.3085 15.1575 96.8705 15.6885C96.4432 16.2194 95.909 16.6335 95.2681 16.9202C94.6271 17.2176 93.9007 17.3662 93.0674 17.3662C92.6081 17.3662 92.1808 17.3238 91.7748 17.2388C91.3796 17.1539 90.9843 17.0264 90.6211 16.8671V21.242L87.3095 21.8048V5.91933C87.6086 5.83438 87.9504 5.74943 88.335 5.66449C88.7196 5.57954 89.1255 5.51582 89.5422 5.45211C89.9695 5.3884 90.3968 5.34593 90.8348 5.30345C91.2728 5.2716 91.6894 5.25036 92.0953 5.25036C93.0568 5.25036 93.9221 5.39902 94.6699 5.68572C95.4283 5.97243 96.0586 6.37593 96.582 6.89625C97.1055 7.41656 97.5008 8.05368 97.7678 8.8076C98.0456 9.57214 98.1845 10.411 98.1845 11.3348ZM94.8087 11.4198C94.8087 10.4004 94.5737 9.59338 94.125 8.9775C93.6657 8.36162 92.982 8.0643 92.0846 8.0643C91.7855 8.0643 91.5185 8.07492 91.2621 8.09615C91.0057 8.11739 90.8027 8.14925 90.6425 8.17048V14.1169C90.8454 14.2443 91.1232 14.3611 91.4544 14.4461C91.7855 14.531 92.1274 14.5735 92.4692 14.5735C94.0182 14.5841 94.8087 13.5329 94.8087 11.4198Z"
          fill="currentColor"
        />
      </svg>
    ),
  },
  {
    url: 'https://vercel.com',
    logo: (
      <svg
        aria-label="Vercel logotype"
        role="img"
        viewBox="0 0 283 64"
        className="h-full py-2"
      >
        <path
          d="M141.68 16.25c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.46 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zm117.14-14.5c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.45 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zm-39.03 3.5c0 6 3.92 10 10 10 4.12 0 7.21-1.87 8.8-4.92l7.68 4.43c-3.18 5.3-9.14 8.49-16.48 8.49-11.05 0-19-7.2-19-18s7.96-18 19-18c7.34 0 13.29 3.19 16.48 8.49l-7.68 4.43c-1.59-3.05-4.68-4.92-8.8-4.92-6.07 0-10 4-10 10zm82.48-29v46h-9v-46h9zM37.59.25l36.95 64H.64l36.95-64zm92.38 5l-27.71 48-27.71-48h10.39l17.32 30 17.32-30h10.39zm58.91 12v9.69c-1-.29-2.06-.49-3.2-.49-5.81 0-10 4-10 10v14.8h-9v-34h9v9.2c0-5.08 5.91-9.2 13.2-9.2z"
          fill="currentColor"
        ></path>
      </svg>
    ),
    github: 'vercel',
    tier: 'golden',
    label: 'Vercel',
  },
  {
    url: 'https://unkey.com',
    github: 'unkeyed',
    label: 'Unkey',
    logo: (
      <svg
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 93 40"
        className="h-full"
      >
        <path
          d="M10.8 30.3C4.8 30.3 1.38 27.12 1.38 21.66V9.9H4.59V21.45C4.59 25.5 6.39 27.18 10.8 27.18C15.21 27.18 17.01 25.5 17.01 21.45V9.9H20.25V21.66C20.25 27.12 16.83 30.3 10.8 30.3ZM26.3611 30H23.1211V15.09H26.0911V19.71H26.3011C26.7511 17.19 28.7311 14.79 32.5111 14.79C36.6511 14.79 38.6911 17.58 38.6911 21.03V30H35.4511V21.9C35.4511 19.11 34.1911 17.7 31.1011 17.7C27.8311 17.7 26.3611 19.38 26.3611 22.62V30ZM44.8181 30H41.5781V9.9H44.8181V21H49.0781L53.5481 15.09H57.3281L51.7181 22.26L57.2981 30H53.4881L49.0781 23.91H44.8181V30ZM66.4219 30.3C61.5319 30.3 58.3219 27.54 58.3219 22.56C58.3219 17.91 61.5019 14.79 66.3619 14.79C70.9819 14.79 74.1319 17.34 74.1319 21.87C74.1319 22.41 74.1019 22.83 74.0119 23.28H61.3519C61.4719 26.16 62.8819 27.69 66.3319 27.69C69.4519 27.69 70.7419 26.67 70.7419 24.9V24.66H73.9819V24.93C73.9819 28.11 70.8619 30.3 66.4219 30.3ZM66.3019 17.34C63.0019 17.34 61.5619 18.81 61.3819 21.48H71.0719V21.42C71.0719 18.66 69.4819 17.34 66.3019 17.34ZM78.9586 35.1H76.8286V32.16H79.7386C81.0586 32.16 81.5986 31.8 82.0486 30.78L82.4086 30L75.0586 15.09H78.6886L82.4986 23.01L83.9686 26.58H84.2086L85.6186 22.98L89.1286 15.09H92.6986L84.9286 31.62C83.6986 34.29 82.0186 35.1 78.9586 35.1Z"
          fill="currentColor"
        />
      </svg>
    ),
    tier: 'golden',
  },
  {
    url: 'https://github.com/scalar/scalar',
    label: 'Scalar',
    github: 'scalar',
    logo: (
      <>
        <svg
          xmlns="http://www.w3.org/2000/svg"
          viewBox="0 0 593 593"
          className="h-full"
        >
          <path
            fill="currentColor"
            fillRule="evenodd"
            d="M347 0c6 0 12 5 12 12v134l94-95c5-5 13-5 17 0l72 72c4 4 5 12 0 16v1l-95 94h134c7 0 12 5 12 12v101c0 7-5 12-12 12H447l95 94c4 5 5 13 0 17l-72 72c-4 4-12 5-16 0h-1l-94-95v134c0 7-5 12-12 12H246c-7 0-12-5-12-12v-70c0-22 9-43 24-59l130-130c14-14 14-37 0-51L259 142a84 84 0 0 1-25-59V12c0-7 5-12 12-12zM138 52h1l219 219c14 14 14 37 0 51L139 542c-4 5-12 5-17 0l-71-70c-4-5-5-12 0-17l95-96H12c-7 0-12-5-12-12V246c0-7 5-12 12-12h134l-95-94c-4-5-4-12 0-17l71-71c4-5 12-5 16 0"
          />
        </svg>
        Scalar
      </>
    ),
  },
  {
    url: 'https://supastarter.dev',
    github: 'supastarter',
    logo: (
      <svg
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 419 184"
        fill="none"
        className="h-full"
      >
        <path
          d="M74.878 129.813L53.8042 177.336M79.929 164.698L74.546 176.813M43.5838 148.549L38.2008 160.664M50.7614 132.396L36.6272 126.115M36.6272 126.115C36.6272 126.115 6.22941 131.951 6.00437 127.016C5.77932 122.08 14.3028 102.898 19.4621 96.728C24.6215 90.558 55.4681 83.7126 55.4681 83.7126M36.6272 126.115L55.4681 83.7126M55.4681 83.7126C55.4681 83.7126 77.1698 46.2078 92.4795 27.6233C107.789 9.03868 121.759 3.84198 128.322 6.75779C134.884 9.6736 140.433 23.5432 136.901 47.3613C133.37 71.1795 120.082 112.423 120.082 112.423M87.1066 148.545L101.241 154.825M101.241 154.825C101.241 154.825 117.284 181.296 121.097 178.155C124.911 175.014 133.434 155.832 134.555 147.867C135.676 139.903 120.082 112.423 120.082 112.423M101.241 154.825L120.082 112.423M108.357 83.0346C105.632 89.168 98.4503 91.9308 92.3169 89.2056C86.1835 86.4803 83.4207 79.299 86.146 73.1656C88.8712 67.0322 96.0526 64.2694 102.186 66.9946C108.319 69.7199 111.082 76.9012 108.357 83.0346Z"
          stroke="currentColor"
          strokeWidth="11"
          strokeLinecap="round"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M178.574 75.5777C181.605 77.7046 185.529 78.7681 190.345 78.7681C195.357 78.7681 199.281 77.6557 202.117 75.431C204.977 73.2063 206.407 70.1382 206.407 66.2266C206.407 64.1975 205.979 62.474 205.124 61.0561C204.292 59.6137 202.899 58.3791 200.943 57.3523C198.987 56.3011 196.347 55.3476 193.022 54.492C189.917 53.7097 187.571 53.0374 185.981 52.4751C184.392 51.9128 183.317 51.3261 182.754 50.7149C182.217 50.1037 181.948 49.3581 181.948 48.478C181.948 46.9622 182.669 45.7765 184.111 44.9209C185.554 44.0408 187.436 43.6496 189.759 43.7474C192.179 43.8452 194.147 44.4442 195.663 45.5443C197.178 46.6444 198.071 48.1479 198.34 50.0548L206.187 48.6246C205.894 46.2777 205.014 44.2364 203.547 42.5006C202.08 40.7404 200.161 39.3836 197.789 38.4302C195.418 37.4767 192.717 37 189.685 37C186.58 37 183.867 37.4889 181.544 38.4668C179.246 39.4447 177.462 40.826 176.19 42.6106C174.919 44.3953 174.283 46.4855 174.283 48.8813C174.283 50.8127 174.699 52.4629 175.53 53.8319C176.386 55.1765 177.804 56.3622 179.784 57.389C181.789 58.3913 184.49 59.3325 187.888 60.2126C190.993 61.0438 193.303 61.7406 194.819 62.3029C196.335 62.8652 197.325 63.4641 197.789 64.0997C198.278 64.7109 198.523 65.5177 198.523 66.52C198.523 68.2313 197.838 69.5759 196.469 70.5538C195.125 71.5317 193.255 72.0206 190.859 72.0206C188.218 72.0206 186.006 71.4339 184.221 70.2604C182.461 69.0625 181.337 67.4368 180.848 65.3832L173 66.5934C173.685 70.456 175.543 73.4508 178.574 75.5777ZM220.352 77.4479C222.21 78.328 224.508 78.7681 227.246 78.7681C230.815 78.7681 233.859 77.998 236.377 76.4578C237.916 75.5162 239.237 74.3507 240.337 72.9614V77.7046H247.158V38.1001H239.421V58.7091C239.421 61.0561 239.152 63.0485 238.614 64.6865C238.1 66.3244 237.379 67.6446 236.45 68.6469C235.546 69.6493 234.482 70.3827 233.26 70.8472C232.038 71.2872 230.742 71.5072 229.373 71.5072C227.27 71.5072 225.559 71.0794 224.239 70.2238C222.943 69.3681 221.929 68.2435 221.195 66.85C220.486 65.4566 219.997 63.9531 219.728 62.3395C219.484 60.7016 219.362 59.1125 219.362 57.5723V38.1001H211.587V60.1026C211.587 61.325 211.697 62.7429 211.917 64.3564C212.138 65.9699 212.553 67.6201 213.164 69.307C213.775 70.9939 214.656 72.5585 215.805 74.0009C216.978 75.4188 218.494 76.5678 220.352 77.4479ZM273.835 78.8047C270.046 78.8047 266.868 77.888 264.301 76.0544C263.814 75.702 263.349 75.3262 262.907 74.9272V95.3066H255.206V38.1001H262.027V41.6389C262.701 40.944 263.434 40.3145 264.227 39.7503C266.794 37.9168 269.948 37 273.688 37C277.404 37 280.607 37.9168 283.296 39.7503C286.01 41.5594 288.1 44.0408 289.567 47.1945C291.034 50.3237 291.767 53.8808 291.767 57.8657C291.767 61.8261 291.034 65.3954 289.567 68.5736C288.124 71.7273 286.059 74.2209 283.369 76.0544C280.705 77.888 277.527 78.8047 273.835 78.8047ZM263.127 50.6049C262.394 52.7073 262.027 55.1276 262.027 57.8657C262.027 60.6038 262.394 63.0241 263.127 65.1265C263.861 67.229 265.022 68.8792 266.611 70.0771C268.2 71.275 270.254 71.874 272.772 71.874C275.216 71.874 277.233 71.2505 278.822 70.0037C280.436 68.7569 281.634 67.0823 282.416 64.9798C283.223 62.8529 283.626 60.4815 283.626 57.8657C283.626 55.2743 283.223 52.9274 282.416 50.8249C281.634 48.7224 280.424 47.0478 278.786 45.801C277.148 44.5542 275.057 43.9308 272.515 43.9308C270.119 43.9308 268.139 44.5175 266.574 45.691C265.034 46.8644 263.885 48.5024 263.127 50.6049ZM301.477 77.1912C303.458 78.2669 305.915 78.8047 308.848 78.8047C312.54 78.8047 315.645 78.0713 318.163 76.6045C320.066 75.4879 321.717 73.9395 323.113 71.9593V77.7046H329.897V53.3185C329.897 51.6561 329.824 50.1037 329.677 48.6613C329.531 47.2189 329.139 45.8499 328.504 44.5542C327.281 41.9383 325.35 40.0315 322.71 38.8335C320.094 37.6112 317.014 37 313.469 37C308.897 37 305.23 38.0023 302.467 40.007C299.729 42.0117 297.871 44.7131 296.894 48.1113L304.044 50.3115C304.729 48.0868 305.939 46.4977 307.675 45.5443C309.411 44.5664 311.317 44.0775 313.395 44.0775C316.696 44.0775 319.018 44.8353 320.363 46.3511C321.558 47.6527 322.213 49.5689 322.327 52.0998C320.826 52.3105 319.316 52.5211 317.796 52.7318C315.351 53.074 313.016 53.4408 310.792 53.8319C308.567 54.2231 306.575 54.6753 304.814 55.1887C302.785 55.8488 301.074 56.7167 299.681 57.7924C298.287 58.8436 297.236 60.1271 296.527 61.6428C295.818 63.1585 295.463 64.9187 295.463 66.9234C295.463 69.0747 295.965 71.055 296.967 72.8641C297.994 74.6487 299.497 76.0911 301.477 77.1912ZM315.816 71.3972C314.251 72.1551 312.381 72.534 310.205 72.534C308.567 72.534 307.222 72.2773 306.171 71.7639C305.12 71.2505 304.338 70.566 303.824 69.7104C303.311 68.8303 303.054 67.8768 303.054 66.85C303.054 65.7988 303.286 64.9065 303.751 64.1731C304.24 63.4397 304.888 62.8163 305.695 62.3029C306.526 61.7895 307.467 61.3494 308.518 60.9827C309.765 60.5916 311.183 60.2615 312.772 59.9926C314.386 59.6992 316.182 59.4059 318.163 59.1125C319.434 58.9241 320.796 58.7206 322.249 58.502C322.231 59.1479 322.202 59.8892 322.16 60.726C322.111 62.1929 321.879 63.513 321.463 64.6865C321.17 65.9822 320.546 67.229 319.593 68.4269C318.639 69.6248 317.38 70.6149 315.816 71.3972ZM240.956 145.162C238.138 145.688 235.374 145.912 232.662 145.833C229.977 145.78 227.568 145.293 225.435 144.372C223.303 143.424 221.684 141.936 220.578 139.909C219.604 138.066 219.09 136.184 219.038 134.262C218.985 132.34 218.959 130.168 218.959 127.746V109.975H211.218V102.511H218.959V90.6631H228.437V102.511H240.956V109.975H228.437V127.193C228.437 128.904 228.45 130.405 228.476 131.695C228.529 132.985 228.805 134.038 229.305 134.854C230.253 136.434 231.767 137.316 233.847 137.5C235.927 137.684 238.296 137.579 240.956 137.184V145.162ZM192.064 146.346C186.798 146.346 182.52 145.162 179.229 142.792C175.938 140.423 173.937 137.092 173.226 132.801L182.941 131.3C183.441 133.406 184.547 135.065 186.258 136.276C187.97 137.487 190.129 138.093 192.735 138.093C195.025 138.093 196.789 137.645 198.027 136.75C199.291 135.828 199.922 134.578 199.922 132.998C199.922 132.024 199.685 131.247 199.212 130.668C198.764 130.063 197.764 129.483 196.21 128.931C194.657 128.378 192.274 127.68 189.062 126.837C185.482 125.89 182.638 124.876 180.532 123.797C178.426 122.691 176.912 121.388 175.99 119.887C175.069 118.386 174.608 116.57 174.608 114.437C174.608 111.778 175.306 109.461 176.701 107.487C178.097 105.512 180.045 103.998 182.546 102.945C185.047 101.866 187.996 101.326 191.392 101.326C194.71 101.326 197.645 101.839 200.199 102.866C202.779 103.893 204.859 105.354 206.439 107.25C208.018 109.145 208.992 111.37 209.361 113.924L199.646 115.661C199.409 113.845 198.58 112.41 197.158 111.357C195.763 110.304 193.893 109.711 191.55 109.58C189.312 109.448 187.509 109.79 186.14 110.606C184.771 111.396 184.086 112.515 184.086 113.963C184.086 114.779 184.363 115.477 184.916 116.056C185.468 116.635 186.574 117.215 188.233 117.794C189.918 118.373 192.419 119.084 195.736 119.926C199.133 120.795 201.844 121.796 203.872 122.928C205.925 124.034 207.4 125.363 208.295 126.916C209.216 128.47 209.677 130.352 209.677 132.564C209.677 136.855 208.11 140.225 204.977 142.674C201.871 145.122 197.566 146.346 192.064 146.346ZM251.864 144.609C253.997 145.767 256.603 146.346 259.684 146.346C263.528 146.346 266.726 145.635 269.28 144.214C271.265 143.1 273.056 141.502 274.651 139.422V145.162H282.984V118.979C282.984 117.136 282.905 115.438 282.747 113.884C282.589 112.305 282.128 110.764 281.365 109.264C279.969 106.447 277.824 104.419 274.928 103.182C272.058 101.945 268.727 101.326 264.936 101.326C259.908 101.326 255.906 102.418 252.931 104.604C249.982 106.789 247.981 109.685 246.928 113.292L255.616 116.017C256.327 113.832 257.578 112.291 259.368 111.396C261.158 110.501 263.014 110.053 264.936 110.053C268.122 110.053 270.386 110.751 271.729 112.147C272.847 113.308 273.49 115.008 273.659 117.246C271.932 117.504 270.249 117.752 268.609 117.991C265.923 118.36 263.422 118.768 261.105 119.216C258.815 119.663 256.814 120.163 255.103 120.716C252.839 121.48 250.996 122.467 249.574 123.678C248.152 124.863 247.099 126.285 246.415 127.943C245.73 129.576 245.388 131.418 245.388 133.472C245.388 135.815 245.928 137.961 247.007 139.909C248.113 141.857 249.732 143.424 251.864 144.609ZM267.108 137.619C265.581 138.382 263.738 138.764 261.579 138.764C260.079 138.764 258.815 138.527 257.788 138.053C256.788 137.579 256.024 136.947 255.498 136.157C254.971 135.341 254.708 134.407 254.708 133.354C254.708 132.432 254.905 131.629 255.3 130.945C255.721 130.26 256.314 129.655 257.077 129.128C257.841 128.601 258.775 128.141 259.881 127.746C261.013 127.377 262.317 127.048 263.791 126.758C265.265 126.443 267.029 126.113 269.083 125.771C270.397 125.552 271.878 125.312 273.526 125.05C273.507 125.775 273.474 126.608 273.427 127.548C273.374 129.102 273.098 130.484 272.598 131.695C272.282 132.669 271.663 133.709 270.741 134.815C269.846 135.921 268.635 136.855 267.108 137.619ZM290.896 145.162V102.511H299.308V109.323C299.628 108.75 299.984 108.204 300.374 107.684C301.269 106.499 302.335 105.525 303.573 104.762C304.626 104.051 305.784 103.498 307.048 103.103C308.338 102.682 309.747 102.59 311.09 102.511H315.334H323.075V90.6631H332.553V102.511H345.072V109.975H332.553V127.193C332.553 128.904 332.566 130.405 332.592 131.695C332.645 132.985 332.921 134.038 333.422 134.854C334.369 136.434 335.883 137.316 337.963 137.5C340.043 137.684 342.412 137.579 345.072 137.184V145.162C342.254 145.688 339.49 145.912 336.778 145.833C334.093 145.78 331.684 145.293 329.551 144.372C327.419 143.424 325.8 141.936 324.694 139.909C323.72 138.066 323.206 136.184 323.154 134.262C323.101 132.34 323.075 130.168 323.075 127.746V109.975H315.334C314.47 109.975 313.789 109.966 313.223 109.96C311.604 109.94 310.921 109.932 309.573 110.157C307.905 110.435 307.001 110.927 305.928 111.512C305.83 111.565 305.731 111.619 305.63 111.673C304.417 112.328 303.811 112.887 302.597 115.01C301.609 116.74 301.463 117.316 301.229 118.239L301.229 118.24C301.176 118.449 301.118 118.676 301.045 118.939C300.65 120.334 300.453 121.848 300.453 123.481V145.162H290.896ZM369.104 146.346C364.786 146.346 360.995 145.412 357.73 143.542C354.466 141.673 351.912 139.08 350.069 135.763C348.252 132.445 347.344 128.628 347.344 124.31C347.344 119.65 348.239 115.609 350.03 112.186C351.82 108.737 354.308 106.065 357.494 104.169C360.679 102.274 364.365 101.326 368.551 101.326C372.974 101.326 376.726 102.366 379.806 104.446C382.913 106.499 385.217 109.408 386.717 113.173C388.218 116.938 388.784 121.374 388.415 126.482H383.755H378.977H357.546C357.865 129.544 358.769 132.006 360.258 133.867C362.154 136.236 364.918 137.421 368.551 137.421C370.894 137.421 372.908 136.908 374.593 135.881C376.305 134.828 377.621 133.314 378.543 131.34L387.942 134.183C386.309 138.027 383.782 141.015 380.359 143.148C376.963 145.28 373.211 146.346 369.104 146.346ZM376.529 112.857C377.669 114.372 378.411 116.518 378.755 119.295H357.778C358.214 116.832 359.04 114.831 360.258 113.292C362.154 110.87 365.05 109.659 368.946 109.659C372.395 109.659 374.923 110.725 376.529 112.857ZM394.858 102.511V145.162H404.415V123.481C404.415 121.848 404.612 120.334 405.007 118.939C405.402 117.517 406.007 116.254 406.824 115.148C407.666 114.042 408.745 113.134 410.062 112.423C411.378 111.633 412.853 111.172 414.485 111.041C416.144 110.909 417.605 111.028 418.869 111.396V102.511C417.605 102.3 416.302 102.247 414.959 102.353C413.616 102.432 412.3 102.682 411.01 103.103C409.746 103.498 408.588 104.051 407.534 104.762C406.297 105.525 405.231 106.499 404.336 107.684C403.946 108.204 403.59 108.75 403.269 109.323V102.511H394.858Z"
          fill="currentColor"
        />
      </svg>
    ),
    label: 'supastarter',
  },
  {
    url: 'https://launchfa.st',
    label: 'launchfast',
    github: 'launchfast',
    logo: (
      <>
        <svg
          xmlns="http://www.w3.org/2000/svg"
          className="h-2/3 rounded-full border border-fd-foreground"
          viewBox="0 0 784 784"
        >
          <path
            fill="currentColor"
            mask="url(#launchfast_window)"
            d="M598 186c8.54 10.037 7.44 22.11 6.465 34.497-.24 2.837-.49 5.674-.742 8.51l-.397 4.607c-.346 4.021-.697 8.042-1.05 12.063-.56 6.41-1.116 12.822-1.668 19.233a5334.62 5334.62 0 0 0-.944 10.817l-.176 2.046a362.84 362.84 0 0 0-.75 10.902l-.124 2.334a569.933 569.933 0 0 0-.21 4.423c-.214 4.29-.806 7.778-2.603 11.662-.994 2.365-1.454 4.71-1.989 7.219-1.386 5.796-3.5 11.149-5.812 16.625l-1.044 2.475c-1.747 4.055-3.619 7.83-5.956 11.587-.696 2.191-.696 2.191-1 4h-2l-.715 2.582c-1.437 3.822-3.44 6.853-5.847 10.106l-1.337 1.835c-7.368 10.027-15.5 18.94-24.376 27.64a5694.76 5694.76 0 0 0-18.439 18.188c-3.706 3.67-7.42 7.333-11.147 10.982a1878.074 1878.074 0 0 0-10.793 10.657 633.457 633.457 0 0 1-4.122 4.046 567.68 567.68 0 0 0-5.725 5.67l-1.744 1.668c-1.777 1.731-1.777 1.731-3.755 4.626-.05 3.175-.05 3.175 1 6l.938 3.254c.35 1.092.7 2.184 1.062 3.308 4.092 12.772 3.947 25.655 1.688 38.813l-.357 2.142c-.745 3.913-1.764 6.456-4.331 9.483-.714 2.65-.714 2.65-1 5h-2l-.563 2.438c-1.979 4.905-5.088 8.512-8.437 12.562l-1.5 1.91c-1.116 1.405-2.302 2.755-3.5 4.09h-2v2c-1.8 1.594-1.8 1.594-4.313 3.5A172.533 172.533 0 0 0 455.5 551c-4.207 3.876-8.543 7.476-13.04 11.008-2.548 2.063-4.974 4.22-7.397 6.43A290.988 290.988 0 0 1 419 582l-2.344 1.898c-4.786 3.59-8.404 4.914-14.43 4.485-3.123-.537-4.868-1.233-7.226-3.383-3.406-5.002-5.503-10.483-7.773-16.074-1.287-3.07-2.74-6-4.275-8.95C382 558 382 558 380.742 554.41c-1.931-5.226-4.692-9.921-7.492-14.722l-1.621-2.803c-6.761-12.23-6.761-12.23-15.629-22.885l-1.206 1.253c-1.819 1.882-3.65 3.752-5.481 5.622l-1.897 1.973c-4.408 4.477-7.49 6.89-13.916 7.465-5.833-.521-9.095-3.66-13.082-7.735l-2.576-2.61-2.654-2.718c-5.343-5.45-10.652-10.828-16.503-15.737-1.738-1.56-3.205-3.21-4.685-5.013-2.712-3.293-5.74-5.981-8.984-8.742-3.167-2.761-6.077-5.76-9.016-8.758a1037.58 1037.58 0 0 0-8.883-8.813L262.875 466l-2.168-2.117c-9.094-9.01-9.094-9.01-9.332-15.695.169-5.182 1.954-7.632 5.535-11.235L259 435a1202.76 1202.76 0 0 0 4.438-4.375l2.058-1.96c1.728-1.538 1.728-1.538 1.504-3.665-1.805-1.454-1.805-1.454-4.18-2.906l-2.728-1.74-2.967-1.854-3.026-1.9c-12.059-7.516-23.892-14.714-37.316-19.487-18.847-6.718-18.847-6.718-22.658-12.488-1.59-5.125-2.662-9.655-.09-14.625 1.541-2.13 3.195-4.056 4.965-6l2.086-2.336a866.255 866.255 0 0 1 4.574-5.047c2.276-2.546 4.443-5.15 6.59-7.805 7.3-9.01 14.93-17.75 22.75-26.312 2.398-2.633 4.583-5.228 6.563-8.188 5.777-8.345 15.06-13.848 23.437-19.312l2.016-1.32c17.078-9.77 39.649-8.248 57.984-3.68l3.137 1.164c3.37.984 4.55.977 7.863-.164 2.424-1.87 4.506-4.043 6.632-6.241l1.959-1.977a972.937 972.937 0 0 0 4.197-4.269c2.221-2.273 4.456-4.533 6.694-6.79a6180.08 6180.08 0 0 0 16.656-16.903 4766.2 4766.2 0 0 1 14.043-14.225c2.176-2.201 4.339-4.414 6.501-6.628 42.327-42.95 88.855-50.246 146.518-54.88 2.264-.181 4.527-.364 6.791-.55C585.59 175.325 585.59 175.325 598 186Z"
          />
          <path
            fill="currentColor"
            d="M264.313 503.563c5.121.607 8.929 2.92 12.687 6.437 1.961 5.23 1.59 10.435-.338 15.553-3.284 6.238-8.6 10.938-13.56 15.842-1.08 1.079-2.158 2.159-3.236 3.24-2.251 2.252-4.51 4.498-6.773 6.739a1708.123 1708.123 0 0 0-8.641 8.628c-2.222 2.228-4.45 4.45-6.682 6.668-1.063 1.059-2.124 2.12-3.183 3.183a758.37 758.37 0 0 1-4.471 4.435l-2.561 2.545c-4.848 4.112-9.126 5.743-15.375 5.522-4.382-.714-7.145-3.177-9.993-6.418-1.867-3.046-2.384-5.742-2.5-9.25l-.113-2.238c.981-5.644 5.575-9.857 9.467-13.796l1.48-1.505c1.6-1.624 3.206-3.24 4.815-4.855l3.37-3.397c2.348-2.365 4.7-4.725 7.056-7.083 3.013-3.02 6.01-6.054 9.004-9.093 2.311-2.341 4.634-4.67 6.96-6.997a628.716 628.716 0 0 0 3.317-3.356 520.1 520.1 0 0 1 4.658-4.667l2.668-2.684c3.83-2.935 7.295-2.84 11.944-3.454Z"
          />
          <path
            fill="currentColor"
            d="M233.375 467.125c3.494 2.478 5.295 4.72 6.625 8.875.734 5.765-.781 9.346-4 14-2.25 2.662-4.675 5.12-7.145 7.578l-2.084 2.1c-1.45 1.457-2.903 2.909-4.36 4.357a1034.46 1034.46 0 0 0-6.616 6.668 3703.998 3703.998 0 0 1-4.252 4.25l-1.974 2.008c-5.108 5.031-10.158 8.373-17.569 8.726-3.24-.074-4.603-.37-7.16-2.41-3.744-4.236-5.988-7.316-6.153-13.027l-.113-2.547c1.057-6.71 7.04-11.623 11.64-16.219l2.1-2.112c1.46-1.465 2.92-2.927 4.385-4.387 2.237-2.233 4.46-4.48 6.682-6.727l4.271-4.274 2.005-2.032c6.829-6.761 14.751-9.963 23.718-4.827ZM303.758 541.445c5.337 1.32 9.073 3.911 12.242 8.367 1.871 5.965 1.74 10.17-1 15.688a128.013 128.013 0 0 1-2 3.5h-2v2c-2.375 2.625-2.375 2.625-5 5h-2v2h-2v2c-1.715 1.656-1.715 1.656-3.938 3.5-2.982 2.39-2.982 2.39-5.062 5.5h-2l-.813 1.938C289 593 289 593 286 594v2c-1.645 1.473-1.645 1.473-3.813 3.063l-2.144 1.597c-3.967 2.602-7.401 2.655-12.043 2.34-4.535-1.542-7.49-3.801-10.07-7.781-1.964-4.687-1.955-9.293-.93-14.219 1.84-3.271 4.18-5.55 7-8l1.93-1.691c1.316-1.14 2.64-2.27 3.968-3.395 2.383-2.17 4.475-4.495 6.602-6.914 3.308-3.75 6.692-7.135 10.54-10.328 2.012-1.668 2.012-1.668 3.92-3.656 4.065-4.017 6.948-6.077 12.798-5.57Z"
          />

          <defs>
            <mask id="launchfast_window">
              <rect x="0" y="0" width="784" height="784" fill="white" />
              <circle fill="black" cx="459" cy="323" r="43.84" />
            </mask>
          </defs>
        </svg>
        LaunchFast
      </>
    ),
  },
];
