
#ifndef MEDIA_THUNDERSTRUCK_H_
#define MEDIA_THUNDERSTRUCK_H_ 1

#include <kernel/keyboard.h> /* kb_held */
#include <kernel/pcspkr.h>
#include <kernel/framebuffer_console.h>
#include <kernel/color.h>

#define THUNDERSTRUCK_DELAY 120

Beep thunderstruck[] = {
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 783, .ms_len = THUNDERSTRUCK_DELAY },

    /* 4 times the same*/
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 987, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 492, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },

    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 987, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 492, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },

    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 987, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 492, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },

    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 987, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 880, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 830, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 739, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 492, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 659, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 493, .ms_len = THUNDERSTRUCK_DELAY },
    { .freq = 622, .ms_len = THUNDERSTRUCK_DELAY },
};

#define LENGTH(arr) (sizeof(arr) / sizeof(arr[0]))

/**
 * @brief Play the thunderstruck Beep array.
 */
static inline void play_thunderstruck(void) {
    fbc_setfore(COLOR_GREEN_B);
    printf("Playing thunderstruck... Press \'q\' to stop.\n");

    for (unsigned long i = 0; i < LENGTH(thunderstruck) && !kb_held('q'); i++) {
        putchar('\r');

        fbc_setfore(COLOR_WHITE_B);
        putchar('[');
        fbc_setfore(COLOR_GREEN);
        printf("%3d", (unsigned int)i);
        fbc_setfore(COLOR_WHITE_B);
        putchar(']');
        fbc_setfore(COLOR_WHITE);

        printf(" Frequency: %ld, Delay: %ld", thunderstruck[i].freq,
               thunderstruck[i].ms_len);
        pcspkr_beep_custom(thunderstruck[i]);
    }

    putchar('\n');
}

#endif /* MEDIA_THUNDERSTRUCK_H_ */
