
#ifndef FONTS_MAIN_FONT_H_
#define FONTS_MAIN_FONT_H_ 1

#include <kernel/font.h>
#include "font_defines.h"

/**
 * @brief Main font used by the framebuffer console.
 * @author Cozette, bdf2c
 *
 * @details Each item of the char idx is a 8px row of that char, represented by
 * each bit of the byte. Example:
 *
 *      *.font['a'] = {
 *          ........ ,
 *          ..####.. ,
 *          .#....#. ,
 *          .#....#. ,
 *          .######. ,
 *          .#....#. ,
 *          .#....#. ,
 *          .#....#. ,
 *          ........ ,
 *          ........ ,
 *      }
 *
 * Where each item of idx 'a' is a byte, and each '#' is a bit set to 1 of that
 * byte, and each '.' is a bit set to 0.
 *
 * Because it is a 3d array in 1d format, to access a px of a char we use:
 *
 *      Font->font['C' * Font->h + y] & (0x80 >> x)
 *
 * (See src/kernel/include/kernel/font.h)
 *
 * For more information see:
 * https://jared.geek.nz/2014/jan/custom-fonts-for-microcontrollers
 * (https://web.archive.org/web/20221206153507/https://jared.geek.nz/2014/jan/custom-fonts-for-microcontrollers)
 */
Font main_font = {
    .w    = 7,
    .h    = 13,
    .name = "Cozette",
    /* Huge credits to https://github.com/pixelmatix/bdf2c */
    .font =
      (uint8_t[]){
        /* From 0 to 20, NULL */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        __X_X___, /**/
        __X_X___, /**/
        __X_X___, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __X_X___, /**/
        __X_X___, /**/
        _XXXXX__, /**/
        __X_X___, /**/
        __X_X___, /**/
        _XXXXX__, /**/
        __X_X___, /**/
        __X_X___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ___X____, /**/
        __XXX___, /**/
        _X_X_X__, /**/
        _X_X____, /**/
        __XXX___, /**/
        ___X_X__, /**/
        ___X_X__, /**/
        _X_X_X__, /**/
        __XXX___, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        __X_____, /**/
        _X_X____, /**/
        __X__X__, /**/
        ____X___, /**/
        ___X____, /**/
        __X_____, /**/
        _X__X___, /**/
        ___X_X__, /**/
        ____X___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ___X____, /**/
        __X_X___, /**/
        __X_X___, /**/
        ___X____, /**/
        __XX_X__, /**/
        _X__X___, /**/
        _X__X___, /**/
        _X__X___, /**/
        __XX_X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ____X___, /**/
        ___X____, /**/
        ___X____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        ___X____, /**/
        ___X____, /**/
        ____X___, /**/
        ________, /**/

        ________, /**/
        __X_____, /**/
        ___X____, /**/
        ___X____, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ___X____, /**/
        ___X____, /**/
        __X_____, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __X_X___, /**/
        ___X____, /**/
        _XXXXX__, /**/
        ___X____, /**/
        __X_X___, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ___X____, /**/
        ___X____, /**/
        _XXXXX__, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XX____, /**/
        __XX____, /**/
        ___X____, /**/
        __X_____, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XX____, /**/
        __XX____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        _____X__, /**/
        _____X__, /**/
        ____X___, /**/
        ____X___, /**/
        ___X____, /**/
        ___X____, /**/
        __X_____, /**/
        __X_____, /**/
        _X______, /**/
        _X______, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ___X____, /**/
        __XX____, /**/
        _X_X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _____X__, /**/
        ____X___, /**/
        ___X____, /**/
        __X_____, /**/
        _X______, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _____X__, /**/
        ___XX___, /**/
        _____X__, /**/
        _____X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _____X__, /**/
        ____XX__, /**/
        ___X_X__, /**/
        __X__X__, /**/
        _X___X__, /**/
        _XXXXXX_, /**/
        _____X__, /**/
        _____X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        _X______, /**/
        _X______, /**/
        _XXXX___, /**/
        _____X__, /**/
        _____X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ___XX___, /**/
        __X_____, /**/
        _X______, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        _____X__, /**/
        ____X___, /**/
        ____X___, /**/
        ___X____, /**/
        ___X____, /**/
        __X_____, /**/
        __X_____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXXX__, /**/
        _____X__, /**/
        ____X___, /**/
        __XX____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XX____, /**/
        __XX____, /**/
        ________, /**/
        ________, /**/
        __XX____, /**/
        __XX____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XX____, /**/
        __XX____, /**/
        ________, /**/
        ________, /**/
        __XX____, /**/
        __XX____, /**/
        ___X____, /**/
        __X_____, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        _____X__, /**/
        ____X___, /**/
        ___X____, /**/
        __X_____, /**/
        ___X____, /**/
        ____X___, /**/
        _____X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        ________, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        _X______, /**/
        __X_____, /**/
        ___X____, /**/
        ____X___, /**/
        ___X____, /**/
        __X_____, /**/
        _X______, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _____X__, /**/
        ____X___, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X_XXX__, /**/
        _X_X_X__, /**/
        _X_XXX__, /**/
        _X______, /**/
        __XXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXXX__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXX____, /**/
        _X__X___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X__X___, /**/
        _XXX____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        _X______, /**/
        _X______, /**/
        _XXXX___, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        _X______, /**/
        _X______, /**/
        _XXXX___, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X______, /**/
        _X______, /**/
        _X__XX__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXXX__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ___XXX__, /**/
        _____X__, /**/
        _____X__, /**/
        _____X__, /**/
        _____X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X__X___, /**/
        _X_X____, /**/
        _XXX____, /**/
        _X__X___, /**/
        _X__X___, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _XX_XX__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _XX__X__, /**/
        _XX__X__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        _X__XX__, /**/
        _X__XX__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXX___, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X__X___, /**/
        __XX_X__, /**/
        _____X__, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXX___, /**/
        _X__X___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X______, /**/
        __XXX___, /**/
        _____X__, /**/
        _____X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __X_X___, /**/
        __X_X___, /**/
        __X_X___, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        __XXX___, /**/
        __X_X___, /**/
        __X_X___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        __X_X___, /**/
        ___X____, /**/
        ___X____, /**/
        __X_X___, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __X_X___, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        ____X___, /**/
        ___X____, /**/
        ___X____, /**/
        __X_____, /**/
        __X_____, /**/
        _X______, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        __XXX___, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __XXX___, /**/
        ________, /**/

        ________, /**/
        _X______, /**/
        _X______, /**/
        __X_____, /**/
        __X_____, /**/
        ___X____, /**/
        ___X____, /**/
        ____X___, /**/
        ____X___, /**/
        _____X__, /**/
        _____X__, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        __XXX___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        __XXX___, /**/
        ________, /**/

        ___X____, /**/
        __X_X___, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        __X_____, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XXXX__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X__XX__, /**/
        __XX_X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X______, /**/
        _X______, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        _____X__, /**/
        _____X__, /**/
        _____X__, /**/
        __XXXX__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _XXXXX__, /**/
        _X______, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ___XXX__, /**/
        __X_____, /**/
        __X_____, /**/
        _XXXX___, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XXXX__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXXX__, /**/
        _____X__, /**/
        _____X__, /**/
        __XXX___, /**/

        ________, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ___X____, /**/
        ________, /**/
        __XX____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ____XX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ____X___, /**/
        ________, /**/
        ___XX___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        __X_X___, /**/
        ___X____, /**/
        ________, /**/

        ________, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X___X__, /**/
        _X__X___, /**/
        _X_X____, /**/
        _XXX____, /**/
        _X__X___, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        __XX____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___XX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XX_X___, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _XXXX___, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XXXX__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXXX__, /**/
        _____X__, /**/
        _____X__, /**/
        _____XX_, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XXXX___, /**/
        _X___X__, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        _X______, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __XXXX__, /**/
        _X______, /**/
        __XXX___, /**/
        _____X__, /**/
        _____X__, /**/
        _XXXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        __X_____, /**/
        __X_____, /**/
        _XXXX___, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        __X_____, /**/
        ___XXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        __X_X___, /**/
        __X_X___, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X_X_X__, /**/
        _X_X_X__, /**/
        __X_X___, /**/
        __X_X___, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _X___X__, /**/
        __X_X___, /**/
        ___X____, /**/
        ___X____, /**/
        __X_X___, /**/
        _X___X__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        _X___X__, /**/
        __XXXX__, /**/
        _____X__, /**/
        _____X__, /**/
        __XXX___, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        _XXXXX__, /**/
        ____X___, /**/
        ___X____, /**/
        __X_____, /**/
        _X______, /**/
        _XXXXX__, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ____XX__, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        _XX_____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ____XX__, /**/
        ________, /**/

        ________, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ________, /**/

        ________, /**/
        _XX_____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ____XX__, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        ___X____, /**/
        _XX_____, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        __X__X__, /**/
        _X_X_X__, /**/
        _X__X___, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ____X___, /* 179 */
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/

        ____X___, /* 180 */
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        XXXXX___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ___XX___, /* 185 */
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        XXXXX___, /**/
        XXXXX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/

        ___XX___, /* 186 */
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/

        ________, /* 187 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        XXXXX___, /**/
        XXXXX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/

        ___XX___, /* 188 */
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        XXXXX___, /**/
        XXXXX___, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /* 191 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        XXXXX___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/

        ____X___, /* 192 */
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____XXXX, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ____X___, /* 193 */
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        XXXXXXXX, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /* 194 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        XXXXXXXX, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/

        ____X___, /* 195 */
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____XXXX, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/

        ________, /* 196 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        XXXXXXXX, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ____X___, /* 197 */
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        XXXXXXXX, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ___XX___, /* 200 */
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XXXXX, /**/
        ___XXXXX, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /* 201 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ___XXXXX, /**/
        ___XXXXX, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/

        ___XX___, /* 202 */
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /* 203 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/

        ___XX___, /* 204 */
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XXXXX, /**/
        ___XXXXX, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/

        ________, /* 205 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ___XX___, /* 206 */
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/
        ___XX___, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ____X___, /* 217 */
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____XXXX, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /* 218 */
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ____XXXX, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/
        ____X___, /**/

        XXXXXXXX, /* 219 */
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/
        XXXXXXXX, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/

        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
        ________, /**/
      },
};

#endif /* FONTS_MAIN_FONT_H_ */
