# Contributing
## Submitting contributions
  - [Create a fork](https://docs.github.com/en/get-started/quickstart/fork-a-repo) of the repository.
  - Make your changes. **Make a pull request per feature/change!**
    - **Do not make a "fix stuff" PR with a million files changed. Instead provide a  description of the changes and keep it simple.**
    - **It's better to make different pull requests with different changes each time instead of a big one that might be harder to maintain.**
  - When your contribution is ready to be integrated, create a [pull request](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests). 
  - In the pull request description, detail the changes your contribution made including any bugs fixed, features added, etc.

## Suggesting features/improvements
  - Create a [new issue](https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues).
  - Use a [concise and useful](https://api.coala.io/en/latest/Developers/Writing_Good_Commits.html) title that describes the specific feature.
  - In the description detail the feature's design specifications along with the acceptance criteria for the feature.
  - Submit the issue.
  - Be sure to follow up the issue over time by reading and repsonding to comments, as that will be the primary means of communicating on the progress of the issue.

## Reporting bugs
  - Create a [new issue](https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues).
  - Use a [concise and useful](https://api.coala.io/en/latest/Developers/Writing_Good_Commits.html) title that describes the specific bug.
  - In the description provide the following:
    - Detailed description of the buggy behavior.
    - As many reproduction steps as you can provide.
    - Optionally a fix that you found.
  - Submit the issue.
  - Be sure to follow up the issue over time by reading and repsonding to comments, as that will be the primary means of communicating on the progress of the issue.

