<?php

/**
 * This file is part of the Froxlor project.
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can also view it online at
 * https://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  the authors
 * @author     Froxlor team <team@froxlor.org>
 * @author     Staffan Starberg <staff@starberg.com>
 * @license    https://files.froxlor.org/misc/COPYING.txt GPLv2
 */

return [
	'admin' => [
		'overview' => 'Översikt',
		'ressourcedetails' => 'Använda resurser',
		'systemdetails' => 'System Detaljer',
		'froxlordetails' => 'Froxlor Detaljer',
		'installedversion' => 'Installerad version av Froxlor',
		'latestversion' => 'Senaste version av Froxlor',
		'lookfornewversion' => [
			'clickhere' => '[Sök senaste verison av Froxlor via Internet]',
			'error' => 'Fel vid läsning, kontrollera uppkopplingen mot Froxlor',
		],
		'resources' => 'Resurser',
		'customer' => 'Kunder',
		'customers' => 'Kunder',
		'customer_add' => '[Skapa en ny kund]',
		'customer_edit' => 'Ändra ny kund',
		'domains' => 'Domäner',
		'domain_add' => '[Skapa en ny domän]',
		'domain_edit' => 'Tillåt ändring av domänen',
		'subdomainforemail' => 'Sub-domän som E-postdomän (Subdomains as emaildomains)',
		'admin' => 'Admin',
		'admins' => 'Admins',
		'admin_add' => '[Skapa en ny admin]',
		'admin_edit' => 'Ändra admin',
		'customers_see_all' => 'Kan se alla kunder?',
		'change_serversettings' => 'Kan ändra serverinställningar?',
		'server' => 'Systemet',
		'serversettings' => 'Inställningar',
		'rebuildconf' => 'Uppdatera konfig filer',
		'stdsubdomain' => 'Standard subdomän',
		'stdsubdomain_add' => '[Skapa en ny standard subdomän]',
		'phpenabled' => 'PHP påslagen',
		'deactivated' => 'Inaktiv',
		'deactivated_user' => 'Avaktivera användare',
		'sendpassword' => 'Skicka lösenord',
		'ownvhostsettings' => 'Egna vHost-Inställningar',
		'configfiles' => [
			'serverconfiguration' => 'Konfiguration',
			'overview' => 'Översikt',
			'wizard' => 'Guide',
			'mail' => 'E-postserver (POP3/IMAP)',
			'smtp' => 'E-postserver (SMTP)',
		],
		'templates' => [
			'templates' => 'Mallar',
			'template_add' => '[Lägg till en ny mall]',
			'template_edit' => 'Ändra en befintlig mall',
			'action' => 'Action',
			'email' => 'E-Post',
			'subject' => 'Rubrik (subjekt)',
			'mailbody' => 'E-Postinnehåll (Mail body)',
			'createcustomer' => 'E-Post till nya kunder (Välkommen)',
			'pop_success' => 'E-Post för nya konton (Välkommen)',
			'template_replace_vars' => 'Variabler som kan ändras i mallen:',
			'FIRSTNAME' => 'Ändra till kundens förnamn.',
			'NAME' => 'Ändra till kundens efternamn.',
			'USERNAME' => 'Ändra till kundens kontonamns användarnamn.',
			'PASSWORD' => 'Ändra till kundens kontonamns lösenord.',
			'EMAIL' => 'Ändra till adressen för POP3/IMAP kontot.',
			'TRAFFIC' => 'Ersatt med trafikbegrnsningen som var tilldelad till kunden.',
			'TRAFFICUSED' => 'Ersatt med trafikbegrnsningen som var överskriden av kunden.',
			'pop_success_alternative' => 'Välkommstmeddelande för nya E-post konton som skickas till den alternativa adressen',
			'EMAIL_PASSWORD' => 'Ersatt med POP3/IMAP kontots lösenord.',
		],
		'ipsandports' => [
			'ipsandports' => 'IPs and Ports',
			'add' => '[Lägg till IP/Port]',
			'edit' => 'Ändra IP/Port',
			'create_listen_statement' => 'Skapa "Listen statement"',
			'create_namevirtualhost_statement' => 'Skapa NameVirtualHost statement',
			'create_vhostcontainer' => 'Skapa vHost-Container',
			'create_vhostcontainer_servername_statement' => 'Skapa ServerName statement i vHost-Container',
		],
		'memorylimitdisabled' => 'Avstängd',
		'valuemandatory' => 'Denna ruta måste fyllas i',
		'valuemandatorycompany' => 'Fyll i &quot;förnamn&quot; och &quot;efternamn&quot; eller &quot;företagsnamn&quot;',
		'serversoftware' => 'Webserver version',
		'phpversion' => 'PHP-Version',
		'phpmemorylimit' => 'PHP-Minnesgräns',
		'mysqlserverversion' => 'MySQL Server Version',
		'mysqlclientversion' => 'MySQL Klient Version',
		'webserverinterface' => 'Webserver Interface',
		'accountsettings' => 'Kontoinställningar',
		'panelsettings' => 'Panelinställningar',
		'systemsettings' => 'Systeminställningar',
		'webserversettings' => 'Webserverinställningar',
		'mailserversettings' => 'E-postserverinställningar',
		'nameserversettings' => 'Namnserverinställningar',
		'updatecounters' => 'Uppdatera status',
		'subcanemaildomain' => [
			'never' => 'Aldrig',
			'choosableno' => 'Valbar, standardvärdet är Nej',
			'choosableyes' => 'Valbar, standardvärdet är Ja',
			'always' => 'Alltid',
		],
		'webalizersettings' => 'Webalizer inställningar',
		'webalizer' => [
			'normal' => 'Normal',
			'quiet' => 'Tyst',
			'veryquiet' => 'Väldigt tyst',
		],
		'domain_nocustomeraddingavailable' => 'Det går inte att skapa en ny domän innan det finns mins en upplagd kund.',
	],
	'changepassword' => [
		'old_password' => 'Gammalt lösenord',
		'new_password' => 'Nytt lösenord',
		'new_password_confirm' => 'Nytt lösenord (verifiera)',
		'new_password_ifnotempty' => 'Nytt lösenord (Tomt fältet = inga ändringar)',
		'also_change_ftp' => ' Ändra även lösenord för huvud FTP kontot',
		'also_change_stats' => ' Ändra även lösenord för statistik',
	],
	'customer' => [
		'documentroot' => 'Hemkatalog',
		'name' => 'Efternamn',
		'firstname' => 'Förnamn',
		'company' => 'Företag',
		'street' => 'Postadress',
		'zipcode' => 'Postnummer',
		'city' => 'Postort',
		'phone' => 'Telefon',
		'fax' => 'Fax',
		'email' => 'E-post',
		'customernumber' => 'Kundnummer',
		'diskspace' => 'Webb (MB)',
		'traffic' => 'Trafik (GB)',
		'mysqls' => 'SQL_DBas',
		'emails' => 'E-post_adresser',
		'accounts' => 'E-post_konton',
		'forwarders' => 'E-post_skicka_vidare',
		'ftps' => 'FTP_Kto',
		'subdomains' => 'Sub-Domäner',
		'domains' => 'Domäner',
	],
	'domain' => [
		'openbasedirpath' => 'OpenBasedir-path',
		'docroot' => 'Sökvägen från ovanstående fält',
		'homedir' => 'Hemkatalog',
	],
	'domains' => [
		'description' => 'Här kan du skapa (sub-)domäner och ändra i dem.<br />Systemet behöver dock lite tid på sig att genomföra ändringarna.',
		'domainsettings' => 'Domäninställningar',
		'domainname' => 'Domännamn',
		'subdomain_add' => '[Skapa en ny subdomän]',
		'subdomain_edit' => 'Ändra (sub)domän',
		'wildcarddomain' => 'Skapa som ospecificerad domän (Create as wildcarddomain?)',
		'aliasdomain' => 'Alias for domän',
		'noaliasdomain' => '(inget alias)',
		'hasaliasdomains' => 'Domänen har redan alias',
		'statstics' => 'Användarstatistik',
		'isassigneddomain' => 'Tilldelad domän ',
	],
	'emails' => [
		'description' => 'Här kan du skapa eller ändra dina E-postadresser.<br />Ett konto är som en brevlåda utanför huset. Om någon skickar dig E-post kommer det att hamna i din brevlåda (ditt konto).<br /><br />För att hämta din E-post så skall du använda följande inställningar i ditt E-postprogram: (Text i kursiv stil <i>italics</i> måste ändras till det som motsvaras av det du knappade in tidigare!)<br />Servernamn (Hostname): <b><i>Domännamn (Domainname)</i></b><br />Användarnamn (Username): <b><i>Konto namn (Account name) / E-postadress</i></b><br />Lösenord (Password): <b><i>lösenordet som du valde</i></b>',
		'emailaddress' => 'E-postadress',
		'emails_add' => '[Skapa en E-postadress]',
		'emails_edit' => 'Ändra E-postadressen',
		'catchall' => 'Maildump',
		'iscatchall' => 'Skapa en maildump?',
		'account' => 'Konto',
		'account_add' => 'Skapa konto',
		'account_delete' => 'Radera konto',
		'from' => 'Från',
		'to' => 'Till',
		'forwarders' => 'Skicka vidare:',
		'forwarder_add' => '[Skapa ny "skicka vidare"]',
		'alternative_emailaddress' => 'Alternative e-mail-address',
	],
	'error' => [
		'error' => 'Följande fel har uppstått',
		'directorymustexist' => 'Katalogen %s måste finnas. Skapa den med ditt FTP program.',
		'filemustexist' => 'Filen %s måste existera.',
		'allresourcesused' => 'Du har redan skapt så många konton som du har tillstånd till.',
		'domains_cantdeletemaindomain' => 'Du kan inte radera en domän som användes för E-post.',
		'domains_canteditdomain' => 'Endast administratörer kan ändra denna domän.',
		'domains_cantdeletedomainwithemail' => 'Du kan inte radera en domän som användes för E-post. Radera alla E-postadresser först',
		'firstdeleteallsubdomains' => 'Du måste radera alla sub-domäner innan du kan skapa en maildump (wildcard domain).',
		'youhavealreadyacatchallforthisdomain' => 'Du har redan skapat en maildump för denna domän.',
		'ftp_cantdeletemainaccount' => 'Det går inte att radera huvud FTP kontot för domänen',
		'login' => 'Användarnamnet eller lösenordet var felaktigt, försök igen!',
		'login_blocked' => 'Kontot har blivit avstängt på grund av för många felaktiga inloggningsförsök. <br />Försök igen om %s sekunder.',
		'notallreqfieldsorerrors' => 'Du har inte fyllt i alla fält eller så har du skrivit in något som inte accepteras.',
		'oldpasswordnotcorrect' => 'Det gamla lösenordet är fel.',
		'youcantallocatemorethanyouhave' => 'Du kan inte skapa fler resurser än du äger själv (You cannot allocate more resources than you own for yourself).',
		'mustbeurl' => 'Du har inte skrivit in en korrekt url (e.g. http://somedomain.com/error404.htm)',
		'invalidpath' => 'Du har inte valt en korrekt url (Kanske har du lagt till en katalogsäkerhet så att katalogerna inte kan visas?)',
		'stringisempty' => 'Du måste skriva in något i fältet',
		'stringiswrong' => 'Fel inatningsfält',
		'newpasswordconfirmerror' => 'New password and confirmation does not match',
		'mydomain' => '\'Domain\'',
		'mydocumentroot' => '\'Documentroot\'',
		'loginnameexists' => 'Login-Name %s är upptaget',
		'emailiswrong' => 'E-post-Adressen "%s" innehåller ogiltiga tecken eller så är den inte komplett',
		'loginnameiswrong' => 'Login-Namnet %s innehåller ogiltiga tecken',
		'userpathcombinationdupe' => 'Användarnamnet och sökvägen tillsammans finns redan',
		'patherror' => 'Generellt Fel! sökvägen till katalogen kan inte vara tom',
		'errordocpathdupe' => 'Option för sökvägen %s finns redan',
		'adduserfirst' => 'Skapa användaren först',
		'domainalreadyexists' => 'Domänen %s ägs redan av en kund',
		'nolanguageselect' => 'Inget språk är valt.',
		'nosubjectcreate' => 'Du måste ha ett rubrik för denna E-postmall.',
		'nomailbodycreate' => 'Du måste ha skrivit in en E-post text för denna mall.',
		'templatenotfound' => 'E-postmallen hittades inte.',
		'alltemplatesdefined' => 'Du kan inte skapa flera mallar, alla språk finns redan.',
		'wwwnotallowed' => 'www är inte tillåtet att använda för subdomäner.',
		'subdomainiswrong' => 'Subdomänen %s innehåller ogiltiga tecken.',
		'domaincantbeempty' => 'Fältet för domännamn får inte vara tommt.',
		'domainexistalready' => 'Domänen %s finns redan.',
		'domainisaliasorothercustomer' => 'Den valda domänen är antingen en aliasdomän eller så ägs den redan av en annan kund.',
		'emailexistalready' => 'E-postadressen %s finns redan.',
		'maindomainnonexist' => 'Huvuddomänen %s finns inte.',
		'destinationnonexist' => 'Skapa en forwarder i fältet \'Destination\'.',
		'destinationalreadyexistasmail' => 'Denna forwarder %s, finns redan som aktiv E-postadress.',
		'destinationalreadyexist' => 'Du har redan skapat en forwarder till %s .',
		'destinationiswrong' => 'Denna forwarder: %s innehåller ogiltiga tecken eller så är den inte komplett adress.',
		'ipstillhasdomains' => 'IP/Port kombinationen som du vill radera har fortfarande domäner anslutna till sig, Flytta dessa till någon annan IP/Port kombination innan du raderar denna IP/Port kombination.',
		'cantdeletedefaultip' => 'Det går inte att ta bort den förvalda återförsäljarens IP/Port kombination, Välj en annan IP/Port kombination som förval för återförsäljare innan du raderar denna IP/Port kombination.',
		'cantdeletesystemip' => 'Det går inte att radera den sista system IP:n, Antingen skapar man en ny IP/Port kombination för system IP eller så ändrar man system IP:n.',
		'myipaddress' => '\'IP\'',
		'myport' => '\'Port\'',
		'myipdefault' => 'Man måste välja en IP/Port kombination som skall bli standardvärdet.',
		'myipnotdouble' => 'Denna IP/Port kombination finns redan.',
		'cantchangesystemip' => 'Man kan inte ändra den senaste system IP-adressen. Skapa en helt ny IP/Port kombination för system IP:n eller ändra system IP-adressen.',
		'sessiontimeoutiswrong' => 'Bara siffror &quot;Session Timeout&quot; är tillåtna.',
		'maxloginattemptsiswrong' => 'Bara siffror &quot;Max Login Attempts&quot; är tillåtna.',
		'deactivatetimiswrong' => 'Bara siffror &quot;Deactivate Time&quot; är tillåtna.',
		'accountprefixiswrong' => 'Det här &quot;Customerprefix&quot; är fel.',
		'mysqlprefixiswrong' => 'Det här &quot;SQL Prefix&quot; är fel.',
		'ftpprefixiswrong' => 'Det här &quot;FTP Prefix&quot; är fel.',
		'ipiswrong' => 'Den här &quot;IP-Address&quot; är fel. Endast en giltig IP-adress är tillåten.',
		'vmailuidiswrong' => 'Den här &quot;Mails-uid&quot; är fel. Endast numerisk UID är tillåtenis allowed.',
		'vmailgidiswrong' => 'Den här &quot;Mails-gid&quot; är fel. Endast numerisk GID är tillåtenis allowed.',
		'adminmailiswrong' => 'Den här &quot;Sender-address&quot; är fel. Endast en giltig E-postadress är tillåten.',
		'pagingiswrong' => 'Den här &quot;Entries per Page&quot;-värdet är fel. Endast siffror är tillåtna.',
		'phpmyadminiswrong' => 'Den här phpMyAdmin-link är inte en giltig länk.',
		'webmailiswrong' => 'Den här WebMail-link är inte en giltig länk.',
		'webftpiswrong' => 'Den här WebFTP-link är inte en giltig länk.',
		'stringformaterror' => 'Värdet för fältet &quot;%s&quot; har inte rätt format.',
		'loginnameissystemaccount' => 'Det går inte att skapa ett konto som liknar ett systemkonto (Om det till exempel börjar med &quot;%s&quot;). Vlj ett annat kontonamn.',
		'youcantdeleteyourself' => 'Av säkerhetsskäl går inte att redera ditt eget konto.',
		'youcanteditallfieldsofyourself' => 'Notera: Av säkerhetsskäl går det inte att ändra ditt eget konto.',
		'documentrootexists' => 'Katalogen &quot;%s&quot; finns redan hos den här kunden. Radera detta först innan kunden skapas igen.',
		'formtokencompromised' => 'Den säkra anslutningen till Froxlor har avslutats och du har av säkerhetsskäl automatiskt loggats ur.',
	],
	'extras' => [
		'description' => 'Här kan du ändra övriga saker såsom katalogskydd mm.<br />Systemet behöver dock lite tid på sig att genomföra ändringarna.',
		'directoryprotection_add' => '[Skapa ett nytt katalogskydd]',
		'view_directory' => 'Visa kataloginnehåll',
		'pathoptions_add' => '[Skapa ny regel för sökvägar]',
		'directory_browsing' => 'Visning av katalogstruktur',
		'pathoptions_edit' => 'Ändra sökvägsinställningar',
	],
	'ftp' => [
		'description' => 'Här kan du skapa eller änra i dina FTP konton.<br />Ändringen genomförs omedelbart så man kan använda det nya/ändrade kontot direkt.',
		'account_add' => '[Skapa ett nytt FTP konto]',
	],
	'index' => [
		'customerdetails' => 'Kunddetaljer',
		'accountdetails' => 'Kontodetaljer',
	],
	'login' => [
		'username' => 'Användarnamn',
		'password' => 'Lösenord',
		'language' => 'Språk',
		'login' => 'Logga in',
		'logout' => 'Logga ut',
		'profile_lng' => 'Profilspråk',
	],
	'mails' => [
		'pop_success' => [
			'mailbody' => 'Hej,\\n\\nDitt E-postkonto {EMAIL}\\nhar nu skapats.\\n\\nDetta är ett automatgenererat E-post meddelande\\n, Det går därför inte att svara på detta meddelande!\\n',
			'subject' => 'E-postkontot är nu skapat',
		],
		'createcustomer' => [
			'mailbody' => 'Hej {FIRSTNAME} {NAME},\\n\\nHär kommer kontoinformationen för ditt konto:\\n\\nAnvändarnamn (Username): {USERNAME}\\nLösenord (Password): {PASSWORD}\\n\\n',
			'subject' => 'Kontoinformation',
		],
		'pop_success_alternative' => [
			'mailbody' => 'Hej,\\n\\nditt E-postkonto {EMAIL}\\nhar ny skapats.\\nDitt lösenord är {PASSWORD}.\\n\\nDetta är ett automatgenererat E-postmeddelande som det INTE går att svara på!\\n\\nLycka till önskar, Froxlor',
			'subject' => 'E-postkontot är nu skapat',
		],
	],
	'menue' => [
		'main' => [
			'main' => 'Huvudsidan',
			'changepassword' => 'Ändra lösenord',
			'changelanguage' => 'Ändra språk',
			'username' => 'Inloggad som: ',
		],
		'email' => [
			'email' => 'E-post',
			'emails' => 'E-post',
			'webmail' => 'WebMail',
		],
		'mysql' => [
			'mysql' => 'MySQL',
			'databases' => 'Databaser',
			'phpmyadmin' => 'phpMyAdmin',
		],
		'domains' => [
			'domains' => 'Domäner',
			'settings' => 'Inställningar',
		],
		'ftp' => [
			'ftp' => 'FTP',
			'accounts' => 'Konton',
			'webftp' => 'WebFTP',
		],
		'extras' => [
			'extras' => 'Extras',
			'directoryprotection' => 'Katalog säkerhet',
			'pathoptions' => 'Inställningar sökväg',
		],
		'traffic' => [
			'traffic' => 'Trafik',
			'current' => 'Nuvarande månad',
		],
	],
	'mysql' => [
		'databasename' => 'Användare/databasnamn',
		'databasedescription' => 'Beskrivning av databasen',
		'database_create' => '[Skapa en ny databas]',
		'description' => 'Här ändras eller skapas MySQL-Databaser.<br />Ändringen sker omedelbart och databasen kan användas direkt.<br />I menyn på vänster sida finns verktyget phpMyAdmin med vilket man enkelt kan ändra i sin databas.<br /><br />För att använda databasen i dina egna php-scripts använd följande inställningar: (Data med kursiv stil <i>italics</i> måste ändras till det du matat in!)<br />Servernamn (Hostname): <b><SQL_HOST></b><br />Användarnamn (Username): <b><i>Databsnamn (Databasename)</i></b><br />Lösenord (Password): <b><i>Lösenordet som du har valt</i></b><br />Databas (Database): <b><i>Databasnamn (Databasename)</i></b>',
	],
	'panel' => [
		'edit' => 'Ändra',
		'delete' => 'Radera',
		'create' => 'Skapa',
		'save' => 'Spara',
		'yes' => 'Ja',
		'no' => 'Nej',
		'emptyfornochanges' => 'Tomt fält = ingen ändring',
		'emptyfordefault' => 'Förvalt värde används om fältet lämnas tommt',
		'path' => 'Sökväg (Path)',
		'toggle' => 'Växla (Toggle)',
		'next' => 'nästa',
		'dirsmissing' => 'Kan inte hitta eller läsa katalogen!',
		'urloverridespath' => 'URL (skriver över sökvägen)',
		'pathorurl' => 'Sökväg eller URL',
		'ascending' => 'Stigande',
		'descending' => 'Fallande',
		'search' => 'Sök',
		'used' => 'använd',
		'translator' => 'Översättare',
		'reset' => 'Avbryt ändringarna',
		'pathDescription' => 'Katalogen kommer att skapas om den inte redan finns.',
		'back' => 'Tillbaka',
	],
	'question' => [
		'question' => 'Säkerhetsfråga',
		'admin_customer_reallydelete' => 'Är du säker på att du vill radera kunden %s? Om du väljer att radera går det inte att ångra sig efteråt!',
		'admin_domain_reallydelete' => 'Är du riktigt säker på att du vill radera domänen %s?',
		'admin_domain_reallydisablesecuritysetting' => 'Är du riktigt säker på att du vill avaktivera säkerhetsinställningarna (OpenBasedir and/or SafeMode)?',
		'admin_admin_reallydelete' => 'Är du riktigt säker på att du vill radera adminkontot %s? Alla kunder och domäner kommer att flyttas till ditt konto istället.',
		'admin_template_reallydelete' => 'Är du riktigt säker på att du vill radera mallen \'%s\'?',
		'domains_reallydelete' => 'Är du riktigt säker på att du vill radera domänen %s?',
		'email_reallydelete' => 'Är du riktigt säker på att du vill radera E-postadressen %s?',
		'email_reallydelete_account' => 'Är du riktigt säker på att du vill radera E-postkontot %s?',
		'email_reallydelete_forwarder' => 'Är du riktigt säker på att du vill radera forwardern till %s?',
		'extras_reallydelete' => 'Är du riktigt säker på att du vill radera katalogsäkerheten (directory protection) för %s?',
		'extras_reallydelete_pathoptions' => 'Är du riktigt säker på att du vill radera katalogalternativen (path options) för %s?',
		'ftp_reallydelete' => 'Är du riktigt säker på att du vill radera FTP kontot %s?',
		'mysql_reallydelete' => 'Är du riktigt säker på att du vill radera databasen %s? Om du väljer att radera går det inte att ångra sig efteråt!',
		'admin_configs_reallyrebuild' => 'Är du riktigt säker på att du vill skapa nya konfigurationsfiler för apache och bind?',
		'admin_ip_reallydelete' => 'Är du säker på att du vill radera IP addressen %s?',
		'admin_domain_reallydocrootoutofcustomerroot' => 'Dokumentkatalogen för denna domän inte kommer att ligga under kundkatalogen, är du säker på att du vill ändra detta?',
		'admin_counters_reallyupdate' => 'Vill du uppdatera alla statusberäkningar för kunder och admins?',
		'admin_cleartextmailpws_reallywipe' => 'Är du säker på att du vill radera alla okrupterade lösenord från tabellen mail_users? Du kan INTE ändra dig efteråt!',
	],
	'serversettings' => [
		'session_timeout' => [
			'title' => 'Sessionen har avslutats för att den tog för lång tid att utföra (session Timeout)',
			'description' => 'Tiden (i sekunder) som användaren får vara inaktiv innan han måste logga in igen är (seconds)?',
		],
		'accountprefix' => [
			'title' => 'Kund ID (Customer prefix)',
			'description' => 'Vilket prefix skall användas till ett kundkonto?',
		],
		'mysqlprefix' => [
			'title' => 'SQL ID (SQL Prefix)',
			'description' => 'Vilket prefix skall användas till mysql?',
		],
		'ftpprefix' => [
			'title' => 'FTP ID (FTP Prefix)',
			'description' => 'Vilket prefix skall användas till ftp?',
		],
		'documentroot_prefix' => [
			'title' => 'Hemkatalog',
			'description' => 'Vilken sökväg skall det vara till hemkatalogen?',
		],
		'logfiles_directory' => [
			'title' => 'Loggfilernas hemkatalog (Logfiles directory)',
			'description' => 'Vilken sökväg skall det vara till loggfilernas hemkatalog?',
		],
		'ipaddress' => [
			'title' => 'IP-Adress',
			'description' => 'Vilken IP-adress har denna server?',
		],
		'hostname' => [
			'title' => 'Datornamn (Hostname)',
			'description' => 'Villket Datornamn (Hostname) har denna server?',
		],
		'apachereload_command' => [
			'title' => 'Ladda om Apache kommandot (Apache reload)',
			'description' => 'Ange sökvägen till programmet som laddar om Apache (reload apache) konfigurationsfiler?',
		],
		'bindconf_directory' => [
			'title' => 'Bind konfigurationskatalog (Bind config directory)',
			'description' => 'Vilken sökväg skall det vara till bind:s konfigurationsfiler?',
		],
		'bindreload_command' => [
			'title' => 'Ange sökvägen till programmet som laddar om Bind (reload bind) konfigurationsfiler?',
			'description' => 'Ange sökvägen till programmet som laddar om Bind (reload bind) konfigurationsfiler?',
		],
		'vmail_uid' => [
			'title' => 'Mails-UID',
			'description' => 'Vilket användarID (UserID) ska E-posten ha?',
		],
		'vmail_gid' => [
			'title' => 'Mails-GID',
			'description' => 'Vilket gruppID (GroupID) ska E-posten ha?',
		],
		'vmail_homedir' => [
			'title' => 'E-post hemkatalog',
			'description' => 'I vilken katalog skall E-posten sparas?',
		],
		'adminmail' => [
			'title' => 'Avsändare',
			'description' => 'Vilken avsändaradress skall E-post från admin panelen ha?',
		],
		'phpmyadmin_url' => [
			'title' => 'phpMyAdmin URL',
			'description' => 'Vilken URL är det till phpMyAdmin? (Måste börja med http(s)://)',
		],
		'webmail_url' => [
			'title' => 'WebMail URL',
			'description' => 'Vilken URL är det till WebMail? (Måste börja med http(s)://)',
		],
		'webftp_url' => [
			'title' => 'WebFTP URL',
			'description' => 'Vilken URL är det till  WebFTP? (Måste börja med http(s)://)',
		],
		'language' => [
			'description' => 'Vilket språk skall användas som standardspråk?',
		],
		'maxloginattempts' => [
			'title' => 'Max antal Login försök',
			'description' => 'Maximalt antal inloggningsförsök innan kontot stängs av.',
		],
		'deactivatetime' => [
			'title' => 'Avstängningstid',
			'description' => 'Tid (sec.) som kontot stängs av efter för många felaktiga försök.',
		],
		'pathedit' => [
			'title' => 'Typ av (path input)',
			'description' => 'Skall en sökväg väljas i en rullist eller matas in för hand?',
		],
		'nameservers' => [
			'title' => 'Nameservers',
			'description' => 'En kommaseparerad lista med namnet (hostname) på alla DNS:er. Den första blir den första som söks (primary).',
		],
		'mxservers' => [
			'title' => 'MX servers',
			'description' => 'En kommaseparerad lista med nummer och namn separerade men mellanslag (ex. \'10 mx.example.com\') innehåller mx servrarna.',
		],
		'paging' => [
			'title' => 'Antal rader per sida',
			'description' => 'Hur många rader skall det vara på en sida? (0 = Stäng av sidbrytning)',
		],
		'defaultip' => [
			'title' => 'Förvald IP/Port',
			'description' => 'Vilken är den förvalda IP/Port kombinationen?',
		],
		'phpappendopenbasedir' => [
			'title' => 'Sökväg att lägga till OpenBasedir',
			'description' => 'Dessa sökvägar (separerade med kolon) kommer att läggas till OpenBasedir-statement i alla  vhost-container.',
		],
		'natsorting' => [
			'title' => 'Använd mänsklig sortertering i listvisning',
			'description' => 'Sorterar listan så här web1 -> web2 -> web11 istället för web1 -> web11 -> web2.',
		],
		'deactivateddocroot' => [
			'title' => 'Dokumentroot för avstängda användare',
			'description' => 'När en användare är avstängd kommer denna sökväg att användas som dokumentroot. Lämna fältet tommt om du inte vill skapa någon vhost.',
		],
		'mailpwcleartext' => [
			'title' => 'Spara även lösenord till E-postkonton okrypterade i databassen',
			'description' => 'Om du valt Ja så kommer alla lösenord att sparas okrypterade (klartext, fullt läsbara för alla som har rättigheter till databasen) i tabellen mail_users-table. Aktivera detta endast om du är säker på vad du gör!',
			'removelink' => 'Klicka här för att radera alla okrypterade lösenord från tabellen.',
		],
		'ftpdomain' => [
			'title' => 'FTP konton @domain',
			'description' => 'Kunder kan skapa Ftp accounts user@customerdomain?',
		],
		'mod_fcgid' => [
			'title' => 'Inkludera PHP via mod_fcgid/suexec',
			'description' => 'Använd mod_fcgid/suexec/libnss_mysql för att köra PHP med tillhörande användarkonto.<br/><b>Denna inställning behöver en speciell apache-konfiguration!</b>',
			'configdir' => [
				'title' => 'FCGI konfigurationskatalog',
				'description' => 'I vilken katalog skall alla fcgi-konfigurationfiler lagras?',
			],
			'tmpdir' => [
				'title' => 'FCGI temporärkatalog',
			],
		],
		'sendalternativemail' => [
			'title' => 'Använd en alternativ E-postadress',
			'description' => 'Skicka lösenord med E-post till adressen under email-account-creation',
		],
		'apacheconf_vhost' => [
			'title' => 'Apache vhost konfiguration fil/katalognamn',
			'description' => 'Var skall vhost konfigurationen sparas? Det går att specificera alla vhost i en fil eller en katalog där alla filerna ligger (varje vhost i sin egen fil).',
		],
		'apacheconf_diroptions' => [
			'title' => 'Apache diroptions konfiguration fil/katalognamn',
			'description' => 'Var skall diroptions konfigurationen sparas? Det går att specificera alla diroptions i en fil eller en katalog där alla filerna ligger (varje diroptions i sin egen fil).',
		],
		'apacheconf_htpasswddir' => [
			'title' => 'Apache htpasswd katalognamn',
			'description' => 'Var skall htpasswd konfigurationen för katalogsäkerheten?',
		],
		'mysql_access_host' => [
			'description' => 'En kommaseparerad lista med datornamn som tillåts att kontakta MySQL servern.',
		],
	],
	'traffic' => [
		'month' => 'Månad',
		'day' => 'Dag',
		'months' => [
			1 => 'Januari',
			2 => 'Februari',
			3 => 'Mars',
			4 => 'April',
			5 => 'Maj',
			6 => 'Juni',
			7 => 'Juli',
			8 => 'Augusti',
			9 => 'September',
			10 => 'Oktober',
			11 => 'November',
			12 => 'December',
		],
		'mb' => 'Trafik (MB)',
		'distribution' => '<font color="#019522">FTP</font> | <font color="#0000FF">HTTP</font> | <font color="#800000">Mail</font>',
		'sumhttp' => 'Summa HTTP-Trafik i',
		'sumftp' => 'Summa FTP-Trafik i',
		'summail' => 'Summa E-posttrafik i',
	],
	'translator' => 'Staffan Starberg',
];
