<!-- ![image](https://user-images.githubusercontent.com/45481137/135516948-f8abd486-f6f3-4039-b1ca-21e09bc3d4f7.png) -->

# Curated Project List

  [![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)  [![Open Source Love svg1](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/) [![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)  ![first-timers-only](https://img.shields.io/badge/first--timers--only-friendly-yellow.svg?style=flat) ![contributions welcome](https://img.shields.io/static/v1.svg?label=Contributions&message=Welcome&color=0059b3&style=flat-square) ![Maintenance](https://img.shields.io/maintenance/yes/2021)

<!-- ![GitHub contributors](https://img.shields.io/github/contributors-anon/friskycodeur/curated-project-list)  -->

<!-- TABLE OF CONTENTS -->
<details open="open">
  <summary>Table of Contents</summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
      <ul>
        <li><a href="#built-with">Built With</a></li>
      </ul>
    </li>
    <li>
      <a href="#create-an-issue"> Create an Issue
    </li>
    <li>
      <a href="#getting-started">Getting Started</a>
    </li>
<!--     <li>
      <a href="#implemented-projects">Implemented Projects</a>
    </li> -->
    <li><a href="#best-way-to-learn">Best way to learn</a></li>
    <li><a href="#contributing">Contributing</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#contributor-showcase">Contributor Showcase </a></li>
  </ol>
</details>


<!-- ABOUT THE PROJECT -->
## About The Project

The goal of this project is to provide beginners with a list of projects along with proper implementation to help them improve and learn through Project-based-learnings.  Contibuting to this repository and adding new projects will help beginners to learn concepts and amateurs to revise them , so feel free to contribute in any way you want, just make sure to follow the contribution guidelines.

### Built With

Current projects on this list are build with :
* JavaScript
* HTML5
* CSS
* Python

## Create an Issue

- Want to work on a new project or have an idea in mind , but can't find it here? Then head over to the issue section and create an issue regarding your project idea.
- Don't forget to elaborate about the details such as , what the project is about , in which language you're going to built it , etc.


<!-- GETTING STARTED -->


## Getting Started

Choose a projects you want to work on. Read about the idea and details in the readme. Start working on it , explore and learn new concepts along the way.

<!-- ## Implemented Projects

- [Glasses of Water Counter](https://github.com/friskycodeur/curated-project-list/tree/main/JavaScript/Glasses-of-Water-Counter-App)
- [CountDown Timer](https://github.com/friskycodeur/curated-project-list/tree/main/JavaScript/Countdown-Timer)
- [Color Flipper](https://github.com/friskycodeur/curated-project-list/tree/main/JavaScript/Color-flipper) -->

<!-- USAGE EXAMPLES -->

## Best Way to Learn

The best way to work on this project is :

* Select the project you want to work on.
* Get a good grasp of the idea and what we are trying to create.
* Read about the concepts used.
* With both the above points done , try to make the project on your own.
* Give it some try and take help from the code in this repository.

## Contributing

### Step 1. Create a Copy of this Repository
In order to work on an open-source project, you will first need to make your own copy of the repository. To do this, you should fork the repository and then clone it so that you have a local working copy.

> **Fork :fork_and_knife: this repo. Click on the Fork button at the top right corner.**

With the repository forked, you’re ready to clone it so that you have a local working copy of the code base.

> **Clone the Repository**

To make your own local copy of the repository you would like to contribute to, let’s first open up a terminal window.

We’ll use the git clone command along with the URL that points to your fork of the repository.

* Open the Command Prompt
* Type this command:

```
git clone https://github.com/your_username/curated-project-list
```




### Step 2: Creating a New Branch
It is important to branch the repository so that you are able to manage the workflow, isolate your code, and control what features make it back to the main branch of the project repository.

When creating a branch, it is very important that you create your new branch off of the master branch. 
**To create a new branch, from your terminal window, follow:**


```
git branch new-branch
git checkout new-branch
```
Once you enter the git checkout command, you will receive the following output:

```
Switched to branch 'new-branch'
```


### Step 3: Contribute
Make relevant changes. Add/Update the projects you want to work on, and update the files in the right folders. 
      

### Step 4: Commiting and Pushing:
Once you have modified an existing file or added a new file to the project, you can add it to your local repository, which we can do with the git add command.

``` git add filename``` or ``` git add .``` 

You can type the command ```git add -A``` or alternatively ```git add -all``` for all new files to be staged.


**With our file staged, we’ll want to record the changes that we made to the repository with the ```git commit``` command.**
<p> The commit message is an important aspect of your code contribution; it helps the other contributors fully understand the change you have made, why you made it, and how significant it is.  </p>
 
 ```
 git commit -m "commit message"
 ```
 
 
 At this point you can use the ```git push``` command to push the changes to the current branch of your forked repository:
 ```
 git push --set-upstream origin new-branch
 ```
 
### Step 6: Create Pull Request
At this point, you are ready to make a pull request to the original repository.

You should navigate to your **forked** repository, and press the “Compare & pull request” button on the page. 

GitHub will alert you that you are able to merge the two branches because there is no competing code. You should add in a **title**, a **comment**, and then press the **“Create pull request”** button.


### Step 7: CONGRATULATIONS :boom: :clap: :smile:
You have made it till the end. Kudos to you!!

<hr> </hr>


#### Please see the <a href="https://github.com/friskycodeur/curated-project-list/blob/main/CONTRIBUTING.md"> **Contributing Guidelines** </a>.

<!-- CONTACT -->
## Contact

Need any help , you can [mail me here](mailto:friskycodeur@gmail.com)

## Please STAR :star2: this repository if you liked it and had fun :)

### Maintainers! :wink:

<table>
  <tbody><tr>
    <td align="center"><a href="https://github.com/friskycodeur"><img alt="" src="https://avatars.githubusercontent.com/friskycodeur" width="100px;"><br><sub><b>Prateek Maheshwari</b></sub></a><br><a href="https://github.com/geekquad/AlgoBook/commits?author=vlx01" title="Code">💻 🖋</a></td></a></td>
    <td align="center"><a href="https://github.com/rachit-geek"><img alt="" src="https://avatars.githubusercontent.com/rachit-geek" width="100px;"><br><sub><b>Rachit Goyal</b></sub></a><br><a href="https://github.com/geekquad/AlgoBook/commits?author=geekquad" title="Code">💻 🖋</a></td> </a></td>
  </tr>
</tbody></table>

## Community
Join us on the Discussion tab to get help in contributing, as well as stay up-to-date on issues and best practices.

## Contributor Showcase
<a href="https://github.com/friskycodeur/curated-project-list/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=friskycodeur/curated-project-list" />
</a>

<!-- <h1> Let's Connect 😃</h1>
<div>
<div align="center">
<a href="https://stackoverflow.com/users/14524669" target="_blank">
<img src=https://img.shields.io/badge/stackoverflow-%23F28032.svg?&style=for-the-badge&logo=stackoverflow&logoColor=white alt=stackoverflow style="margin-bottom: 5px;" />
</a>
<a href="https://linkedin.com/in/friskycodeur" target="_blank">
<img src=https://img.shields.io/badge/linkedin-%231E77B5.svg?&style=for-the-badge&logo=linkedin&logoColor=white alt=linkedin style="margin-bottom: 5px;" />
</a>
<a href="https://www.facebook.com/2310prateek/" target="_blank">
<img src=https://img.shields.io/badge/facebook-%232E87FB.svg?&style=for-the-badge&logo=facebook&logoColor=white alt=facebook style="margin-bottom: 5px;" />
</a>
<a href="https://medium.com/@friskycodeur" target="_blank">
<img src=https://img.shields.io/badge/medium-%23292929.svg?&style=for-the-badge&logo=medium&logoColor=white alt=medium style="margin-bottom: 5px;" />
</a>  
<a href="https://dev.to/friskycodeur" target="_blank">
<img alt="Dev.to blog" src=https://img.shields.io/badge/dev.to-0A0A0A?style=for-the-badge&logo=dev.to&logoColor=white alt=medium style="margin-bottom: 5px;"/ >
</a>
<a href="https://twitter.com/moodyarrow" target="_blank">
<img alt="Dev.to blog" src=https://img.shields.io/badge/Twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white alt=medium style="margin-bottom: 5px;"/ >
</a>
</div> -->


