# Frideos library examples

This repository contains example apps to show how to use the [frideos](https://pub.dartlang.org/packages/frideos) package: 

  1 - [**Counter**](https://github.com/frideosapps/frideos_examples/tree/master/01_counter): a classic counter example

  2 - [**Basics**](https://github.com/frideosapps/frideos_examples/tree/master/02_basics) : an example app that shows how to use the StreamedObjects (StreamedValue, StreamedList, StreamedMap etc.)

  3 - [**Various**](https://github.com/frideosapps/frideos_examples/tree/master/03_various): how to use TimerObject, AnimatedObject, blur widgets, transitions widgets, StagedWidget, sliders.

  4 - [**StagedObject**](https://github.com/frideosapps/frideos_examples/tree/master/04_staged_object): StagedObject and the tunnel pattern (to share send data from one bloc to another one)

  5 - [**Multiple selection**](https://github.com/frideosapps/frideos_examples/tree/master/05_multiple_selection)

  6 - [**Products catalog**](https://github.com/frideosapps/frideos_examples/tree/master/06_products_catalog)

  7 - [**Dynamic fields validation**](https://github.com/frideosapps/frideos_examples/tree/master/07_dynamic_fields_validation): an example on how to validate dynamically created fields with the BLoC pattern and the [frideos](https://pub.dartlang.org/packages/frideos) package. Article on medium [here](https://medium.com/flutter-community/flutter-how-to-validate-fields-dynamically-created-40cafca5c3cb).


## Screenshots

![Screenshot](screenshots/streamed.png?s=150)
![Screenshot](screenshots/streamedlist.png?s=150)
![Screenshot](screenshots/streamedmap.png?s=150)
![Screenshot](screenshots/dynamicfields.png?s=150)
![StagedWidget](https://i.imgur.com/nCsbJCy.gif)
![StagedObject](https://i.imgur.com/9XLb7JD.gif)
![Blur](https://i.imgur.com/A7XmY5t.gif?s=150)
![LinearTransition](https://i.imgur.com/viGPpCu.gif)
![CurvedTransition](https://i.imgur.com/kxWOKMU.gif)
![AnimatedObject](https://i.imgur.com/10nfh0R.gif)
![MultipleSelection](https://i.imgur.com/nGLRiCY.gif)
![Sliders](https://i.imgur.com/H16VE01.gif)

