# 真·三十天
## 完全控制二进制文件

欢迎来到真三第四个视频

这个视频算是正式开始讲述有关我们自己操作系统的内容了

所谓工欲善其事必先利其器

这个视频主要会向大家介绍我们要用到的一些二进制文件相关的知识和工具

为什么要先讲二进制文件呢

这要从x86架构pc机的启动说起

上个视频说过，cpu工作的方式是取指令->执行

指令是从内存中取得的

但是在刚刚上电的时候，内存中并没有数据，那么第一条指令是从哪来的呢

在x86体系下bios的厂商和系统开发者之间有一个约定

实际上上电之后最先运行的程序不是我们自己操作系统代码的第一行指令

而是主板上某个芯片的只读存储器中的一段代码，这段代码一般回去检测各个基本的硬件是否能够正常工作

当检测完成之后，会从我们指定的装载操作系统代码的介质中读取头512字节的数据

并且检测512字节的最后两个字节是不是一个约定好的值

把这512字节的数据放入0x7c00这个地址

并跳转到这里

至此，我们的代码获取了控制权

这512字节就是著名的引导扇区，《源码》《orange》《自己动手》里面都有非常详细的资料，推荐详细阅读一下

---

当然，512字节能够承载的逻辑非常少，所以这512字节要做的最关键的任务就是，把我们存储介质上之后的数据读入到内存的某一个地址

然后跳转过去执行

说到这里我们要精确的了解下面两件事情

1.二进制文件在磁盘上的布局
2.二进制文件被加载到内存之后的布局

这两件事情会影响我们编写程序时候如何指定符号的内存偏移

说得太抽象，举个例子

我们的操作系统二进制文件在磁盘上是这样摆放的

首先是512字节的引导扇区代码，紧跟着的是比如10个扇区大小的操作系统代码

512字节的代码在被移动到0x7c00这个地址，然后它把剩下10个扇区的地址一顿折腾，最后折腾到了0地址处，然后从0地址出开始执行

这时才是进入我们系统的主逻辑

这时你会发现，虽然这10个扇区在磁盘上是从第二个扇区开始摆放，但是代码里的符号都知道自己会被加载到0地址处，所以都以0地址作为相对偏移

而躺在磁盘第一个扇区的512字节，虽然在磁盘上很靠前，但是它知道自己将会被加载到0x7c00处，所以自己所有的符号偏移都加上了0x7c00

所以说找准自己的定位很重要，找准的自己的定位，做的事情才能符合自己的身份

---

说到这里我们会发现操作系统这部分的代码有一个非常明显的特点，就是要求二进制文件的布局要精确

当我在用c语言写一个应用程序的时候，我们不太在意一个函数的具体地址是多少，只要求编译器能够帮助我们把编译后的正确地址放到调用函数的地方

但是在写操作系统代码的时候，我们在许多情况下要求某个函数必须存在某处，某处的某几个字节必须是某个值

这时候c语言直接编译出的程序就无法胜任这样的功能了

这就是为什么操作系统的编写为什么要用到汇编语言，因为它虽然表达高级语意能力有限，但是可以精确的表达细节

比如使用nasm时，我们想要第一个扇区的最后两个字节是固定的值，我们可以这样写（展示例子）

---

但是c语言写的逻辑相比汇编确实非常易懂，我在抠linux0.12代码的时候，会把一些汇编程序改写为c程序，虽然性能不及汇编

但是可读性增强，便于学习

比如初始化页表这个例子(对比0.12 head.s 198行 与 lanOS mm.c 15行)

所以c语言合适的场景是，在对二进制布局不敏感的逻辑中使用

---

再说一下我们编译出来的操作系统镜像和正常用c编译器编译出来的二进制文件的区别

一般我们写的c程序是通过gcc编译和ld链接的，这里推荐《程序员自我修养》这本书

当我们在操作系统的shell环境下运行一个程序的时候，操作系统要知道以下几件事情才能正确的运行程序

1.你的入口函数躺在磁盘什么位置（相对于文件开始地址）
2.你的入口函数要加载到内存什么位置

这时大家可能会问，为什么不让在磁盘上躺着的位置和在内存的位置一致呢，这样不就简单很多

我们考虑这样一个场景，一个main函数要使用一个字符串的空间，但是这个字符串是用户的输入的

那么我们在内存中一定要给这个字符串留出一个空间，但是需要在磁盘上留出空间存储它吗，显然不用，因为是用户输入的啊

所以，函数或者说符号，这里包括函数名，变量名，在磁盘上的偏移和在内存中的偏移很可能是不一样的

所以一个可执行文件都会有头来包含这些信息（这里是一个重点，我们的操作系统镜像是要去掉这个头的）

---

而当我们把自己的汇编程序编译出的.o和c编译出的.o文件链接在一起之后

我们知道自己即将运行的环境是一个裸机的环境，没有人帮你解析你的入口在哪

因为没人帮你解析位置，刚才所说的那套机制也就失灵了，所以最简单的做法是什么呢

就是我们让代码躺在磁盘上的偏移和内存中的偏移强行保持一致

这里我们让他们都从0地址开始，这样的好处是所有的偏移都不用重新计算了

所以这里很明显有一个障碍，就是ld帮我们生成的文件头，我们看一下如何去掉它

演示objdump和readelf dd

~~我们还需要把我们的代码段强制放~~

---

~~到这里大家如果有没听明白的，请回忆以下cpu的运行机制，取指令->执行~~

---

假设我们已经去掉了头，那么剩下的二进制程序就可以正常运行了吗

要回答这个问题我们来思考以下这个程序所处的角色是什么

首先，在我们的系统镜像中，这个程序应该是从第二个扇区开始存放的

第一个扇区是引导扇区，会被bios加载到0x7c00处

根据我们的计划，引导扇区会把从第二个扇区到末尾的数据加载到内存0地址处

这里就是我们刚才计划好的那个文件，这个文件的特征是，在磁盘上的布局和在内存中的布局是一模一样的

在引导扇区的逻辑的最后，会跳转到0地址处开始执行

所以，所以，0地址放的内容必须是代码而非数据

而链接器不一定会把代码放在低地址处，而可能是先把一些常量数据放在这里，这样就不符合我们的要求了

所以我们必须规定链接器的行为，要求它把代码段放到低地址

这里我们使用链接器脚本（演示）

---

现在我们先介绍一下汇编和c混合编程的demo

之后我们会以这个demo为基础，来解决我们刚才提出的两个问题

1. 如何去掉头
2. 如何规定链接器的行为