#ifndef SCHED_H
#define SCHED_H

#define NR_TASKS 8
#define TASK_SIZE 4 * 1024 * 1024  //每个进程4M，总共64M，16个进程

typedef struct desc_struct {
  unsigned long a, b;
} desc_table[256];

extern desc_table gdt;
extern desc_table idt;

#define TASK_RUNNING 0
#define TASK_INTERRUPTIBLE 1
#define TASK_UNINTERRUPTIBLE 2
#define TASK_ZOMBIE 3
#define TASK_STOPPED 4

struct task_struct {
  unsigned long kernel_stack;
  long state; /* -1 unrunnable, 0 runnable, >0 stopped */
  long counter;
  long priority;
  long signal;
  long pid;
  unsigned long start_code;
  unsigned long end_data;
  unsigned long fs_index;
  struct desc_struct ldt[3];
};

#define _set_tssldt_desc(n, addr, type)                                      \
  __asm__(                                                                   \
      "movw $104,%1\n\t"                                                     \
      "movw %%ax,%2\n\t"                                                     \
      "mov %%eax, %%ebx\n\t"                                                 \
      "rorl $16,%%ebx\n\t"                                                   \
      "movb %%bl,%3\n\t"                                                     \
      "movb $" type                                                          \
      ",%4\n\t"                                                              \
      "movb $0x00,%5\n\t"                                                    \
      "movb %%bh,%6\n\t" ::"a"(addr),                                        \
      "m"(*(n)), "m"(*(n + 2)), "m"(*(n + 4)), "m"(*(n + 5)), "m"(*(n + 6)), \
      "m"(*(n + 7))                                                          \
      : "%eax", "%ebx")

#define FIRST_TSS_ENTRY 4
#define FIRST_LDT_ENTRY (FIRST_TSS_ENTRY + 1)
#define _LDT(n) (((unsigned long)n + FIRST_LDT_ENTRY) << 3)
#define lldt(n) __asm__("lldt %%ax" ::"a"(_LDT(n)))

#define _set_limit(addr, limit)      \
  __asm__(                           \
      "movw %%dx,%0\n\t"             \
      "rorl $16,%%edx\n\t"           \
      "movb %1,%%dh\n\t"             \
      "andb $0xf0,%%dh\n\t"          \
      "orb %%dh,%%dl\n\t"            \
      "movb %%dl,%1" ::"m"(*(addr)), \
      "m"(*((addr) + 6)), "d"(limit) \
      : "dx")

#define set_limit(ldt, limit) _set_limit(((char*)&(ldt)), (limit - 1) >> 12)

#define get_limit(segment)                                           \
  ({                                                                 \
    unsigned long __limit;                                           \
    __asm__("lsll %1,%0\n\tincl %0" : "=r"(__limit) : "r"(segment)); \
    __limit;                                                         \
  })

extern struct task_struct* task[NR_TASKS];
extern int task_used[NR_TASKS];
extern struct task_struct* current;
extern void sched_init();
extern void set_ldt_desc(char* n, char* addr);
extern void set_base(char* n, char* addr);

#endif