using GitObjectDb;
using GitObjectDb.Model;
using System.Collections.Generic;

namespace Models.Software;

/// <summary>Represents a table containing several fields.</summary>
[GitFolder(FolderName = "Pages")]
[HasChild(typeof(Field))]
[HasChild(typeof(Constant))]
public record Table : Node
{
    /// <summary>Gets the name of the table.</summary>
    public string? Name { get; init; }

    /// <summary>Gets the description of the table.</summary>
    public string? Description { get; init; }

    /// <summary>Gets long text value stored in separate blob.</summary>
    [StoreAsSeparateFile(Extension = "someextension")]
    public string? LongTextStoredInSeparateBlob { get; init; }
}

public static class IConnectionTableExtensions
{
    public static IEnumerable<Table> GetTables(this IConnection connection, Application application, string committish = "main") =>
        connection.GetNodes<Table>(committish, application);
}
