import React from 'react'
import { DovetailData, getDovetailPath } from './dovetails'

type DovetailSVGProps = React.ComponentProps<'section'> & {
  data: DovetailData
}

export const DovetailSVG: React.FC<DovetailSVGProps> = ({ data, ...props }) => {
  const path = getDovetailPath(data)
  return (
    <figure {...props}>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        viewBox={`0 0 ${data.w} ${3 * data.tp}`}
      >
        <defs>
          <clipPath id="tails">
            <path
              // Tail board
              d={path}
            />
          </clipPath>
        </defs>
        <rect
          // Pins board endgrain
          x={0}
          y={0}
          width={data.w}
          height={data.tp}
          fill="saddlebrown"
        />
        <g clipPath="url(#tails)">
          <rect
            // Summer rings
            x={0}
            y={0}
            width={data.w}
            height={3 * data.tp}
            fill="#f0d8b4"
          />
          <path
            // Winter rings
            // Source: https://freesvg.org/light-wood-texture
            d="M2.25323 170.388C2.91022 126.034 7.27813 81.6589 3.73745 37.3192C3.08124 21.6796 2.44155 6.10595 2.28102 -9.54414C6.9094 2.98232 3.8952 16.3273 5.43395 29.2311C5.67064 63.3515 8.94288 97.5552 5.12778 131.602C4.21142 144.789 3.62418 157.998 3.6297 171.214C2.58636 174.438 1.59242 171.916 2.25321 170.39L2.25323 170.388ZM16.0025 161.36C14.7581 116.234 12.4749 71.0146 16.1391 25.9355C16.1752 14.0864 15.5915 2.21514 16.623 -9.61235C16.7796 31.9881 17.9055 68.8858 15.5182 108.339C18.1177 132.022 15.6351 144.9 18.7859 164.199C19.2531 172.176 13.8863 171.196 16.0089 163.991L16.0305 162.674L16.0025 161.36ZM20.1119 173.027C18.2611 109.402 18.5649 53.4382 20.0394 -5.10694C25.8277 -6.5206 20.462 6.76076 22.0995 10.7467C17.1638 66.8901 24.3333 119.433 22.7901 171.53C22.4231 172.466 21.333 173.52 20.1119 173.028L20.1119 173.027ZM24.826 170.604C26.6289 156.463 25.7239 142.229 23.9883 128.138C21.5594 96.033 21.3829 63.8167 23.2641 31.6865C23.838 19.406 23.2543 6.71437 25.4401 -5.27574C27.5022 1.44969 25.055 9.74538 25.1101 17.0994C24.5034 26.0086 24.0333 34.9462 24.5058 43.8709C26.6 26.9442 25.2084 9.77769 28.2323 -7.07073C27.6428 17.0603 24.8463 41.1174 24.9313 65.2778C24.4072 91.7441 26.5357 118.183 29.8634 144.447C30.3643 152.304 30.0556 166.057 28.8894 170.238C28.1202 157.63 30.2587 144.918 27.5072 132.418C22.3097 1.39873 22.7826 72.8928 27.6407 154.941C27.4723 158.854 28.7287 171.117 24.826 170.603V170.604ZM22.5259 83.1056C21.3155 83.7576 23.797 83.8656 22.5259 83.1056V83.1056ZM35.7917 173.282C37.5239 145.363 36.8784 117.375 38.304 89.4419C29.3428 67.8877 32.778 44.4417 34.1097 22.008C37.5235 13.8049 30.8467 -4.75771 38.8865 -6.40263C40.6601 7.9583 36.01 22.8965 41.7909 36.8708C46.4779 46.0101 47.1829 56.0401 46.7981 66.0044C44.8902 86.2619 48.2434 111.769 51.2136 134.494C52.445 144.562 52.2077 154.677 53.2344 164.746C53.6744 169.688 48.5755 173.782 49.6902 166.213C48.9349 155.615 50.8244 144.737 48.4847 134.31C40.4121 133.51 44.2134 147.444 42.0925 152.939C40.6186 159.709 41.8083 168.869 37.3636 174L36.4677 173.747L35.7927 173.284L35.7917 173.282ZM40.8476 170.783C43.4232 164.335 41.0617 146.771 47.4781 147.015C48.7699 153.703 49.2521 166.339 47.1699 169.517C46.645 165.291 50.6052 151.687 44.3333 153.742C43.4959 158.847 44.5815 165.452 40.8477 170.783H40.8476ZM53.4527 171.77C56.1847 144.31 51.7095 116.901 48.5742 89.6501C47.239 74.1723 47.3044 58.6156 48.1985 43.117C47.6995 37.1278 34.9534 28.3644 46.9048 28.2279C50.6276 19.9445 46.2729 10.719 47.369 2.02337C50.4193 -11.8425 44.057 14.1535 51.28 10.3101C51.6593 6.06244 53.8011 -9.73232 52.7291 2.26928C48.0389 41.1127 45.9396 80.6777 53.7112 119.313C55.1431 133.317 55.1474 147.398 56.1154 161.43C53.053 164.104 56.7057 169.612 53.4528 171.773L53.4527 171.77ZM55.657 172.219C58.7555 163.195 55.7215 153.499 59.5823 144.795C60.7934 139.782 56.1683 125.153 58.9193 125.382C61.3629 140.68 60.5876 156.376 57.1407 171.424C56.9594 172.127 56.2535 172.067 55.6569 172.218L55.657 172.219ZM59.6089 173.206C62.6134 163.836 61.3533 153.871 64.0576 144.629C62.142 112.928 54.2916 81.2126 54.941 51.5343C56.1995 40.9533 51.5653 29.9267 56.605 19.7194C57.758 11.6642 54.831 1.52903 58.707 -4.85895C64.6494 -13.8536 60.2335 3.43135 59.9787 6.71078C56.6834 32.1335 59.249 49.0149 58.6598 83.3924C65.6974 107.05 67.2409 131.283 65.9699 153.914C64.9685 158.413 64.0961 174.699 59.6086 173.205L59.6089 173.206ZM74.5858 170.873C76.8856 141.225 77.821 111.337 74.0293 81.7557C72.8934 89.4235 66.617 88.6772 67.6155 81.2147C64.273 65.1748 60.8237 48.452 65.8792 32.3661C68.4387 21.6964 72.3838 11.2151 72.9987 0.226952C71.3539 3.19226 67.2551 16.8377 69.7444 6.70791C68.3972 2.55504 75.9992 -12.064 75.3353 -1.1218C74.5073 2.21712 71.6217 15.3644 74.5665 13.1465C75.5907 6.03659 74.2801 -11.901 87.1016 -6.66326C88.3363 6.13998 88.9001 19.0032 92.5183 31.4621C92.3926 40.2109 93.3443 52.1644 87.5506 58.7469C84.3247 52.3977 87.9772 42.3756 82.4599 37.7891C75.1455 49.4267 80.772 55.4542 79.6506 75.9504C73.9877 110.155 89.0565 139.83 82.018 171.727C80.4816 164.593 81.33 175.491 79.4882 168.612C78.2548 158.642 81.3073 148.513 77.6738 138.7C76.9194 149.399 80.6367 160.739 76.4039 171.123C74.1721 173.901 74.5323 173.622 74.5857 170.87L74.5858 170.873ZM75.3709 171.778C74.1604 172.43 76.642 172.538 75.3709 171.778V171.778ZM78.1229 105.952C78.2416 91.4425 76.3478 72.9129 75.1095 56.3714C72.6271 59.3859 72.2288 74.1823 68.558 63.8087C63.438 52.2016 69.2518 39.9897 73.1124 28.8698C75.0215 24.3547 70.2737 20.2933 70.7673 27.0169C67.5987 39.0132 64.1841 51.4621 66.5276 63.8571C64.1667 71.6068 74.7314 75.974 74.843 68.1504C77.4102 75.8566 75.9265 84.4061 77.1965 92.4455C77.7162 101.633 77.9754 110.841 77.5986 120.038C78.2205 115.363 77.8992 110.644 78.1228 105.951L78.1229 105.952ZM70.5724 73.4804C69.4725 70.7442 72.0642 74.9633 70.5724 73.4804V73.4804ZM83.6754 170.783C80.7569 166.523 88.8174 157.2 87.7104 166.741C88.4123 169.458 85.635 178.305 83.6754 170.783ZM88.8268 173.745C90.1295 160.788 85.7328 148.22 83.3067 135.659C80.9206 108.996 79.1155 82.0138 83.3568 55.4193C85.9761 57.2524 85.3344 73.0511 89.0843 65.8396C88.582 58.7379 97.831 57.8749 94.8823 65.9659C97.0735 97.3088 96.0621 128.744 97.6246 160.109C95.0997 128.696 96.7469 97.1124 93.4965 65.7361C87.9192 63.3338 89.787 81.6005 84.8613 71.8473C79.9245 85.7957 82.2284 100.709 82.2707 115.092C83.6179 134.259 90.3958 153.063 89.0908 172.356L88.8268 173.745ZM98.8343 164.231C97.1827 140.693 96.5731 91.6385 96.867 55.2219C99.6149 33.8264 101.091 12.1854 99.1075 -9.32565C103.909 -6.38454 99.9137 10.7857 101.2 -1.78027C100.622 -7.95788 102.718 -8.40949 102.195 -2.07375C101.737 20.0426 103.007 42.2013 100.658 64.2616C99.8553 73.8231 101.963 83.2432 100.191 92.7803C99.6978 119.18 102.202 145.56 101.934 171.968C97.2494 176.284 99.5864 165.99 98.8343 164.231L98.8343 164.231ZM101.198 161.359C100.521 156.16 101.203 149.284 99.8985 145.125C100.293 150.532 99.1993 156.126 101.198 161.359ZM106.404 173.206C104.665 145.165 105.643 116.395 106.215 81.8379C108.295 56.9063 110.71 31.801 107.177 6.87585C106.075 2.77504 107.679 -14.0561 108.702 -2.59483C109.641 11.5442 110.293 25.7099 110.626 39.8744C110.695 48.7355 110.549 57.5959 110.427 66.456C115.285 56.7868 111.806 45.6636 112.83 35.4049C111.671 22.8716 111.427 10.2928 109.914 -2.18199C113.562 -12.2852 114.316 4.01321 114.266 7.54251C117.871 67.5739 109.065 119.004 112.593 173.205C103.953 138.782 112.717 100.652 111.875 68.1554C106.674 80.7078 110.381 91.8679 107.378 112.208C106.932 126.591 107.247 141.004 108.606 155.341C104.098 161.769 114.034 167.199 106.404 173.21L106.404 173.206ZM122.526 173.386C121.789 158.205 117.689 143.25 118.682 127.983C117.675 84.0816 122.269 40.2876 122.475 -3.59966C126.306 -8.41596 123.137 7.35978 123.426 10.3624C122.501 48.0642 118.651 94.3604 120.353 136.603C119.075 147.034 125.878 153.896 124.539 164.17C124.234 167.189 127.435 172.209 122.526 173.388L122.526 173.386ZM126.603 172.488C128.675 156.603 124.66 140.891 121.842 125.345C119.574 104.428 121.385 83.4103 121.924 62.4593C124.341 74.206 121.885 86.2388 122.747 98.1137C122.698 112.067 125.485 125.82 127.889 139.513C128.82 150.609 128.748 161.795 127.313 172.852L126.844 172.895L126.603 172.488ZM129.689 173.648C130.825 151.041 130.396 128.199 125.309 105.998C123.326 73.3837 123.88 40.5893 128.326 8.15402C128.046 4.09916 127.344 -9.45152 133.964 -5.45661C133.475 10.3762 129.666 25.9075 127.89 41.6114C126.281 95.7732 126.97 93.9064 131.517 110.348C132.497 123.305 133.815 136.397 133.83 149.317C133.249 157.553 136.872 168.494 130.032 173.339L129.91 173.641L129.689 173.652L129.689 173.648ZM135.948 148.884C136.567 104.9 129.595 60.7721 135.974 16.9315C135.978 11.0299 135.475 -4.64599 137.537 -4.2852C135.734 35.6854 133.381 75.7494 136.572 115.713C137.292 135.063 137.838 154.423 137.579 173.788C133.246 165.94 137.45 157.129 135.948 148.882V148.884ZM150.536 172.488C150.503 159.376 151.404 146.269 152.998 133.243C164.419 137.504 154.538 150.862 156.722 159.178C156.543 163.059 158.649 175.362 150.536 172.49V172.488ZM159.426 172.488C160.306 167.92 161.422 152.713 161.41 164.838C161.349 167.469 160.94 170.197 159.426 172.488ZM171.777 171.411C171.046 125.284 179.933 79.1132 173.376 33.0684C170.855 19.2721 171.267 5.31293 171.861 -8.60752C176.133 8.08007 172.301 26.1405 175.425 30.979C178.609 67.9556 176.452 105.061 175.869 142.085C173.728 151.823 174.961 164.86 172.042 172.753L171.777 171.411ZM174.706 169.616C176.317 157.619 180.469 145.772 177.854 133.616C177.146 104.476 177.862 75.3294 177.99 46.1897C178.536 85.9521 178.525 125.829 178.923 165.527C178.986 168.097 173.738 177.375 174.706 169.619L174.706 169.616ZM177.925 124.39C176.715 125.042 179.197 125.15 177.925 124.39V124.39ZM184.426 165.858C186.518 163.018 182.365 156.697 182.874 163.475C184.459 139.106 187.292 114.494 182.703 90.2505C181.485 69.0094 183.71 47.7489 183.256 26.4748C184.151 15.0674 181.644 2.73942 185.198 -8.10729C194.713 -14.4651 203.783 -3.4127 198.382 4.47697C200.478 55.5586 199.843 106.687 199.355 157.794C200.926 165.022 196.708 174.937 188.041 173.785C184.708 172.516 183.362 168.816 184.427 165.856L184.426 165.858ZM193.876 72.9564C195.041 50.0464 194.232 27.0803 192.177 4.23019C187.288 13.0514 191.232 23.6781 189.416 33.1994C189.548 47.3884 190.995 61.5468 193.24 75.5789C193.623 74.7315 193.816 73.8693 193.876 72.9549V72.9564ZM192.199 69.5759C191.689 67.4643 193.092 70.2413 192.199 69.5759V69.5759ZM199.059 35.0002C197.849 35.6523 200.33 35.7602 199.059 35.0002V35.0002ZM199.059 33.5642C197.849 34.2163 200.33 34.3242 199.059 33.5642V33.5642ZM124.87 171.889C124.36 169.778 125.762 172.554 124.87 171.889V171.889ZM83.2559 166.02C81.2205 162.074 85.2599 165.907 83.2559 166.02V166.02ZM144.293 160.484C139.194 161.511 146.483 152.953 140.74 156.082C139.867 120.814 137.69 85.543 138.201 50.2608C138.625 41.0569 139.893 31.7621 139.655 22.6332C145.768 15.8022 143.608 31.0003 145.033 34.8854C145.569 43.9543 147.15 52.8765 149.34 61.6963C154.87 82.2043 156.855 40.7941 158.285 33.7965C160.19 26.6636 157.761 16.3515 163.502 11.2354C166.655 18.9876 166.025 27.797 167.888 35.9422C171.672 63.2906 172.963 91.4862 166.983 118.558C161.396 108.332 161.315 95.7973 157.852 84.6821C160.288 91.9116 153.738 78.4244 153.642 87.5359C151.446 102.073 149.387 116.643 147.187 131.19C145.808 140.906 145.428 150.842 144.688 160.515L144.293 160.483L144.293 160.484ZM142.304 129.417C141.094 130.069 143.575 130.177 142.304 129.417V129.417ZM147.379 80.2779C145.47 68.7771 144.341 57.169 141.965 45.7342C137.995 57.4307 140.189 69.9737 140.207 82.0252C140.766 92.4188 140.354 102.891 142.132 113.202C150.307 117.988 147.616 83.2899 147.379 80.2772L147.379 80.2779ZM167.145 98.2827C171.159 74.4159 168.7 50.0731 163.961 26.4547C156.046 36.4893 160.495 49.3913 158.413 60.7439C159.143 73.5428 160.777 86.6796 167.145 98.2805L167.145 98.2827ZM59.0763 160.217C58.4642 157.466 60.4885 161.287 59.0763 160.217V160.217ZM134.475 155.259C134.978 150.444 135.188 157.725 134.475 155.259V155.259ZM169.202 146.73C168.221 141.57 170.888 139.946 170.052 146.47C170.192 150.979 168.539 154.131 169.202 146.73ZM161.197 152.588C159.347 148.207 162.098 138.391 161.669 148.686C161.688 149.995 161.656 151.332 161.197 152.588ZM45.7658 149.985C45.2736 147.802 47.0145 151.01 45.7658 149.985V149.985ZM108.862 148.168C108.817 145.415 109.411 149.668 108.862 148.168V148.168ZM108.892 145.476C109.188 142.559 109.188 148.393 108.892 145.476V145.476ZM52.0591 144.967C51.5493 142.856 52.9517 145.633 52.0591 144.967V144.967ZM108.876 142.605C109.092 140.132 109.092 145.079 108.876 142.605V142.605ZM2.02925 130.22C5.70827 87.4059 1.56496 93.4083 2.66467 128.881C2.54262 132.044 1.85075 136.614 2.02925 130.22ZM90.2283 133.046C90.2935 126.272 85.4739 108.778 90.4231 108.263C92.5325 116.312 94.3422 124.408 90.2283 133.046ZM16.6612 126.9C15.5932 118.211 18.1805 123.008 16.9711 128.849L16.6612 126.9ZM18.2329 118.314C15.5588 116.839 19.1239 115.921 18.2329 118.314V118.314ZM55.1585 112.85C52.0285 94.4682 52.1203 75.7623 51.6071 57.2022C51.2732 37.6918 49.7215 33.2115 55.3577 -4.74981C57.7968 -0.204562 52.5186 13.7109 53.1326 21.6648C52.1768 41.2204 52.6026 60.8313 52.9567 80.3894C58.3993 90.0503 45.1753 106.829 55.1585 112.847L55.1585 112.85ZM15.6231 88.8764C4.92394 145.706 10.2733 117.291 15.6231 88.8764V88.8764ZM73.7088 83.5812C70.9368 81.593 74.7813 80.9756 73.7088 83.5812V83.5812ZM109.989 72.811C109.48 70.6994 110.882 73.4763 109.989 72.811V72.811ZM110.381 67.426C109.871 65.3144 111.273 68.0914 110.381 67.426V67.426ZM91.9831 65.6311C91.4734 63.5194 92.8757 66.2964 91.9831 65.6311V65.6311ZM170.631 60.5548C172.122 59.2622 170.336 63.038 170.631 60.5548V60.5548ZM122.335 48.909C122.736 30.3834 123.588 11.8175 126.484 -6.53797C129.652 3.44535 123.742 13.34 124.309 23.4264C123.574 33.7411 123.884 44.1272 122.304 54.3841C122.157 52.56 122.349 50.7345 122.335 48.9094L122.335 48.909ZM199.625 45.8874C199.115 43.7758 200.518 46.5528 199.625 45.8874V45.8874ZM177.538 45.408C176.892 31.4926 173.78 23.9146 174.539 -5.90331C179.797 -4.55104 175.628 8.35639 177.151 14.0418C177.513 24.489 178.849 34.9735 177.538 45.4095V45.408ZM176.736 11.6706C175.525 12.3227 178.007 12.4306 176.736 11.6706V11.6706ZM199.705 42.8089C200.001 39.8916 200.001 45.7263 199.705 42.8089V42.8089ZM83.5261 39.5418C82.2523 34.8483 85.0539 41.3064 83.5261 39.5418V39.5418ZM95.0853 38.892C92.9676 24.376 91.0417 9.83592 89.2019 -4.71169C93.6416 2.24925 91.4078 11.8416 92.9909 19.8182C92.5879 24.6531 98.2307 30.205 98.3904 22.0075C99.6949 14.9952 96.957 0.633551 98.4307 -1.95015C99.0501 11.5345 100.135 25.3102 96.3737 38.5195C97.3539 35.0291 95.9116 38.8757 95.0852 38.8925L95.0853 38.892ZM132.924 38.6198C133.193 31.0023 134.404 14.3047 135.341 12.5513C135.122 21.2767 134.147 29.9698 132.924 38.6198ZM62.305 36.6023C62.5533 32.1791 66.2526 22.1638 64.3614 32.4591C64.1123 33.9669 63.578 35.539 62.305 36.6023ZM199.207 31.5009C199.708 28.4493 199.806 34.9939 199.207 31.5009V31.5009ZM95.5303 27.7638C94.3886 26.0699 97.7046 28.4525 95.5303 27.7638V27.7638ZM199.305 23.962C199.416 20.6033 199.693 26.1574 199.305 23.962V23.962ZM42.6312 21.6461C40.1378 6.85406 43.9465 -16.6444 45.4887 9.96332C44.9681 13.8627 44.839 18.1685 42.6312 21.6461ZM151.678 16.8819C152.019 10.1202 145.963 -6.85135 155.096 -6.10715C157.456 1.73226 152.293 9.1843 151.678 16.8819ZM164.789 16.8121C164.279 14.7005 165.682 17.4775 164.789 16.8121V16.8121ZM89.0731 14.987C89.8647 13.4233 89.3823 17.5908 89.0731 14.987V14.987ZM45.4042 9.9908C44.8944 7.87919 46.2968 10.6562 45.4042 9.9908V9.9908ZM127.998 0.656897C127.488 -1.45472 128.89 1.32226 127.998 0.656897V0.656897Z"
            fill="#eccba1"
            transform={`scale(${data.w / 200} 1)`}
          />
        </g>
      </svg>
    </figure>
  )
}
