var vile = require("./../../../../../../../lib")

var log = vile.logger.create("logging")

function punish(config) {
  log.error("error on stderr")
  log.warn("warn on stderr")
  log.info("info on stdout")
  return [
    {
      type: vile.WARN,
      path: "a.ext",
      title: "a title header",
      message: "warning msg",
      where: {
        start: { line: 1 },
        end: { line: 2 }
      }
    },
    {
      type: vile.MAIN,
      path: "a.ext",
      message: "maintainability msg",
      where: {
        start: { line: 1, character: 1 },
        end: { line: 2, character: 1 }
      }
    },
    {
      type: vile.COMP,
      path: "a.ext",
      complexity: 100
    },
    {
      type: vile.CHURN,
      path: "a.ext",
      churn: 50
    },
    {
      type: vile.DUPE,
      path: "a.ext",
      duplicate: {
        locations: [
          {
            path: "a.ext",
            where: {
              start: {
                line: 1,
                character: 1
              }
            }
          },
          {
            path: "a.ext",
            where: {
              start: {
                line: 4,
                character: 1
              }
            }
          }
        ]
      }
    },
    {
      type: vile.DEP,
      path: "a.ext",
      dependency: {
        name: "dep",
        current: "0.0.1",
        latest: "0.1.0"
      }
    },
    {
      type: vile.ERR,
      path: "a.ext",
      title: "error msg",
      message: "error msg"
    },
    {
      type: vile.SEC,
      path: "a.ext",
      title: "sec msg",
      // NOTE: this will eventually be used to log
      security: {
        package: "package",
        version: "version",
        advisory: "http://sec.io",
        patched: [ "1.0.0" ],
        vulnerable: [ "0.2.0" ]
      }
    },
    {
      type: vile.STAT,
      path: "a.ext",
      stat: {
        size: 99,
        loc: 80,
        lines: 100,
        comments: 3,
        language: "Ext"
      }
    },
    {
      type: vile.SCM,
      path: "a.ext",
      commit: {
        sha: "sha",
        branch: "branch",
        message: "msg",
        committer: "committer",
        commit_date: "commit_date",
        author: "author",
        author_date: "author_date"
      }
    },
    {
      type: vile.COV,
      path: "a.ext",
      coverage: {
        total: 90
      }
    },
    {
      type: vile.OK,
      path: "b.ext",
      message: "ok msg"
    }
  ]
}

module.exports = {
  punish: punish
}
