var Bluebird = require("bluebird")
var vile = require("./../../../../../../../lib")
var _ = require("lodash")

function punish(config) {
  var issues = []

  return vile.promise_each(
    process.cwd(),
    vile.filter(config.ignore, config.allow),
    function (filepath) { return filepath },
    { read_data: false }
  )
  .then(function (filepaths) {
    return _.map(filepaths, function (filepath, idx) {
      return vile.issue({
        type: vile.WARN,
        path: filepath
      })
    })
  })
}

module.exports = {
  punish: punish
}
