"use strict";
var frameworks = {
    bower: ["constable"],
    brakeman: ["brakeman"],
    bundler: ["bundler-outdated", "bundler-audit"],
    coffeelint: ["coffeelint"],
    editorconfig: ["eclint"],
    eslint: ["eslint"],
    git: ["git"],
    jshint: ["jshint"],
    nodejs: ["nsp"],
    rails: ["brakeman", "rails-best-practices"],
    retirejs: ["retire"],
    rubocop: ["rubocop"],
    sass_lint: ["sass-lint"],
    slim_lint: ["slim-lint"],
    tslint: ["tslint"]
};
var langs = {
    haskell: ["hlint"],
    ruby: ["rubocop"],
    sass: ["sass-lint"],
    scss: ["sass-lint"],
    slim: ["slim-lint"]
};
var peer = {
    "brakeman": { gem: "brakeman" },
    "bundler-audit": { gem: ["bundler", "bundler-audit"] },
    "bundler-outdated": { gem: "bundler" },
    "hlint": { cabal: "hlint" },
    "rails-best-practices": { gem: "rails_best_practices" },
    "retire": { npm: "retire" },
    "rubocop": { gem: "rubocop" },
    "slim-lint": { gem: "slim_lint" }
};
var DEFAULT_IGNORE_DIRS = [
    "app/assets/images",
    "app/assets/videos",
    "bin",
    "bower_components",
    ".bundle",
    "cabal.sandbox.config",
    ".cabal-sandbox",
    "coverage",
    "db",
    "doc",
    "dist",
    ".git",
    ".gitattributes",
    ".gitignore",
    ".gitmodules",
    "log",
    "node_modules",
    ".nyc_output",
    "tmp",
    "tags",
    "vendor"
];
var PLUGIN_MAP = {
    frameworks: frameworks,
    ignore: DEFAULT_IGNORE_DIRS,
    langs: langs,
    peer: peer
};
module.exports = PLUGIN_MAP;
