module.exports = {
  docs: {
    'Getting Started': [
      'getting-started/installation',
      'getting-started/application-workflow',
      'getting-started/message-declaration',
      'getting-started/message-extraction',
      'getting-started/message-distribution',
    ],
    Guides: [
      'guides/develop',
      'guides/bundler-plugins',
      'guides/testing',
      'guides/distribute-libraries',
      'guides/runtime-requirements',
      'guides/advanced-usage',
    ],
    'Core Concepts': [
      'core-concepts/basic-internationalization-principles',
      'core-concepts/icu-syntax',
    ],
  },
  api: {
    'react-intl': [
      'react-intl',
      'react-intl/components',
      'react-intl/api',
      'react-intl/upgrade-guide-5x',
      'react-intl/upgrade-guide-4x',
      'react-intl/upgrade-guide-3x',
      'react-intl/upgrade-guide-2x',
    ],
    '@formatjs/intl': ['intl'],
    'vue-intl': ['vue-intl'],
    'intl-messageformat': ['intl-messageformat'],
    'icu-messageformat-parser': ['icu-messageformat-parser'],
  },
  polyfills: {
    Polyfills: [
      'polyfills',
      'polyfills/intl-datetimeformat',
      'polyfills/intl-displaynames',
      'polyfills/intl-durationformat',
      'polyfills/intl-getcanonicallocales',
      'polyfills/intl-listformat',
      'polyfills/intl-locale',
      'polyfills/intl-localematcher',
      'polyfills/intl-numberformat',
      'polyfills/intl-pluralrules',
      'polyfills/intl-relativetimeformat',
      'polyfills/intl-segmenter',
      'polyfills/intl-supportedvaluesof',
    ],
  },
  tooling: {
    Tooling: [
      'tooling/cli',
      'tooling/linter',
      'tooling/babel-plugin',
      'tooling/ts-transformer',
      'tooling/swc-plugin',
    ],
  },
}
