---
id: intl-pluralrules
title: Intl.PluralRules
---

A spec-compliant polyfill for [`Intl.PluralRules`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/PluralRules) fully tested by the [official ECMAScript Conformance test suite](https://github.com/tc39/test262)

[![npm Version](https://img.shields.io/npm/v/@formatjs/intl-pluralrules.svg?style=flat-square)](https://www.npmjs.org/package/@formatjs/intl-pluralrules)
![size](https://badgen.net/bundlephobia/minzip/@formatjs/intl-pluralrules)

## Installation

import Tabs from '@theme/Tabs'
import TabItem from '@theme/TabItem'

<Tabs
groupId="npm"
defaultValue="npm"
values={[
{label: 'npm', value: 'npm'},
{label: 'yarn', value: 'yarn'},
]}>
<TabItem value="npm">

```sh
npm i @formatjs/intl-pluralrules
```

</TabItem>
<TabItem value="yarn">

```sh
yarn add @formatjs/intl-pluralrules
```

</TabItem>
</Tabs>

## Requirements

- [`Intl.getCanonicalLocales`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/getCanonicalLocales) or [polyfill](intl-getcanonicallocales.md)
- [`Intl.Locale`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/Locale) or [polyfill](intl-locale.md).

## Usage

### Via polyfill-fastly.io

You can use [polyfill-fastly.io URL Builder](https://polyfill-fastly.io/) to create a polyfill script tag for `Intl.PluralRules`. By default the created URL does not come with any locale data. In order to add locale data, append `Intl.PluralRules.~locale.<locale>` to your list of features. For example:

```html
<!-- Polyfill Intl.PluralRules, its dependencies & `en` locale data -->
<script src="https://polyfill-fastly.io/v3/polyfill.min.js?features=Intl.PluralRules,Intl.PluralRules.~locale.en"></script>
```

### Simple

```tsx
import '@formatjs/intl-pluralrules/polyfill'
import '@formatjs/intl-pluralrules/locale-data/en' // locale-data for en
```

### React Native

The polyfill conditional detection code runs [very slowly on Android](https://github.com/formatjs/formatjs/issues/4463) and can slow down your app's startup time by seconds. Since React Native uses Hermes which does not support `Intl.PluralRules`, import `/polyfill-force` instead for much better performance:

```tsx
import '@formatjs/intl-pluralrules/polyfill-force' // instead of /polyfill
import '@formatjs/intl-pluralrules/locale-data/en'
```

### Dynamic import + capability detection

```tsx
import {shouldPolyfill} from '@formatjs/intl-pluralrules/should-polyfill'
async function polyfill(locale: string) {
  const unsupportedLocale = shouldPolyfill(locale)
  // This locale is supported
  if (!unsupportedLocale) {
    return
  }
  // Load the polyfill 1st BEFORE loading data
  await import('@formatjs/intl-pluralrules/polyfill-force')
  await import(`@formatjs/intl-pluralrules/locale-data/${unsupportedLocale}`)
}
```
