# ウェイト

ウェイト（weight）はフォントの太さのことです。太いウェイトを「重い」、細いウェイトを「軽い」と表現することもあります。ファミリーの多くは複数のウェイトから構成されます。ウェイトごとの名称はファミリーによって異なり、「ライト」「ノーマル」「ミディアム」「ボールド」「ヘヴィ」など様々です。

![Noto Sansのウェイトのバリエーションの一部](../images/weight.png)

## 用法

Webでは、見出しや重要な語句など、目立たせたい部分をボールドにする（太くする）ことがよくあります。また、タグラインやリード文などのテキストに軽い（細い）ウェイトを使い、洗練されたイメージを狙うこともあります。

## 実践

CSSでウェイトを指定するには`font-weight`プロパティを利用します。値には100から900までの100単位の数値（CSS Fonts Module Level 4では、1から1000までの任意の数値）と、`normal`／`bold`、`lighter`／`bolder`というキーワードが指定できます。

```css
.Headline {
  font-weight: 700;
}
```

## 発展

ボールドのウェイトを利用しようと思っても、ファミリーがボールドを持っていなかったり、Webフォントでボールドがダウンロードされていなかったりすることがあります。そういった場合にCSSでボールドを指定すると、ブラウザは利用可能なウェイトを機械的に太らせて擬似的なボールドとして表示することがあります。しかし本来ファミリーのウェイトは、ひとつのウェイトを機械的に太くしたり細くしたりして作られるものではなく、ウェイトごとに独自にデザインされたものです。そのためブラウザによる擬似的なボールドは「にせボールド（faux bold）」と呼ばれます。にせボールドは本来の適切にデザインされた形ではないため、読みづらく、不格好なものになりがちです。CSSでウェイトを指定する際は、そのウェイトが利用可能なことを確認しましょう。

## 関連項目

- [イタリック](./italic.md)

## 参考資料

- [Say No to Faux Bold · An A List Apart Article](https://alistapart.com/article/say-no-to-faux-bold)
- [font-weight | MDN](https://developer.mozilla.org/ja/docs/Web/CSS/font-weight)
