# セリフ体

セリフ体（serif）は欧文書体の分類のひとつで、線の末端にセリフ（ヒゲのような飾り）があり、線に太い部分と細い部分があるのが特徴です。ローマン体とも呼ばれます。日本語書体では明朝体が相当します。

![セリフ体](../images/serif.png)

## 用法

長文を読むのに適していて、小説など書籍の本文ではセリフ体が多く使われています。

## 実践

Webでセリフ体を表示するには、CSSの`font-family`プロパティで具体的なファミリー名を指定するとともに、フォールバックとして`serif`キーワードも指定するとよいでしょう。

```css
body {
  font-family: "Georgia", "Times", serif;
}
```

上記コード例では、第1候補のGeorgiaと第2候補のTimesがともに利用できない場合、ブラウザーの設定に応じて利用可能なセリフ体が選ばれます。

## 関連項目

- [ローマン体](./roman.md)
- [サンセリフ体](./sans-serif.md)
- [明朝体](./mincho.md)
