# サンセリフ体

サンセリフ体（sans-serif）は欧文書体の分類のひとつで、セリフのない書体をいいます。日本語書体ではゴシック体が相当します。

![サンセリフ体](../images/sans-serif.png)

## 用法

字形が簡素であるため悪条件でも判読しやすいという特徴があり、駅や空港の案内板や道路標識など、公共のサインでも多く用いられています。Webにおいても、解像度の低いスクリーンや小さな文字サイズを考慮し、サンセリフ体が採用されることが多いようです。

## 実践

Webでサンセリフ体を表示するには、CSSの`font-family`プロパティで具体的なファミリー名を指定するとともに、フォールバックとして`sans-serif`キーワードも指定するとよいでしょう。

```css
body {
  font-family: "Helvetica Neue", "Arial", sans-serif;
}
```

上記コード例では、第1候補のHelvetica Neueと第2候補のArialがともに利用できない場合、ブラウザーの設定に応じて利用可能なサンセリフ体が選ばれます。

## 関連項目

- [セリフ体](./serif.md)
- [ゴシック体](./gothic.md)

## 参考資料

- 小林章『欧文書体　その背景と使い方』美術出版社、2005
- 髙岡昌夫『欧文組版　組版の基礎とマナー』美術出版社、2010
