## 等幅フォント

等幅フォント（monospaced font）または固定幅フォント（fixed-width font）は、全てのグリフの幅が同じであるフォントをいいます。

![等幅フォントとプロポーショナルフォントの比較](../images/monospaced-font.png)

## 用法

コンピューターのソースコードを表示する場合に多く用いられます。また、タイプライター風の効果を狙って利用されることもあります。

## 実践

Webで等幅フォントを表示するには、CSSの`font-family`プロパティで具体的なファミリー名を指定するとともに、フォールバックとして`monospace`キーワードも指定するとよいでしょう。

```css
pre, code, kbd, samp {
  font-family: "Menlo", "Consolas", monospace;
}
```

上記コード例では、第1候補のMenloと第2候補のConsolasがともに利用できない場合、ブラウザーの設定に応じて利用可能な等幅フォントが選ばれます。

## 関連項目

- [グリフ](./glyph.md)
