# 明朝体

明朝体は日本語書体の分類のひとつで、線の末端に飾り（ウロコ）があり、横画と縦画で太さが違うことが特徴です。欧文書体ではセリフ体が相当します。

![明朝体](../images/mincho.png)

## 用法

長文を読むのに適しているとされ、小説など書籍の本文の多くは明朝体を採用しています。Webにおいては、小さい文字サイズや低解像度のスクリーンで判別しづらいことがあったり、OSに高品位な明朝体フォントが搭載されていなかったことなどから、あまり利用されてきませんでした。しかし近年、スマートフォンをはじめ画面が高精細になり、またスクリーンに最適化されたフォントが多く開発されたことなどから、利用される場面が増えてきました。

## 実践

Webで明朝体を表示するには、CSSの`font-family`プロパティで具体的なファミリー名を指定するとともに、フォールバックとして`serif`キーワードも指定するとよいでしょう。

```css
body {
  font-family: "Hiragino Mincho ProN", "Yu Mincho", serif;
}
```

上記コード例では、第1候補のヒラギノ明朝と第2候補の游明朝がともに利用できない場合、ブラウザーの設定に応じて利用可能な明朝体が選ばれます。

## 関連項目

- [セリフ体](./serif.md)
- [ゴシック体](./gothic.md)
