# 禁則

禁則（line-breaking rules）は日本語（和文）における行の折り返しのルールです。特定の文字が行頭に配置されることを禁止するルールを行頭禁則、行末に配置されることを禁止するルールを行末禁則といいます。また、特定の連続する文字間での折り返しを禁止するルールを分割禁止といいます。

どの文字を禁則の対象とするかは方針によりますが、以下にその一例を示します。

- 行頭禁則：終わり括弧類、句読点、感嘆符・疑問符、中点類（・：；）など
- 行末禁則：始め括弧類
- 分割禁止：連続するダッシュ・リーダー、連続するアラビア数字、省略記号とその前後のアラビア数字など

## 実践

CSSで禁則をコントロールするプロパティとして`line-break`があります。`loose`・`normal`・`strict`といったキーワードで禁則の程度を指定します。初期値は`auto`で、ブラウザーの判断に委ねます。

なお、`word-break`プロパティに`break-all`を指定すると、環境によって禁則が無効になることがあります。終わり括弧類や句読点が行頭に配置されたり、始め括弧類が行末に配置されたりなど、不自然な体裁になってしまうため、この指定は避けるべきです。

## 関連項目

- [ぶら下げ](./hanging-punctuation.md)

## 参考資料

- [line-break - CSS: カスケーディングスタイルシート | MDN](https://developer.mozilla.org/ja/docs/Web/CSS/line-break)
- [word-break - CSS: カスケーディングスタイルシート | MDN](https://developer.mozilla.org/ja/docs/Web/CSS/word-break)
