# 両端揃え

両端揃え（justified）は行揃えの方法のひとつで、単語間や字間を調整して各行の文字列を行頭と行末の両方に揃えるものです。行頭行末揃えともいいます。

![両端揃え](../images/justified.png)

## 実践

CSSで中法揃えにするには、`text-align`プロパティで`justify`を指定します。

```css
p {
  text-align: justify;
}
```

ただし、日本語の中に折り返しのできない長い欧文単語がある場合など、字間が意図しない間隔になってしまう場合があります。とくに画面の幅が狭いとその可能性が高まります。採用には注意が必要です。

## 関連項目

- [行揃え](./text-alignment.md)
- [行頭揃え](./flush-left.md)
- [行末揃え](./flush-right.md)
- [中央揃え](./centered.md)
